/*
 * Decompiled with CFR 0.152.
 */
package almaligner;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JProgressBar;
import org.apache.commons.lang3.SystemUtils;

public class ProgressBarUpdater
implements Runnable {
    private final JProgressBar jProgressBar;
    private final int seconds;
    private boolean complete;

    public ProgressBarUpdater(JProgressBar jProgressBar, int seconds) {
        this.jProgressBar = jProgressBar;
        this.seconds = seconds;
        this.complete = false;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public void run() {
        if (this.seconds > 0) {
            this.determinate();
        } else {
            this.indeterminate();
        }
    }

    private void determinate() {
        this.jProgressBar.setMinimum(0);
        this.jProgressBar.setMaximum(this.seconds * 1000);
        Date startTime = new Date();
        startTime.getTime();
        while (true) {
            if (this.complete) {
                this.cleanup();
                return;
            }
            try {
                Long elapsed = new Date().getTime() - startTime.getTime();
                if (elapsed.intValue() <= this.jProgressBar.getMaximum()) {
                    this.jProgressBar.setValue(elapsed.intValue());
                }
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ProgressBarUpdater.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    private void indeterminate() {
        while (true) {
            if (this.complete) {
                this.cleanup();
                return;
            }
            if (SystemUtils.IS_OS_MAC) {
                int span = 100;
                int currentValue = this.jProgressBar.getValue() + span / 10;
                if (currentValue >= this.jProgressBar.getMaximum()) {
                    currentValue = 0;
                }
                this.jProgressBar.setValue(currentValue);
            } else {
                this.jProgressBar.setIndeterminate(true);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ProgressBarUpdater.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }

    private void cleanup() {
        this.jProgressBar.setIndeterminate(false);
        this.jProgressBar.setValue(this.jProgressBar.getMaximum());
    }
}

