/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class CpioArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void testCpioUnarchive() throws Exception {
        CpioArchiveEntry entry;
        StringBuilder expected = new StringBuilder();
        expected.append("./test1.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>./test2.xml<?xml version=\"1.0\"?>\n");
        expected.append("<empty/>\n");
        CpioArchiveInputStream in = new CpioArchiveInputStream((InputStream)new FileInputStream(CpioArchiveInputStreamTest.getFile("bla.cpio")));
        StringBuilder result = new StringBuilder();
        while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
            int tmp;
            result.append(entry.getName());
            while ((tmp = in.read()) != -1) {
                result.append((char)tmp);
            }
        }
        in.close();
        Assert.assertEquals((Object)result.toString(), (Object)expected.toString());
    }

    @Test
    public void testCpioUnarchiveCreatedByRedlineRpm() throws Exception {
        CpioArchiveInputStream in = new CpioArchiveInputStream((InputStream)new FileInputStream(CpioArchiveInputStreamTest.getFile("redline.cpio")));
        CpioArchiveEntry entry = null;
        int count = 0;
        while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
            ++count;
            Assert.assertNotNull((Object)entry);
        }
        in.close();
        Assert.assertEquals((long)count, (long)1L);
    }

    @Test
    public void testCpioUnarchiveMultibyteCharName() throws Exception {
        CpioArchiveInputStream in = new CpioArchiveInputStream((InputStream)new FileInputStream(CpioArchiveInputStreamTest.getFile("COMPRESS-459.cpio")), "UTF-8");
        CpioArchiveEntry entry = null;
        int count = 0;
        while ((entry = (CpioArchiveEntry)in.getNextEntry()) != null) {
            ++count;
            Assert.assertNotNull((Object)entry);
        }
        in.close();
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (FileInputStream in = new FileInputStream(CpioArchiveInputStreamTest.getFile("bla.cpio"));
             CpioArchiveInputStream archive = new CpioArchiveInputStream((InputStream)in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read());
            Assert.assertEquals((long)-1L, (long)archive.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (FileInputStream in = new FileInputStream(CpioArchiveInputStreamTest.getFile("bla.cpio"));
             CpioArchiveInputStream archive = new CpioArchiveInputStream((InputStream)in);){
            ArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
        }
    }
}

