/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.BinaryTree;
import org.apache.commons.compress.archivers.zip.BitStream;
import org.junit.Assert;
import org.junit.Test;

public class BinaryTreeTest {
    @Test
    public void testDecode() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{2, 66, 1, 19});
        BinaryTree tree = BinaryTree.decode((InputStream)in, (int)8);
        Assert.assertNotNull((Object)tree);
        BitStream stream = new BitStream((InputStream)new ByteArrayInputStream(new byte[]{-115, -59, 17, 0}));
        Assert.assertEquals((long)0L, (long)tree.read(stream));
        Assert.assertEquals((long)1L, (long)tree.read(stream));
        Assert.assertEquals((long)2L, (long)tree.read(stream));
        Assert.assertEquals((long)3L, (long)tree.read(stream));
        Assert.assertEquals((long)4L, (long)tree.read(stream));
        Assert.assertEquals((long)5L, (long)tree.read(stream));
        Assert.assertEquals((long)6L, (long)tree.read(stream));
        Assert.assertEquals((long)7L, (long)tree.read(stream));
    }

    @Test
    public void testExceptions() {
        BinaryTree binaryFinary = new BinaryTree(4);
        binaryFinary.addLeaf(0, 0, 0, 1);
        try {
            binaryFinary.addLeaf(0, 0, 0, 1);
            Assert.fail((String)"should have thrown illegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        try {
            BinaryTree.decode((InputStream)is, (int)0);
            Assert.fail((String)"should have thrown IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        binaryFinary = new BinaryTree(4);
        try {
            binaryFinary.read(new BitStream((InputStream)new ByteArrayInputStream(new byte[]{0})));
            Assert.fail((String)"expected read fail");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

