/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.X7875_NewUnix;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class X7875_NewUnixTest {
    private static final ZipShort X7875 = new ZipShort(30837);
    private X7875_NewUnix xf;

    @Before
    public void before() {
        this.xf = new X7875_NewUnix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSampleFile() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-211_uid_gid_zip_test.zip");
        try (ZipFile zf = null;){
            zf = new ZipFile(archive);
            Enumeration en = zf.getEntries();
            while (en.hasMoreElements()) {
                ZipArchiveEntry zae = (ZipArchiveEntry)en.nextElement();
                String name = zae.getName();
                X7875_NewUnix xf = (X7875_NewUnix)zae.getExtraField(X7875);
                long expected = 1000L;
                if (name.contains("uid555_gid555")) {
                    expected = 555L;
                } else if (name.contains("uid5555_gid5555")) {
                    expected = 5555L;
                } else if (name.contains("uid55555_gid55555")) {
                    expected = 55555L;
                } else if (name.contains("uid555555_gid555555")) {
                    expected = 555555L;
                } else if (name.contains("min_unix")) {
                    expected = 0L;
                } else if (name.contains("max_unix")) {
                    expected = 0xFFFFFFFEL;
                }
                Assert.assertEquals((long)expected, (long)xf.getUID());
                Assert.assertEquals((long)expected, (long)xf.getGID());
            }
        }
    }

    @Test
    public void testGetHeaderId() {
        Assert.assertEquals((Object)X7875, (Object)this.xf.getHeaderId());
    }

    @Test
    public void testMisc() throws Exception {
        Assert.assertFalse((boolean)this.xf.equals(new Object()));
        Assert.assertTrue((boolean)this.xf.toString().startsWith("0x7875 Zip Extra Field"));
        Object o = this.xf.clone();
        Assert.assertEquals((long)o.hashCode(), (long)this.xf.hashCode());
        Assert.assertTrue((boolean)this.xf.equals(o));
        this.xf.setUID(12345L);
        Assert.assertFalse((boolean)this.xf.equals(o));
    }

    @Test
    public void testTrimLeadingZeroesForceMinLength4() {
        byte[] NULL = null;
        byte[] EMPTY = new byte[]{};
        byte[] ONE_ZERO = new byte[]{0};
        byte[] TWO_ZEROES = new byte[]{0, 0};
        byte[] FOUR_ZEROES = new byte[]{0, 0, 0, 0};
        byte[] SEQUENCE = new byte[]{1, 2, 3};
        byte[] SEQUENCE_LEADING_ZERO = new byte[]{0, 1, 2, 3};
        byte[] SEQUENCE_LEADING_ZEROES = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 2, 3};
        byte[] TRAILING_ZERO = new byte[]{1, 2, 3, 0};
        byte[] PADDING_ZERO = new byte[]{0, 1, 2, 3, 0};
        byte[] SEQUENCE6 = new byte[]{1, 2, 3, 4, 5, 6};
        byte[] SEQUENCE6_LEADING_ZERO = new byte[]{0, 1, 2, 3, 4, 5, 6};
        Assert.assertTrue((NULL == X7875_NewUnixTest.trimTest(NULL) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(ONE_ZERO, X7875_NewUnixTest.trimTest(EMPTY)));
        Assert.assertTrue((boolean)Arrays.equals(ONE_ZERO, X7875_NewUnixTest.trimTest(ONE_ZERO)));
        Assert.assertTrue((boolean)Arrays.equals(ONE_ZERO, X7875_NewUnixTest.trimTest(TWO_ZEROES)));
        Assert.assertTrue((boolean)Arrays.equals(ONE_ZERO, X7875_NewUnixTest.trimTest(FOUR_ZEROES)));
        Assert.assertTrue((boolean)Arrays.equals(SEQUENCE, X7875_NewUnixTest.trimTest(SEQUENCE)));
        Assert.assertTrue((boolean)Arrays.equals(SEQUENCE, X7875_NewUnixTest.trimTest(SEQUENCE_LEADING_ZERO)));
        Assert.assertTrue((boolean)Arrays.equals(SEQUENCE, X7875_NewUnixTest.trimTest(SEQUENCE_LEADING_ZEROES)));
        Assert.assertTrue((boolean)Arrays.equals(TRAILING_ZERO, X7875_NewUnixTest.trimTest(TRAILING_ZERO)));
        Assert.assertTrue((boolean)Arrays.equals(TRAILING_ZERO, X7875_NewUnixTest.trimTest(PADDING_ZERO)));
        Assert.assertTrue((boolean)Arrays.equals(SEQUENCE6, X7875_NewUnixTest.trimTest(SEQUENCE6)));
        Assert.assertTrue((boolean)Arrays.equals(SEQUENCE6, X7875_NewUnixTest.trimTest(SEQUENCE6_LEADING_ZERO)));
    }

    private static byte[] trimTest(byte[] b) {
        return X7875_NewUnix.trimLeadingZeroesForceMinLength((byte[])b);
    }

    @Test
    public void testParseReparse() throws ZipException {
        byte[] ZERO_LEN = new byte[]{1, 0, 0};
        byte[] ZERO_UID_GID = new byte[]{1, 1, 0, 1, 0};
        byte[] ONE_UID_GID = new byte[]{1, 1, 1, 1, 1};
        byte[] ONE_THOUSAND_UID_GID = new byte[]{1, 2, -24, 3, 2, -24, 3};
        byte[] UNIX_MAX_UID_GID = new byte[]{1, 4, -2, -1, -1, -1, 4, -2, -1, -1, -1};
        byte[] LENGTH_5 = new byte[]{1, 5, 0, 0, 0, 0, 1, 5, 1, 0, 0, 0, 1};
        byte[] LENGTH_8 = new byte[]{1, 8, -2, -1, -1, -1, -1, -1, -1, 127, 8, -1, -1, -1, -1, -1, -1, -1, 127};
        long TWO_TO_32 = 0x100000000L;
        long MAX = 0xFFFFFFFEL;
        this.parseReparse(0L, 0L, ZERO_LEN, 0L, 0L);
        this.parseReparse(0L, 0L, ZERO_UID_GID, 0L, 0L);
        this.parseReparse(1L, 1L, ONE_UID_GID, 1L, 1L);
        this.parseReparse(1000L, 1000L, ONE_THOUSAND_UID_GID, 1000L, 1000L);
        this.parseReparse(0xFFFFFFFEL, 0xFFFFFFFEL, UNIX_MAX_UID_GID, 0xFFFFFFFEL, 0xFFFFFFFEL);
        this.parseReparse(-2L, -2L, UNIX_MAX_UID_GID, 0xFFFFFFFEL, 0xFFFFFFFEL);
        this.parseReparse(0x100000000L, 0x100000001L, LENGTH_5, 0x100000000L, 0x100000001L);
        this.parseReparse(0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE, LENGTH_8, 0x7FFFFFFFFFFFFFFEL, Long.MAX_VALUE);
        byte[] SPURIOUS_ZEROES_1 = new byte[]{1, 4, -1, 0, 0, 0, 4, -128, 0, 0, 0};
        byte[] EXPECTED_1 = new byte[]{1, 1, -1, 1, -128};
        this.xf.parseFromLocalFileData(SPURIOUS_ZEROES_1, 0, SPURIOUS_ZEROES_1.length);
        Assert.assertEquals((long)255L, (long)this.xf.getUID());
        Assert.assertEquals((long)128L, (long)this.xf.getGID());
        Assert.assertTrue((boolean)Arrays.equals(EXPECTED_1, this.xf.getLocalFileDataData()));
        byte[] SPURIOUS_ZEROES_2 = new byte[]{1, 4, -1, -1, 0, 0, 4, 1, 2, 0, 0};
        byte[] EXPECTED_2 = new byte[]{1, 2, -1, -1, 2, 1, 2};
        this.xf.parseFromLocalFileData(SPURIOUS_ZEROES_2, 0, SPURIOUS_ZEROES_2.length);
        Assert.assertEquals((long)65535L, (long)this.xf.getUID());
        Assert.assertEquals((long)513L, (long)this.xf.getGID());
        Assert.assertTrue((boolean)Arrays.equals(EXPECTED_2, this.xf.getLocalFileDataData()));
    }

    private void parseReparse(long uid, long gid, byte[] expected, long expectedUID, long expectedGID) throws ZipException {
        this.xf.setUID(54321L);
        this.xf.setGID(12345L);
        this.xf.parseFromLocalFileData(expected, 0, expected.length);
        Assert.assertEquals((long)expectedUID, (long)this.xf.getUID());
        Assert.assertEquals((long)expectedGID, (long)this.xf.getGID());
        this.xf.setUID(uid);
        this.xf.setGID(gid);
        if (expected.length < 5) {
            Assert.assertEquals((long)5L, (long)this.xf.getLocalFileDataLength().getValue());
        } else {
            Assert.assertEquals((long)expected.length, (long)this.xf.getLocalFileDataLength().getValue());
        }
        byte[] result = this.xf.getLocalFileDataData();
        if (expected.length < 5) {
            Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 1, 0, 1, 0}, result));
        } else {
            Assert.assertTrue((boolean)Arrays.equals(expected, result));
        }
        this.xf.parseFromLocalFileData(result, 0, result.length);
        Assert.assertEquals((long)expectedUID, (long)this.xf.getUID());
        Assert.assertEquals((long)expectedGID, (long)this.xf.getGID());
        Assert.assertEquals((long)0L, (long)this.xf.getCentralDirectoryLength().getValue());
        result = this.xf.getCentralDirectoryData();
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])result);
        this.xf.parseFromCentralDirectoryData(result, 0, result.length);
        Assert.assertEquals((long)expectedUID, (long)this.xf.getUID());
        Assert.assertEquals((long)expectedGID, (long)this.xf.getGID());
    }
}

