/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZipFileIgnoringLocalFileHeaderTest {
    private File dir;

    @Before
    public void setUp() throws Exception {
        this.dir = AbstractTestCase.mkdir("dir");
    }

    @After
    public void tearDown() throws Exception {
        AbstractTestCase.rmdir(this.dir);
    }

    @Test
    public void testZipUnarchive() throws Exception {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("bla.zip");){
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)e.nextElement();
                FileOutputStream out = new FileOutputStream(new File(this.dir, entry.getName()));
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)zf.getInputStream(entry), (OutputStream)out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
        }
    }

    @Test
    public void getEntryWorks() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("bla.zip");){
            ZipArchiveEntry ze = zf.getEntry("test1.xml");
            Assert.assertEquals((long)610L, (long)ze.getSize());
        }
    }

    @Test
    public void testDuplicateEntry() throws Exception {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("COMPRESS-227.zip");){
            int numberOfEntries = 0;
            for (ZipArchiveEntry entry : zf.getEntries("test1.txt")) {
                ++numberOfEntries;
                Assert.assertNotNull((Object)zf.getInputStream(entry));
            }
            Assert.assertEquals((long)2L, (long)numberOfEntries);
        }
    }

    @Test
    public void getRawInputStreamReturnsNull() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("bla.zip");){
            ZipArchiveEntry ze = zf.getEntry("test1.xml");
            Assert.assertNull((Object)zf.getRawInputStream(ze));
        }
    }

    @Test
    public void testPhysicalOrder() throws IOException {
        try (ZipFile zf = ZipFileIgnoringLocalFileHeaderTest.openZipWithoutLFH("ordertest.zip");){
            Enumeration e = zf.getEntriesInPhysicalOrder();
            ZipArchiveEntry ze = null;
            do {
                ze = (ZipArchiveEntry)e.nextElement();
            } while (e.hasMoreElements());
            Assert.assertEquals((Object)"src/main/java/org/apache/commons/compress/archivers/zip/ZipUtil.java", (Object)ze.getName());
        }
    }

    private static ZipFile openZipWithoutLFH(String fileName) throws IOException {
        return new ZipFile(AbstractTestCase.getFile(fileName), "UTF8", true, true);
    }
}

