/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class XZTestCase
extends AbstractTestCase {
    @Test
    public void testXZCreation() throws Exception {
        long max = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        System.out.println("XZTestCase: HeapMax=" + max + " bytes " + (double)max / 1048576.0 + " MB");
        File input = XZTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.xz");
        try (FileOutputStream out = new FileOutputStream(output);
             CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("xz", (OutputStream)out);){
            IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)cos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXZUnarchive() throws Exception {
        File input = XZTestCase.getFile("bla.tar.xz");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("xz", (InputStream)is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
    }

    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws Exception {
        File input = XZTestCase.getFile("multiple.xz");
        try (FileInputStream is = new FileInputStream(input);
             CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("xz", (InputStream)is);){
            Assert.assertEquals((long)97L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    @Test
    public void testConcatenatedStreamsReadFully() throws Exception {
        File input = XZTestCase.getFile("multiple.xz");
        try (FileInputStream is = new FileInputStream(input);
             XZCompressorInputStream in = new XZCompressorInputStream((InputStream)is, true);){
            Assert.assertEquals((long)97L, (long)in.read());
            Assert.assertEquals((long)98L, (long)in.read());
            Assert.assertEquals((long)0L, (long)in.available());
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }
}

