/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class ZTestCase
extends AbstractTestCase {
    @Test
    public void testZUnarchive() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws IOException {
                return new ZCompressorInputStream(is);
            }
        });
    }

    @Test
    public void testZUnarchiveViaFactory() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream("z", is);
            }
        });
    }

    @Test
    public void testZUnarchiveViaAutoDetection() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(is));
            }
        });
    }

    @Test
    public void testMatches() throws Exception {
        Assert.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{1, 2, 3, 4}, (int)4));
        Assert.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, 2, 3, 4}, (int)4));
        Assert.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{1, -99, 3, 4}, (int)4));
        Assert.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, -99, 3, 4}, (int)3));
        Assert.assertTrue((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, -99, 3, 4}, (int)4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnarchive(AbstractTestCase.StreamWrapper<CompressorInputStream> wrapper) throws Exception {
        File input = ZTestCase.getFile("bla.tar.Z");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            CompressorInputStream in = wrapper.wrap(is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
    }
}

