/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate64;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream;
import org.apache.commons.compress.compressors.deflate64.HuffmanDecoder;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class Deflate64CompressorInputStreamTest {
    private final HuffmanDecoder nullDecoder = null;
    @Mock
    private HuffmanDecoder decoder;

    @Test
    public void readWhenClosed() throws Exception {
        Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.nullDecoder);
        Assert.assertEquals((long)-1L, (long)input.read());
        Assert.assertEquals((long)-1L, (long)input.read(new byte[1]));
        Assert.assertEquals((long)-1L, (long)input.read(new byte[1], 0, 1));
    }

    @Test
    public void properSizeWhenClosed() throws Exception {
        Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.nullDecoder);
        Assert.assertEquals((long)0L, (long)input.available());
    }

    @Test
    public void delegatesAvailable() throws Exception {
        Mockito.when((Object)this.decoder.available()).thenReturn((Object)1024);
        Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.decoder);
        Assert.assertEquals((long)1024L, (long)input.available());
    }

    @Test
    public void closeCallsDecoder() throws Exception {
        Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.decoder);
        input.close();
        ((HuffmanDecoder)Mockito.verify((Object)this.decoder, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void closeIsDelegatedJustOnce() throws Exception {
        Deflate64CompressorInputStream input = new Deflate64CompressorInputStream(this.decoder);
        input.close();
        input.close();
        ((HuffmanDecoder)Mockito.verify((Object)this.decoder, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void uncompressedBlock() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream((InputStream)new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input));){
            Assert.assertEquals((Object)"Hello World", (Object)br.readLine());
            Assert.assertEquals(null, (Object)br.readLine());
        }
    }

    @Test
    public void uncompressedBlockViaFactory() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        try (CompressorInputStream input = new CompressorStreamFactory().createCompressorInputStream("deflate64", (InputStream)new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input));){
            Assert.assertEquals((Object)"Hello World", (Object)br.readLine());
            Assert.assertEquals(null, (Object)br.readLine());
        }
    }

    @Test
    public void uncompressedBlockAvailable() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream((InputStream)new ByteArrayInputStream(data));){
            Assert.assertEquals((long)72L, (long)input.read());
            Assert.assertEquals((long)10L, (long)input.available());
        }
    }

    @Test
    public void streamIgnoresExtraBytesAfterDeflatedInput() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100, 88};
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream((InputStream)new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input));){
            Assert.assertEquals((Object)"Hello World", (Object)br.readLine());
            Assert.assertEquals(null, (Object)br.readLine());
        }
    }

    @Test(expected=EOFException.class)
    public void throwsEOFExceptionOnTruncatedStreams() throws Exception {
        byte[] data = new byte[]{1, 11, 0, -12, -1, 72, 101, 108, 108, 111, 32, 87, 111, 114, 108};
        try (Deflate64CompressorInputStream input = new Deflate64CompressorInputStream((InputStream)new ByteArrayInputStream(data));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)input));){
            Assert.assertEquals((Object)"Hello World", (Object)br.readLine());
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (Deflate64CompressorInputStream in = new Deflate64CompressorInputStream(this.nullDecoder);){
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (Deflate64CompressorInputStream in = new Deflate64CompressorInputStream(this.nullDecoder);){
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }
}

