/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.compress.utils.ByteUtils;
import org.junit.Assert;
import org.junit.Test;

public class ByteUtilsTest {
    @Test
    public void fromLittleEndianFromArrayOneArg() {
        byte[] b = new byte[]{2, 3, 4};
        Assert.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((byte[])b));
    }

    @Test
    public void fromLittleEndianFromArrayOneArgUnsignedInt32() {
        byte[] b = new byte[]{2, 3, 4, -128};
        Assert.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((byte[])b));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromLittleEndianFromArrayOneArgThrowsForLengthTooBig() {
        ByteUtils.fromLittleEndian((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Test
    public void fromLittleEndianFromArray() {
        byte[] b = new byte[]{1, 2, 3, 4, 5};
        Assert.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((byte[])b, (int)1, (int)3));
    }

    @Test
    public void fromLittleEndianFromArrayUnsignedInt32() {
        byte[] b = new byte[]{1, 2, 3, 4, -128};
        Assert.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((byte[])b, (int)1, (int)4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromLittleEndianFromArrayThrowsForLengthTooBig() {
        ByteUtils.fromLittleEndian((byte[])new byte[0], (int)0, (int)9);
    }

    @Test
    public void fromLittleEndianFromStream() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, 5});
        Assert.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((InputStream)bin, (int)3));
    }

    @Test
    public void fromLittleEndianFromStreamUnsignedInt32() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, -128});
        Assert.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((InputStream)bin, (int)4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromLittleEndianFromStreamThrowsForLengthTooBig() throws IOException {
        ByteUtils.fromLittleEndian((InputStream)new ByteArrayInputStream(new byte[0]), (int)9);
    }

    @Test(expected=IOException.class)
    public void fromLittleEndianFromStreamThrowsForPrematureEnd() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3});
        ByteUtils.fromLittleEndian((InputStream)bin, (int)3);
    }

    @Test
    public void fromLittleEndianFromSupplier() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, 5});
        Assert.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)3));
    }

    @Test
    public void fromLittleEndianFromSupplierUnsignedInt32() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3, 4, -128});
        Assert.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromLittleEndianFromSupplierThrowsForLengthTooBig() throws IOException {
        ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)new ByteArrayInputStream(new byte[0])), (int)9);
    }

    @Test(expected=IOException.class)
    public void fromLittleEndianFromSupplierThrowsForPrematureEnd() throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(new byte[]{2, 3});
        ByteUtils.fromLittleEndian((ByteUtils.ByteSupplier)new ByteUtils.InputStreamByteSupplier((InputStream)bin), (int)3);
    }

    @Test
    public void fromLittleEndianFromDataInput() throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3, 4, 5}));
        Assert.assertEquals((long)262914L, (long)ByteUtils.fromLittleEndian((DataInput)din, (int)3));
    }

    @Test
    public void fromLittleEndianFromDataInputUnsignedInt32() throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3, 4, -128}));
        Assert.assertEquals((long)2147746562L, (long)ByteUtils.fromLittleEndian((DataInput)din, (int)4));
    }

    @Test(expected=IllegalArgumentException.class)
    public void fromLittleEndianFromDataInputThrowsForLengthTooBig() throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[0]));
        ByteUtils.fromLittleEndian((DataInput)din, (int)9);
    }

    @Test(expected=EOFException.class)
    public void fromLittleEndianFromDataInputThrowsForPrematureEnd() throws IOException {
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(new byte[]{2, 3}));
        ByteUtils.fromLittleEndian((DataInput)din, (int)3);
    }

    @Test
    public void toLittleEndianToStream() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteUtils.toLittleEndian((OutputStream)bos, (long)262914L, (int)3);
        bos.close();
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToStreamUnsignedInt32() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteUtils.toLittleEndian((OutputStream)bos, (long)2147746562L, (int)4);
        bos.close();
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToConsumer() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteUtils.toLittleEndian((ByteUtils.ByteConsumer)new ByteUtils.OutputStreamByteConsumer((OutputStream)bos), (long)262914L, (int)3);
        bos.close();
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToConsumerUnsignedInt32() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteUtils.toLittleEndian((ByteUtils.ByteConsumer)new ByteUtils.OutputStreamByteConsumer((OutputStream)bos), (long)2147746562L, (int)4);
        bos.close();
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToDataOutput() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        ByteUtils.toLittleEndian((DataOutput)dos, (long)262914L, (int)3);
        bos.close();
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToDataOutputUnsignedInt32() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        ByteUtils.toLittleEndian((DataOutput)dos, (long)2147746562L, (int)4);
        bos.close();
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])bos.toByteArray());
    }

    @Test
    public void toLittleEndianToByteArray() throws IOException {
        byte[] b = new byte[4];
        ByteUtils.toLittleEndian((byte[])b, (long)262914L, (int)1, (int)3);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])Arrays.copyOfRange(b, 1, 4));
    }

    @Test
    public void toLittleEndianToByteArrayUnsignedInt32() throws IOException {
        byte[] b = new byte[4];
        ByteUtils.toLittleEndian((byte[])b, (long)2147746562L, (int)0, (int)4);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4, -128}, (byte[])b);
    }
}

