/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.junit.Assert;
import org.junit.Test;

public class IOMethodsTest
extends AbstractTestCase {
    private static final int bytesToTest = 50;
    private static final byte[] byteTest = new byte[50];

    @Test
    public void testWriteAr() throws Exception {
        ArArchiveEntry entry = new ArArchiveEntry("dummy", 50L);
        this.compareWrites("ar", (ArchiveEntry)entry);
    }

    @Test
    public void testWriteCpio() throws Exception {
        CpioArchiveEntry entry = new CpioArchiveEntry("dummy", 50L);
        this.compareWrites("cpio", (ArchiveEntry)entry);
    }

    @Test
    public void testWriteJar() throws Exception {
        JarArchiveEntry entry = new JarArchiveEntry("dummy");
        this.compareWrites("jar", (ArchiveEntry)entry);
    }

    @Test
    public void testWriteTar() throws Exception {
        TarArchiveEntry entry = new TarArchiveEntry("dummy");
        entry.setSize(50L);
        this.compareWrites("tar", (ArchiveEntry)entry);
    }

    @Test
    public void testWriteZip() throws Exception {
        ZipArchiveEntry entry = new ZipArchiveEntry("dummy");
        this.compareWrites("zip", (ArchiveEntry)entry);
    }

    @Test
    public void testReadAr() throws Exception {
        this.compareReads("ar");
    }

    @Test
    public void testReadCpio() throws Exception {
        this.compareReads("cpio");
    }

    @Test
    public void testReadJar() throws Exception {
        this.compareReads("jar");
    }

    @Test
    public void testReadTar() throws Exception {
        this.compareReads("tar");
    }

    @Test
    public void testReadZip() throws Exception {
        this.compareReads("zip");
    }

    private void compareWrites(String archiverName, ArchiveEntry entry) throws Exception {
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        ByteArrayOutputStream out3 = new ByteArrayOutputStream();
        ArchiveOutputStream aos1 = this.factory.createArchiveOutputStream(archiverName, (OutputStream)out1);
        aos1.putArchiveEntry(entry);
        ArchiveOutputStream aos2 = this.factory.createArchiveOutputStream(archiverName, (OutputStream)out2);
        aos2.putArchiveEntry(entry);
        ArchiveOutputStream aos3 = this.factory.createArchiveOutputStream(archiverName, (OutputStream)out3);
        aos3.putArchiveEntry(entry);
        for (byte element : byteTest) {
            aos1.write((int)element);
        }
        aos1.closeArchiveEntry();
        aos1.close();
        aos2.write(byteTest);
        aos2.closeArchiveEntry();
        aos2.close();
        aos3.write(byteTest, 0, byteTest.length);
        aos3.closeArchiveEntry();
        aos3.close();
        Assert.assertEquals((String)"aos1Bytes!=aos2Bytes", (long)aos1.getBytesWritten(), (long)aos2.getBytesWritten());
        Assert.assertEquals((String)"aos1Bytes!=aos3Bytes", (long)aos1.getBytesWritten(), (long)aos3.getBytesWritten());
        Assert.assertEquals((String)"out1Len!=out2Len", (long)((Object)out1).toString().length(), (long)((Object)out2).toString().length());
        Assert.assertEquals((String)"out1Len!=out2Len", (long)((Object)out1).toString().length(), (long)((Object)out3).toString().length());
        Assert.assertEquals((String)"out1!=out2", (Object)((Object)out1).toString(), (Object)((Object)out2).toString());
        Assert.assertEquals((String)"out1!=out3", (Object)((Object)out1).toString(), (Object)((Object)out3).toString());
    }

    private void compareReads(String archiverName) throws Exception {
        int bytes;
        int b;
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        ByteArrayOutputStream out3 = new ByteArrayOutputStream();
        File file = this.createSingleEntryArchive(archiverName);
        file.deleteOnExit();
        FileInputStream is1 = new FileInputStream(file);
        ArchiveInputStream ais1 = this.factory.createArchiveInputStream(archiverName, (InputStream)is1);
        ArchiveEntry nextEntry = ais1.getNextEntry();
        Assert.assertNotNull((Object)nextEntry);
        byte[] buff = new byte[10];
        long size = nextEntry.getSize();
        if (size != -1L) {
            Assert.assertTrue((String)("Size should be > 0, found: " + size), (size > 0L ? 1 : 0) != 0);
        }
        FileInputStream is2 = new FileInputStream(file);
        ArchiveInputStream ais2 = this.factory.createArchiveInputStream(archiverName, (InputStream)is2);
        ArchiveEntry nextEntry2 = ais2.getNextEntry();
        Assert.assertNotNull((Object)nextEntry2);
        Assert.assertEquals((String)"Expected same entry size", (long)size, (long)nextEntry2.getSize());
        FileInputStream is3 = new FileInputStream(file);
        ArchiveInputStream ais3 = this.factory.createArchiveInputStream(archiverName, (InputStream)is3);
        ArchiveEntry nextEntry3 = ais3.getNextEntry();
        Assert.assertNotNull((Object)nextEntry3);
        Assert.assertEquals((String)"Expected same entry size", (long)size, (long)nextEntry3.getSize());
        while ((b = ais1.read()) != -1) {
            ((OutputStream)out1).write(b);
        }
        ais1.close();
        while ((bytes = ais2.read(buff)) > 0) {
            ((OutputStream)out2).write(buff, 0, bytes);
        }
        ais2.close();
        while ((bytes = ais3.read(buff, 0, buff.length)) > 0) {
            ((OutputStream)out3).write(buff, 0, bytes);
        }
        ais3.close();
        Assert.assertEquals((String)"out1Len!=out2Len", (long)((Object)out1).toString().length(), (long)((Object)out2).toString().length());
        Assert.assertEquals((String)"out1Len!=out3Len", (long)((Object)out1).toString().length(), (long)((Object)out3).toString().length());
        Assert.assertEquals((String)"out1!=out2", (Object)((Object)out1).toString(), (Object)((Object)out2).toString());
        Assert.assertEquals((String)"out1!=out3", (Object)((Object)out1).toString(), (Object)((Object)out3).toString());
    }

    static {
        for (int i = 0; i < byteTest.length; i += 2) {
            IOMethodsTest.byteTest[i] = (byte)i;
            IOMethodsTest.byteTest[i + 1] = (byte)(-i);
        }
    }
}

