/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class DumpTestCase
extends AbstractTestCase {
    @Test
    public void testDumpUnarchiveAll() throws Exception {
        this.unarchiveAll(DumpTestCase.getFile("bla.dump"));
    }

    @Test
    public void testCompressedDumpUnarchiveAll() throws Exception {
        this.unarchiveAll(DumpTestCase.getFile("bla.z.dump"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unarchiveAll(File input) throws Exception {
        FileInputStream is = new FileInputStream(input);
        ArchiveInputStream in = null;
        OutputStream out = null;
        try {
            in = new ArchiveStreamFactory().createArchiveInputStream("dump", (InputStream)is);
            ArchiveEntry entry = in.getNextEntry();
            while (entry != null) {
                File archiveEntry = new File(this.dir, entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = in.getNextEntry();
                    continue;
                }
                out = new FileOutputStream(archiveEntry);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.close();
                out = null;
                entry = in.getNextEntry();
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            ((InputStream)is).close();
        }
    }

    @Test
    public void testArchiveDetection() throws Exception {
        this.archiveDetection(DumpTestCase.getFile("bla.dump"));
    }

    @Test
    public void testCompressedArchiveDetection() throws Exception {
        this.archiveDetection(DumpTestCase.getFile("bla.z.dump"));
    }

    private void archiveDetection(File f) throws Exception {
        try (FileInputStream is = new FileInputStream(f);){
            Assert.assertEquals(DumpArchiveInputStream.class, new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is)).getClass());
        }
    }

    @Test
    public void testCheckArchive() throws Exception {
        this.checkDumpArchive(DumpTestCase.getFile("bla.dump"));
    }

    @Test
    public void testCheckCompressedArchive() throws Exception {
        this.checkDumpArchive(DumpTestCase.getFile("bla.z.dump"));
    }

    private void checkDumpArchive(File f) throws Exception {
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("");
        expected.add("lost+found/");
        expected.add("test1.xml");
        expected.add("test2.xml");
        try (FileInputStream is = new FileInputStream(f);){
            this.checkArchiveContent((ArchiveInputStream)new DumpArchiveInputStream((InputStream)is), expected);
        }
    }
}

