/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class CpioArchiveOutputStreamTest
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteOldBinary() throws Exception {
        File f = CpioArchiveOutputStreamTest.getFile("test1.xml");
        File output = new File(this.dir, "test.cpio");
        FileOutputStream out = new FileOutputStream(output);
        InputStream in = null;
        try {
            CpioArchiveOutputStream os = new CpioArchiveOutputStream((OutputStream)out, 8);
            os.putArchiveEntry((ArchiveEntry)new CpioArchiveEntry(8, f, "test1.xml"));
            in = new FileInputStream(f);
            IOUtils.copy((InputStream)in, (OutputStream)os);
            in.close();
            in = null;
            os.closeArchiveEntry();
            os.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
            out.close();
        }
        try {
            in = new CpioArchiveInputStream((InputStream)new FileInputStream(output));
            CpioArchiveEntry e = ((CpioArchiveInputStream)in).getNextCPIOEntry();
            Assert.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assert.assertNull((Object)((CpioArchiveInputStream)in).getNextEntry());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

