/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.CircularBuffer;
import org.junit.Assert;
import org.junit.Test;

public class CircularBufferTest {
    @Test
    public void testPutAndGet() throws Exception {
        int i;
        int size = 16;
        CircularBuffer buffer = new CircularBuffer(16);
        for (i = 0; i < 8; ++i) {
            buffer.put(i);
        }
        Assert.assertTrue((String)"available", (boolean)buffer.available());
        for (i = 0; i < 8; ++i) {
            Assert.assertEquals((String)("buffer[" + i + "]"), (long)i, (long)buffer.get());
        }
        Assert.assertEquals((long)-1L, (long)buffer.get());
        Assert.assertFalse((String)"available", (boolean)buffer.available());
    }

    @Test
    public void testCopy() throws Exception {
        int i;
        CircularBuffer buffer = new CircularBuffer(16);
        buffer.put(1);
        buffer.put(2);
        buffer.get();
        buffer.get();
        buffer.copy(6, 8);
        for (i = 2; i < 6; ++i) {
            Assert.assertEquals((String)("buffer[" + i + "]"), (long)0L, (long)buffer.get());
        }
        Assert.assertEquals((String)"buffer[6]", (long)1L, (long)buffer.get());
        Assert.assertEquals((String)"buffer[7]", (long)2L, (long)buffer.get());
        Assert.assertEquals((String)"buffer[8]", (long)0L, (long)buffer.get());
        Assert.assertEquals((String)"buffer[9]", (long)0L, (long)buffer.get());
        for (i = 10; i < 14; ++i) {
            buffer.put(i);
            buffer.get();
        }
        Assert.assertFalse((String)"available", (boolean)buffer.available());
        buffer.copy(2, 8);
        for (i = 14; i < 18; ++i) {
            Assert.assertEquals((String)("buffer[" + i + "]"), (long)(i % 2 == 0 ? 12L : 13L), (long)buffer.get());
        }
    }
}

