/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.zip.ZipException;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.AsiExtraField;
import org.apache.commons.compress.archivers.zip.ExtraFieldParsingBehavior;
import org.apache.commons.compress.archivers.zip.ExtraFieldUtilsTest;
import org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZipArchiveEntryTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testExtraFields() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(new byte[0]);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] data1 = ze.getExtra();
        ZipExtraField[] result = ze.getExtraFields();
        Assert.assertEquals((String)"first pass", (long)2L, (long)result.length);
        Assert.assertSame((Object)a, (Object)result[0]);
        Assert.assertSame((Object)u, (Object)result[1]);
        UnrecognizedExtraField u2 = new UnrecognizedExtraField();
        u2.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u2.setLocalFileDataData(new byte[]{1});
        ze.addExtraField((ZipExtraField)u2);
        byte[] data2 = ze.getExtra();
        result = ze.getExtraFields();
        Assert.assertEquals((String)"second pass", (long)2L, (long)result.length);
        Assert.assertSame((Object)a, (Object)result[0]);
        Assert.assertSame((Object)u2, (Object)result[1]);
        Assert.assertEquals((String)"length second pass", (long)(data1.length + 1), (long)data2.length);
        UnrecognizedExtraField u3 = new UnrecognizedExtraField();
        u3.setHeaderId(new ZipShort(2));
        u3.setLocalFileDataData(new byte[]{1});
        ze.addExtraField((ZipExtraField)u3);
        result = ze.getExtraFields();
        Assert.assertEquals((String)"third pass", (long)3L, (long)result.length);
        ze.removeExtraField(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        byte[] data3 = ze.getExtra();
        result = ze.getExtraFields();
        Assert.assertEquals((String)"fourth pass", (long)2L, (long)result.length);
        Assert.assertSame((Object)a, (Object)result[0]);
        Assert.assertSame((Object)u3, (Object)result[1]);
        Assert.assertEquals((String)"length fourth pass", (long)data2.length, (long)data3.length);
        try {
            ze.removeExtraField(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
            Assert.fail((String)"should be no such element");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testExtraFieldMerging() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(new byte[0]);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] b = ExtraFieldUtilsTest.UNRECOGNIZED_HEADER.getBytes();
        ze.setCentralDirectoryExtra(new byte[]{b[0], b[1], 1, 0, 127});
        ZipExtraField[] result = ze.getExtraFields();
        Assert.assertEquals((String)"first pass", (long)2L, (long)result.length);
        Assert.assertSame((Object)a, (Object)result[0]);
        Assert.assertEquals((Object)ExtraFieldUtilsTest.UNRECOGNIZED_HEADER, (Object)result[1].getHeaderId());
        Assert.assertEquals((Object)new ZipShort(0), (Object)result[1].getLocalFileDataLength());
        Assert.assertEquals((Object)new ZipShort(1), (Object)result[1].getCentralDirectoryLength());
        ze.setCentralDirectoryExtra(new byte[]{2, 0, 0, 0});
        result = ze.getExtraFields();
        Assert.assertEquals((String)"second pass", (long)3L, (long)result.length);
        ze.setExtra(new byte[]{2, 0, 1, 0, 127});
        result = ze.getExtraFields();
        Assert.assertEquals((String)"third pass", (long)3L, (long)result.length);
        Assert.assertSame((Object)a, (Object)result[0]);
        Assert.assertEquals((Object)new ZipShort(2), (Object)result[2].getHeaderId());
        Assert.assertEquals((Object)new ZipShort(1), (Object)result[2].getLocalFileDataLength());
        Assert.assertEquals((Object)new ZipShort(0), (Object)result[2].getCentralDirectoryLength());
    }

    @Test
    public void testAddAsFirstExtraField() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(new byte[0]);
        ZipArchiveEntry ze = new ZipArchiveEntry("test/");
        ze.setExtraFields(new ZipExtraField[]{a, u});
        byte[] data1 = ze.getExtra();
        UnrecognizedExtraField u2 = new UnrecognizedExtraField();
        u2.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u2.setLocalFileDataData(new byte[]{1});
        ze.addAsFirstExtraField((ZipExtraField)u2);
        byte[] data2 = ze.getExtra();
        ZipExtraField[] result = ze.getExtraFields();
        Assert.assertEquals((String)"second pass", (long)2L, (long)result.length);
        Assert.assertSame((Object)u2, (Object)result[0]);
        Assert.assertSame((Object)a, (Object)result[1]);
        Assert.assertEquals((String)"length second pass", (long)(data1.length + 1), (long)data2.length);
        UnrecognizedExtraField u3 = new UnrecognizedExtraField();
        u3.setHeaderId(new ZipShort(2));
        u3.setLocalFileDataData(new byte[]{1});
        ze.addAsFirstExtraField((ZipExtraField)u3);
        result = ze.getExtraFields();
        Assert.assertEquals((String)"third pass", (long)3L, (long)result.length);
        Assert.assertSame((Object)u3, (Object)result[0]);
        Assert.assertSame((Object)u2, (Object)result[1]);
        Assert.assertSame((Object)a, (Object)result[2]);
    }

    @Test
    public void testUnixMode() {
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        Assert.assertEquals((long)0L, (long)ze.getPlatform());
        ze.setUnixMode(493);
        Assert.assertEquals((long)3L, (long)ze.getPlatform());
        Assert.assertEquals((long)493L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        Assert.assertEquals((long)0L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze.setUnixMode(292);
        Assert.assertEquals((long)3L, (long)ze.getPlatform());
        Assert.assertEquals((long)292L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        Assert.assertEquals((long)1L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze = new ZipArchiveEntry("foo/");
        Assert.assertEquals((long)0L, (long)ze.getPlatform());
        ze.setUnixMode(511);
        Assert.assertEquals((long)3L, (long)ze.getPlatform());
        Assert.assertEquals((long)511L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        Assert.assertEquals((long)16L, (long)(ze.getExternalAttributes() & 0xFFFFL));
        ze.setUnixMode(383);
        Assert.assertEquals((long)3L, (long)ze.getPlatform());
        Assert.assertEquals((long)383L, (long)(ze.getExternalAttributes() >> 16 & 0xFFFFL));
        Assert.assertEquals((long)17L, (long)(ze.getExternalAttributes() & 0xFFFFL));
    }

    @Test
    public void testCompressionMethod() throws Exception {
        ZipArchiveOutputStream zos = new ZipArchiveOutputStream((OutputStream)new ByteArrayOutputStream());
        ZipArchiveEntry entry = new ZipArchiveEntry("foo");
        Assert.assertEquals((long)-1L, (long)entry.getMethod());
        Assert.assertFalse((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        entry.setMethod(0);
        Assert.assertEquals((long)0L, (long)entry.getMethod());
        Assert.assertTrue((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        entry.setMethod(8);
        Assert.assertEquals((long)8L, (long)entry.getMethod());
        Assert.assertTrue((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        entry.setMethod(6);
        Assert.assertEquals((long)6L, (long)entry.getMethod());
        Assert.assertFalse((boolean)zos.canWriteEntryData((ArchiveEntry)entry));
        zos.close();
    }

    @Test
    public void testNotEquals() {
        ZipArchiveEntry entry1 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry2 = new ZipArchiveEntry("bar");
        Assert.assertFalse((boolean)entry1.equals((Object)entry2));
    }

    @Test
    public void testNullCommentEqualsEmptyComment() {
        ZipArchiveEntry entry1 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry2 = new ZipArchiveEntry("foo");
        ZipArchiveEntry entry3 = new ZipArchiveEntry("foo");
        entry1.setComment(null);
        entry2.setComment("");
        entry3.setComment("bar");
        Assert.assertEquals((Object)entry1, (Object)entry2);
        Assert.assertFalse((boolean)entry1.equals((Object)entry3));
        Assert.assertFalse((boolean)entry2.equals((Object)entry3));
    }

    @Test
    public void testCopyConstructor() throws Exception {
        ZipArchiveEntry archiveEntry = new ZipArchiveEntry("fred");
        archiveEntry.setUnixMode(436);
        archiveEntry.setMethod(8);
        archiveEntry.getGeneralPurposeBit().useStrongEncryption(true);
        ZipArchiveEntry copy = new ZipArchiveEntry(archiveEntry);
        Assert.assertEquals((Object)archiveEntry, (Object)copy);
    }

    @Test
    public void isUnixSymlinkIsFalseIfMoreThanOneFlagIsSet() throws Exception {
        try (ZipFile zf = new ZipFile(AbstractTestCase.getFile("COMPRESS-379.jar"));){
            ZipArchiveEntry ze = zf.getEntry("META-INF/maven/");
            Assert.assertFalse((boolean)ze.isUnixSymlink());
        }
    }

    @Test
    public void testIsUnixSymlink() {
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setUnixMode(40960);
        Assert.assertTrue((boolean)ze.isUnixSymlink());
        ze.setUnixMode(57344);
        Assert.assertFalse((boolean)ze.isUnixSymlink());
    }

    @Test
    public void reparsingUnicodeExtraWithUnsupportedversionThrowsInStrictMode() throws Exception {
        try (ZipFile zf = new ZipFile(AbstractTestCase.getFile("COMPRESS-479.zip"));){
            ZipArchiveEntry ze = zf.getEntry("%U20AC_for_Dollar.txt");
            this.thrown.expect(ZipException.class);
            this.thrown.expectMessage("Unsupported version [116] for UniCode path extra data.");
            ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.STRICT_FOR_KNOW_EXTRA_FIELDS);
        }
    }

    @Test
    public void bestEffortIncludesUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        ZipExtraField[] read = ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.BEST_EFFORT);
        Assert.assertEquals((long)extraFields.length, (long)read.length);
    }

    @Test
    public void onlyParseableLenientExcludesUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        ZipExtraField[] read = ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.ONLY_PARSEABLE_LENIENT);
        Assert.assertEquals((long)extraFields.length, (long)(read.length + 1));
    }

    @Test
    public void strictForKnowExtraFieldsIncludesUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        ZipExtraField[] read = ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.STRICT_FOR_KNOW_EXTRA_FIELDS);
        Assert.assertEquals((long)extraFields.length, (long)read.length);
    }

    @Test
    public void onlyParseableStrictExcludesUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        ZipExtraField[] read = ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.ONLY_PARSEABLE_STRICT);
        Assert.assertEquals((long)extraFields.length, (long)(read.length + 1));
    }

    @Test
    public void draconicThrowsOnUnparseableExtraData() throws Exception {
        ZipExtraField[] extraFields = this.parsingModeBehaviorTestData();
        ZipArchiveEntry ze = new ZipArchiveEntry("foo");
        ze.setExtraFields(extraFields);
        this.thrown.expect(ZipException.class);
        this.thrown.expectMessage("Bad extra field starting at");
        ze.getExtraFields((ExtraFieldParsingBehavior)ZipArchiveEntry.ExtraFieldParsingMode.DRACONIC);
    }

    private ZipExtraField[] parsingModeBehaviorTestData() {
        AsiExtraField a = new AsiExtraField();
        a.setDirectory(true);
        a.setMode(493);
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(ExtraFieldUtilsTest.UNRECOGNIZED_HEADER);
        u.setLocalFileDataData(new byte[0]);
        UnparseableExtraFieldData x = new UnparseableExtraFieldData();
        byte[] unparseable = new byte[]{0, 0, -1, -1, 0, 0, 0};
        x.parseFromLocalFileData(unparseable, 0, unparseable.length);
        return new ZipExtraField[]{a, u, x};
    }
}

