/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.ZipLong;
import org.junit.Assert;
import org.junit.Test;

public class ZipLongTest {
    @Test
    public void testToBytes() {
        ZipLong zl = new ZipLong(305419896);
        byte[] result = zl.getBytes();
        Assert.assertEquals((String)"length getBytes", (long)4L, (long)result.length);
        Assert.assertEquals((String)"first byte getBytes", (long)120L, (long)result[0]);
        Assert.assertEquals((String)"second byte getBytes", (long)86L, (long)result[1]);
        Assert.assertEquals((String)"third byte getBytes", (long)52L, (long)result[2]);
        Assert.assertEquals((String)"fourth byte getBytes", (long)18L, (long)result[3]);
    }

    @Test
    public void testPut() {
        byte[] arr = new byte[5];
        ZipLong.putLong((long)305419896L, (byte[])arr, (int)1);
        Assert.assertEquals((String)"first byte getBytes", (long)120L, (long)arr[1]);
        Assert.assertEquals((String)"second byte getBytes", (long)86L, (long)arr[2]);
        Assert.assertEquals((String)"third byte getBytes", (long)52L, (long)arr[3]);
        Assert.assertEquals((String)"fourth byte getBytes", (long)18L, (long)arr[4]);
    }

    @Test
    public void testFromBytes() {
        byte[] val = new byte[]{120, 86, 52, 18};
        ZipLong zl = new ZipLong(val);
        Assert.assertEquals((String)"value from bytes", (long)305419896L, (long)zl.getValue());
    }

    @Test
    public void testEquals() {
        ZipLong zl = new ZipLong(305419896);
        ZipLong zl2 = new ZipLong(305419896);
        ZipLong zl3 = new ZipLong(-2023406815);
        Assert.assertTrue((String)"reflexive", (boolean)zl.equals((Object)zl));
        Assert.assertTrue((String)"works", (boolean)zl.equals((Object)zl2));
        Assert.assertTrue((String)"works, part two", (!zl.equals((Object)zl3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"symmetric", (boolean)zl2.equals((Object)zl));
        Assert.assertTrue((String)"null handling", (!zl.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"non ZipLong handling", (!zl.equals((Object)new Integer(4660)) ? 1 : 0) != 0);
    }

    @Test
    public void testSign() {
        ZipLong zl = new ZipLong(new byte[]{-1, -1, -1, -1});
        Assert.assertEquals((long)0xFFFFFFFFL, (long)zl.getValue());
        Assert.assertEquals((long)-1L, (long)zl.getIntValue());
        zl = new ZipLong(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)zl.getValue());
        zl = new ZipLong(-1);
        Assert.assertEquals((long)-1L, (long)zl.getValue());
    }

    @Test
    public void testClone() {
        ZipLong s1 = new ZipLong(42);
        ZipLong s2 = (ZipLong)s1.clone();
        Assert.assertNotSame((Object)s1, (Object)s2);
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals((long)s1.getValue(), (long)s2.getValue());
    }
}

