/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class DeflateCompressorInputStreamTest {
    @Test
    public void availableShouldReturnNonZero() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        try (FileInputStream is = new FileInputStream(input);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream((InputStream)is);
            Assert.assertTrue((in.available() > 0 ? 1 : 0) != 0);
            in.close();
        }
    }

    @Test
    public void shouldBeAbleToSkipAByte() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        try (FileInputStream is = new FileInputStream(input);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream((InputStream)is);
            Assert.assertEquals((long)1L, (long)in.skip(1L));
            in.close();
        }
    }

    @Test
    public void singleByteReadWorksAsExpected() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        try (FileInputStream is = new FileInputStream(input);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream((InputStream)is);
            Assert.assertEquals((long)116L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        try (FileInputStream is = new FileInputStream(input);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = AbstractTestCase.getFile("bla.tar.deflatez");
        byte[] buf = new byte[2];
        try (FileInputStream is = new FileInputStream(input);){
            DeflateCompressorInputStream in = new DeflateCompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }
}

