/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.lz77support.Parameters;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class BlockLZ4CompressorRoundtripTest
extends AbstractTestCase {
    private final String config;
    private final Parameters params;

    @Parameterized.Parameters(name="using {0}")
    public static Collection<Object[]> factory() {
        return Arrays.asList({"default", BlockLZ4CompressorOutputStream.createParameterBuilder().build()}, {"tuned for speed", BlockLZ4CompressorOutputStream.createParameterBuilder().tunedForSpeed().build()}, {"tuned for compression ratio", BlockLZ4CompressorOutputStream.createParameterBuilder().tunedForCompressionRatio().build()});
    }

    public BlockLZ4CompressorRoundtripTest(String config, Parameters params) {
        this.config = config;
        this.params = params;
    }

    private void roundTripTest(String testFile) throws IOException {
        Throwable throwable;
        File input = BlockLZ4CompressorRoundtripTest.getFile(testFile);
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + ".block.lz4");
        try (FileInputStream is = new FileInputStream(input);){
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(outputSz);
                 BlockLZ4CompressorOutputStream los2 = new BlockLZ4CompressorOutputStream((OutputStream)os, this.params);){
                IOUtils.copy((InputStream)is, (OutputStream)los2);
            }
            catch (Throwable los2) {
                throwable = los2;
                throw los2;
            }
        }
        System.err.println("Configuration: " + this.config);
        System.err.println(input.getName() + " written, uncompressed bytes: " + input.length() + ", compressed bytes: " + outputSz.length() + " after " + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        is = new FileInputStream(input);
        var7_6 = null;
        try {
            throwable = null;
            try (BlockLZ4CompressorInputStream sis = new BlockLZ4CompressorInputStream((InputStream)new FileInputStream(outputSz));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)sis);
                Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var7_6 = throwable3;
            throw throwable3;
        }
        finally {
            if (is != null) {
                if (var7_6 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        var7_6.addSuppressed(throwable4);
                    }
                } else {
                    is.close();
                }
            }
        }
        System.err.println(outputSz.getName() + " read after " + (System.currentTimeMillis() - start) + "ms");
    }

    @Test
    public void blaTarRoundtrip() throws IOException {
        this.roundTripTest("bla.tar");
    }

    @Test
    public void gzippedLoremIpsumRoundtrip() throws IOException {
        this.roundTripTest("lorem-ipsum.txt.gz");
    }

    @Test
    public void biggerFileRoundtrip() throws IOException {
        this.roundTripTest("COMPRESS-256.7z");
    }
}

