/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.pack200.Pack200Utils;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Test;

public final class Pack200UtilsTest
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalize() throws Throwable {
        File input = Pack200UtilsTest.getFile("bla.jar");
        File[] output = this.createTempDirAndFile();
        try {
            Pack200Utils.normalize((File)input, (File)output[1], new HashMap());
            try (FileInputStream is = new FileInputStream(output[1]);){
                ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("jar", (InputStream)is);
                ArchiveEntry entry = in.getNextEntry();
                while (entry != null) {
                    File archiveEntry = new File(this.dir, entry.getName());
                    archiveEntry.getParentFile().mkdirs();
                    if (entry.isDirectory()) {
                        archiveEntry.mkdir();
                        entry = in.getNextEntry();
                        continue;
                    }
                    FileOutputStream out = new FileOutputStream(archiveEntry);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).close();
                    entry = in.getNextEntry();
                }
                in.close();
            }
        }
        finally {
            output[1].delete();
            output[0].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNormalizeInPlace() throws Throwable {
        File input = Pack200UtilsTest.getFile("bla.jar");
        File[] output = this.createTempDirAndFile();
        try {
            FileInputStream is = new FileInputStream(input);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(output[1]);
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                is.close();
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            Pack200Utils.normalize((File)output[1]);
            is = new FileInputStream(output[1]);
            try {
                ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream("jar", (InputStream)is);
                ArchiveEntry entry = in.getNextEntry();
                while (entry != null) {
                    File archiveEntry = new File(this.dir, entry.getName());
                    archiveEntry.getParentFile().mkdirs();
                    if (entry.isDirectory()) {
                        archiveEntry.mkdir();
                        entry = in.getNextEntry();
                        continue;
                    }
                    FileOutputStream out = new FileOutputStream(archiveEntry);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).close();
                    entry = in.getNextEntry();
                }
                in.close();
            }
            finally {
                is.close();
            }
        }
        finally {
            output[1].delete();
            output[0].delete();
        }
    }
}

