/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.zstandard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class ZstdRoundtripTest
extends AbstractTestCase {
    @Test
    public void directRoundtrip() throws Exception {
        this.roundtrip(new OutputStreamCreator(){

            @Override
            public ZstdCompressorOutputStream wrap(FileOutputStream os) throws IOException {
                return new ZstdCompressorOutputStream((OutputStream)os);
            }
        });
    }

    private void roundtrip(OutputStreamCreator oc) throws IOException {
        Throwable throwable;
        File input = ZstdRoundtripTest.getFile("bla.tar");
        long start = System.currentTimeMillis();
        File output = new File(this.dir, input.getName() + ".zstd");
        try (FileInputStream is = new FileInputStream(input);){
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(output);
                 ZstdCompressorOutputStream zos2 = oc.wrap(os);){
                IOUtils.copy((InputStream)is, (OutputStream)zos2);
            }
            catch (Throwable zos2) {
                throwable = zos2;
                throw zos2;
            }
        }
        System.err.println(input.getName() + " written, uncompressed bytes: " + input.length() + ", compressed bytes: " + output.length() + " after " + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        is = new FileInputStream(input);
        var7_6 = null;
        try {
            throwable = null;
            try (ZstdCompressorInputStream zis = new ZstdCompressorInputStream((InputStream)new FileInputStream(output));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)zis);
                Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var7_6 = throwable3;
            throw throwable3;
        }
        finally {
            if (is != null) {
                if (var7_6 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        var7_6.addSuppressed(throwable4);
                    }
                } else {
                    is.close();
                }
            }
        }
        System.err.println(output.getName() + " read after " + (System.currentTimeMillis() - start) + "ms");
    }

    @Test
    public void factoryRoundtrip() throws Exception {
        Throwable throwable;
        File input = ZstdRoundtripTest.getFile("bla.tar");
        long start = System.currentTimeMillis();
        File output = new File(this.dir, input.getName() + ".zstd");
        try (FileInputStream is = new FileInputStream(input);){
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(output);
                 CompressorOutputStream zos2 = new CompressorStreamFactory().createCompressorOutputStream("zstd", (OutputStream)os);){
                IOUtils.copy((InputStream)is, (OutputStream)zos2);
            }
            catch (Throwable zos2) {
                throwable = zos2;
                throw zos2;
            }
        }
        start = System.currentTimeMillis();
        is = new FileInputStream(input);
        var6_5 = null;
        try {
            throwable = null;
            try (CompressorInputStream zis = new CompressorStreamFactory().createCompressorInputStream("zstd", (InputStream)new FileInputStream(output));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)zis);
                Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var6_5 = throwable3;
            throw throwable3;
        }
        finally {
            if (is != null) {
                if (var6_5 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        var6_5.addSuppressed(throwable4);
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    @Test
    public void roundtripWithCustomLevel() throws Exception {
        this.roundtrip(new OutputStreamCreator(){

            @Override
            public ZstdCompressorOutputStream wrap(FileOutputStream os) throws IOException {
                return new ZstdCompressorOutputStream((OutputStream)os, 1);
            }
        });
    }

    @Test
    public void roundtripWithCloseFrameOnFlush() throws Exception {
        this.roundtrip(new OutputStreamCreator(){

            @Override
            public ZstdCompressorOutputStream wrap(FileOutputStream os) throws IOException {
                return new ZstdCompressorOutputStream((OutputStream)os, 3, true);
            }
        });
    }

    @Test
    public void roundtripWithChecksum() throws Exception {
        this.roundtrip(new OutputStreamCreator(){

            @Override
            public ZstdCompressorOutputStream wrap(FileOutputStream os) throws IOException {
                return new ZstdCompressorOutputStream((OutputStream)os, 3, false, true);
            }
        });
    }

    private static interface OutputStreamCreator {
        public ZstdCompressorOutputStream wrap(FileOutputStream var1) throws IOException;
    }
}

