/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.view.SVRowHeader;
import org.apache.poi.hssf.view.SVTableCellEditor;
import org.apache.poi.hssf.view.SVTableCellRenderer;
import org.apache.poi.hssf.view.SVTableModel;

public class SViewerPanel
extends JPanel {
    private static final int magicCharFactor = 7;
    HSSFWorkbook wb;
    JTabbedPane sheetPane;
    private SVTableCellRenderer cellRenderer;
    private SVTableCellEditor cellEditor;
    private boolean allowEdits;

    public SViewerPanel(HSSFWorkbook wb, boolean allowEdits) {
        this.wb = wb;
        this.allowEdits = allowEdits;
        this.initialiseGui();
    }

    private void initialiseGui() {
        this.cellRenderer = new SVTableCellRenderer(this.wb);
        if (this.allowEdits) {
            this.cellEditor = new SVTableCellEditor(this.wb);
        }
        this.sheetPane = new JTabbedPane(3);
        if (this.allowEdits) {
            this.sheetPane.addMouseListener(this.createTabListener());
        }
        int sheetCount = this.wb.getNumberOfSheets();
        for (int i = 0; i < sheetCount; ++i) {
            String sheetName = this.wb.getSheetName(i);
            this.sheetPane.addTab(sheetName, this.makeSheetView(this.wb.getSheetAt(i)));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.sheetPane, "Center");
    }

    protected JComponent makeSheetView(HSSFSheet sheet) {
        JTable sheetView = new JTable(new SVTableModel(sheet));
        sheetView.setAutoResizeMode(0);
        sheetView.setDefaultRenderer(HSSFCell.class, this.cellRenderer);
        if (this.allowEdits) {
            sheetView.setDefaultEditor(HSSFCell.class, this.cellEditor);
        }
        JTableHeader header = sheetView.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(this.allowEdits);
        TableColumnModel columns = sheetView.getColumnModel();
        for (int i = 0; i < columns.getColumnCount(); ++i) {
            TableColumn column = columns.getColumn(i);
            int width = sheet.getColumnWidth(i);
            column.setPreferredWidth(width / 256 * 7);
        }
        int rows = sheet.getPhysicalNumberOfRows();
        Insets insets = this.cellRenderer.getInsets();
        int extraHeight = insets.bottom + insets.top;
        for (int i = 0; i < rows; ++i) {
            HSSFRow row = sheet.getRow(i);
            if (row == null) {
                sheetView.setRowHeight(i, (int)sheet.getDefaultRowHeightInPoints() + extraHeight);
                continue;
            }
            sheetView.setRowHeight(i, (int)row.getHeightInPoints() + extraHeight);
        }
        SVRowHeader rowHeader = new SVRowHeader(sheet, sheetView, extraHeight);
        JScrollPane scroll = new JScrollPane(sheetView);
        scroll.setRowHeaderView(rowHeader);
        return scroll;
    }

    @Override
    public void paint(Graphics g) {
        long start = System.currentTimeMillis();
        super.paint(g);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Paint time = " + elapsed);
    }

    protected MouseListener createTabListener() {
        return new TabListener();
    }

    public boolean isEditable() {
        return this.allowEdits;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            throw new IllegalArgumentException("A filename to view must be supplied as the first argument, but none was given");
        }
        try (FileInputStream in = new FileInputStream(args[0]);
             HSSFWorkbook wb = new HSSFWorkbook((InputStream)in);){
            SViewerPanel p = new SViewerPanel(wb, true);
            JFrame frame = new JFrame(){

                @Override
                protected void processWindowEvent(WindowEvent e) {
                    super.processWindowEvent(e);
                    if (e.getID() == 201) {
                        System.exit(0);
                    }
                }

                @Override
                public synchronized void setTitle(String title) {
                    super.setTitle(title);
                    this.enableEvents(64L);
                }
            };
            frame.setTitle("Viewer Frame");
            frame.getContentPane().add((Component)p, "Center");
            frame.setSize(800, 640);
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
            frame.setVisible(true);
        }
    }

    private class DeleteSheetAction
    extends AbstractAction {
        public DeleteSheetAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int tabIndex = SViewerPanel.this.sheetPane.getSelectedIndex();
            if (tabIndex != -1 && JOptionPane.showConfirmDialog(SViewerPanel.this.sheetPane, "Are you sure that you want to delete the selected sheet", "Delete Sheet?", 2) == 0) {
                SViewerPanel.this.wb.removeSheetAt(tabIndex);
                SViewerPanel.this.sheetPane.remove(tabIndex);
            }
        }
    }

    private class InsertSheetAction
    extends AbstractAction {
        public InsertSheetAction() {
            super("Insert");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HSSFSheet newSheet = SViewerPanel.this.wb.createSheet();
            for (int i = 0; i < SViewerPanel.this.wb.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = SViewerPanel.this.wb.getSheetAt(i);
                if (newSheet != sheet) continue;
                SViewerPanel.this.sheetPane.insertTab(SViewerPanel.this.wb.getSheetName(i), null, SViewerPanel.this.makeSheetView(sheet), null, i);
            }
        }
    }

    private class RenameSheetAction
    extends AbstractAction {
        public RenameSheetAction() {
            super("Rename");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newSheetName;
            int tabIndex = SViewerPanel.this.sheetPane.getSelectedIndex();
            if (tabIndex != -1 && (newSheetName = JOptionPane.showInputDialog(SViewerPanel.this.sheetPane, "Enter a new Sheetname", "Rename Sheet", 3)) != null) {
                SViewerPanel.this.wb.setSheetName(tabIndex, newSheetName);
                SViewerPanel.this.sheetPane.setTitleAt(tabIndex, newSheetName);
            }
        }
    }

    private class TabListener
    implements MouseListener {
        public JPopupMenu popup = new JPopupMenu("Sheet");

        public TabListener() {
            this.popup.add(this.createInsertSheetAction());
            this.popup.add(this.createDeleteSheetAction());
            this.popup.add(this.createRenameSheetAction());
        }

        protected Action createInsertSheetAction() {
            return new InsertSheetAction();
        }

        protected Action createDeleteSheetAction() {
            return new DeleteSheetAction();
        }

        protected Action createRenameSheetAction() {
            return new RenameSheetAction();
        }

        protected void checkPopup(MouseEvent e) {
            int tab;
            if (e.isPopupTrigger() && (tab = SViewerPanel.this.sheetPane.getUI().tabForCoordinate(SViewerPanel.this.sheetPane, e.getX(), e.getY())) != -1) {
                this.popup.show(SViewerPanel.this.sheetPane, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

