/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.io.ByteOrderMark;
import org.junit.Assert;
import org.junit.Test;

public class ByteOrderMarkTestCase {
    private static final ByteOrderMark TEST_BOM_1 = new ByteOrderMark("test1", new int[]{1});
    private static final ByteOrderMark TEST_BOM_2 = new ByteOrderMark("test2", new int[]{1, 2});
    private static final ByteOrderMark TEST_BOM_3 = new ByteOrderMark("test3", new int[]{1, 2, 3});

    @Test
    public void charsetName() {
        Assert.assertEquals((String)"test1 name", (Object)"test1", (Object)TEST_BOM_1.getCharsetName());
        Assert.assertEquals((String)"test2 name", (Object)"test2", (Object)TEST_BOM_2.getCharsetName());
        Assert.assertEquals((String)"test3 name", (Object)"test3", (Object)TEST_BOM_3.getCharsetName());
    }

    @Test
    public void constantCharsetNames() {
        Assert.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_8.getCharsetName()));
        Assert.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_16BE.getCharsetName()));
        Assert.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_16LE.getCharsetName()));
        Assert.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_32BE.getCharsetName()));
        Assert.assertNotNull((Object)Charset.forName(ByteOrderMark.UTF_32LE.getCharsetName()));
    }

    @Test
    public void testLength() {
        Assert.assertEquals((String)"test1 length", (long)1L, (long)TEST_BOM_1.length());
        Assert.assertEquals((String)"test2 length", (long)2L, (long)TEST_BOM_2.length());
        Assert.assertEquals((String)"test3 length", (long)3L, (long)TEST_BOM_3.length());
    }

    @Test
    public void get() {
        Assert.assertEquals((String)"test1 get(0)", (long)1L, (long)TEST_BOM_1.get(0));
        Assert.assertEquals((String)"test2 get(0)", (long)1L, (long)TEST_BOM_2.get(0));
        Assert.assertEquals((String)"test2 get(1)", (long)2L, (long)TEST_BOM_2.get(1));
        Assert.assertEquals((String)"test3 get(0)", (long)1L, (long)TEST_BOM_3.get(0));
        Assert.assertEquals((String)"test3 get(1)", (long)2L, (long)TEST_BOM_3.get(1));
        Assert.assertEquals((String)"test3 get(2)", (long)3L, (long)TEST_BOM_3.get(2));
    }

    @Test
    public void getBytes() {
        Assert.assertTrue((String)"test1 bytes", (boolean)Arrays.equals(TEST_BOM_1.getBytes(), new byte[]{1}));
        Assert.assertTrue((String)"test1 bytes", (boolean)Arrays.equals(TEST_BOM_2.getBytes(), new byte[]{1, 2}));
        Assert.assertTrue((String)"test1 bytes", (boolean)Arrays.equals(TEST_BOM_3.getBytes(), new byte[]{1, 2, 3}));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((String)"test1 equals", (boolean)TEST_BOM_1.equals((Object)TEST_BOM_1));
        Assert.assertTrue((String)"test2 equals", (boolean)TEST_BOM_2.equals((Object)TEST_BOM_2));
        Assert.assertTrue((String)"test3 equals", (boolean)TEST_BOM_3.equals((Object)TEST_BOM_3));
        Assert.assertFalse((String)"Object not equal", (boolean)TEST_BOM_1.equals(new Object()));
        Assert.assertFalse((String)"test1-1 not equal", (boolean)TEST_BOM_1.equals((Object)new ByteOrderMark("1a", new int[]{2})));
        Assert.assertFalse((String)"test1-2 not test2", (boolean)TEST_BOM_1.equals((Object)new ByteOrderMark("1b", new int[]{1, 2})));
        Assert.assertFalse((String)"test2 not equal", (boolean)TEST_BOM_2.equals((Object)new ByteOrderMark("2", new int[]{1, 1})));
        Assert.assertFalse((String)"test3 not equal", (boolean)TEST_BOM_3.equals((Object)new ByteOrderMark("3", new int[]{1, 2, 4})));
    }

    @Test
    public void testHashCode() {
        int bomClassHash = ByteOrderMark.class.hashCode();
        Assert.assertEquals((String)"hash test1 ", (long)(bomClassHash + 1), (long)TEST_BOM_1.hashCode());
        Assert.assertEquals((String)"hash test2 ", (long)(bomClassHash + 3), (long)TEST_BOM_2.hashCode());
        Assert.assertEquals((String)"hash test3 ", (long)(bomClassHash + 6), (long)TEST_BOM_3.hashCode());
    }

    @Test
    public void errors() {
        try {
            new ByteOrderMark(null, new int[]{1, 2, 3});
            Assert.fail((String)"null charset name, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ByteOrderMark("", new int[]{1, 2, 3});
            Assert.fail((String)"no charset name, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ByteOrderMark("a", (int[])null);
            Assert.fail((String)"null bytes, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ByteOrderMark("b", new int[0]);
            Assert.fail((String)"empty bytes, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        Assert.assertEquals((String)"test1 ", (Object)"ByteOrderMark[test1: 0x1]", (Object)TEST_BOM_1.toString());
        Assert.assertEquals((String)"test2 ", (Object)"ByteOrderMark[test2: 0x1,0x2]", (Object)TEST_BOM_2.toString());
        Assert.assertEquals((String)"test3 ", (Object)"ByteOrderMark[test3: 0x1,0x2,0x3]", (Object)TEST_BOM_3.toString());
    }
}

