/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.testtools.TestUtils;
import org.apache.commons.io.testtools.YellOnCloseInputStream;
import org.apache.commons.io.testtools.YellOnFlushAndCloseOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class CopyUtilsTest {
    private static final int FILE_SIZE = 4097;
    private final byte[] inData = TestUtils.generateTestData(4097L);

    @Test
    public void testCtor() {
        new CopyUtils();
    }

    @Test
    public void copy_byteArrayToOutputStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((byte[])this.inData, (OutputStream)((Object)out));
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test
    public void copy_byteArrayToWriter() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        CopyUtils.copy((byte[])this.inData, (Writer)writer);
        ((Writer)writer).flush();
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test
    public void testCopy_byteArrayToWriterWithEncoding() throws Exception {
        String inDataStr = "data";
        String charsetName = "UTF-8";
        StringWriter writer = new StringWriter();
        CopyUtils.copy((byte[])"data".getBytes("UTF-8"), (Writer)writer, (String)"UTF-8");
        Assert.assertEquals((Object)"data", (Object)writer.toString());
    }

    @Test
    public void testCopy_inputStreamToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        int count = CopyUtils.copy((InputStream)in, (OutputStream)((Object)out));
        Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)((InputStream)in).available());
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
        Assert.assertEquals((long)this.inData.length, (long)count);
    }

    @Test
    public void copy_inputStreamToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        CopyUtils.copy((InputStream)in, (Writer)writer);
        ((Writer)writer).flush();
        Assert.assertEquals((String)"Not all bytes were read", (long)0L, (long)((InputStream)in).available());
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test
    public void copy_inputStreamToWriterWithEncoding() throws Exception {
        String inDataStr = "data";
        String charsetName = "UTF-8";
        StringWriter writer = new StringWriter();
        CopyUtils.copy((InputStream)new ByteArrayInputStream("data".getBytes("UTF-8")), (Writer)writer, (String)"UTF-8");
        Assert.assertEquals((Object)"data", (Object)writer.toString());
    }

    @Test
    public void testCopy_readerToOutputStream() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((Reader)reader, (OutputStream)((Object)out));
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test
    public void copy_readerToWriter() throws Exception {
        Object in = new ByteArrayInputStream(this.inData);
        in = new YellOnCloseInputStream((InputStream)in);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        int count = CopyUtils.copy((Reader)reader, (Writer)writer);
        ((Writer)writer).flush();
        Assert.assertEquals((String)"The number of characters returned by copy is wrong", (long)this.inData.length, (long)count);
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test
    public void copy_stringToOutputStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        CopyUtils.copy((String)str, (OutputStream)((Object)out));
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    @Test
    public void copy_stringToWriter() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)((Object)out), "US-ASCII");
        CopyUtils.copy((String)str, (Writer)writer);
        ((Writer)writer).flush();
        Assert.assertEquals((String)"Sizes differ", (long)this.inData.length, (long)baout.size());
        Assert.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }
}

