/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.junit.Assert;
import org.junit.Test;

public class DirectoryWalkerTestCaseJava4 {
    private static final File current = new File(".");
    private static final File javaDir = new File("src/main/java");
    private static final File orgDir = new File(javaDir, "org");
    private static final File apacheDir = new File(orgDir, "apache");
    private static final File commonsDir = new File(apacheDir, "commons");
    private static final File ioDir = new File(commonsDir, "io");
    private static final File outputDir = new File(ioDir, "output");
    private static final File[] dirs = new File[]{orgDir, apacheDir, commonsDir, ioDir, outputDir};
    private static final File filenameUtils = new File(ioDir, "FilenameUtils.java");
    private static final File ioUtils = new File(ioDir, "IOUtils.java");
    private static final File proxyWriter = new File(outputDir, "ProxyWriter.java");
    private static final File nullStream = new File(outputDir, "NullOutputStream.java");
    private static final File[] ioFiles = new File[]{filenameUtils, ioUtils};
    private static final File[] outputFiles = new File[]{proxyWriter, nullStream};
    private static final IOFileFilter dirsFilter = DirectoryWalkerTestCaseJava4.createNameFilter(dirs);
    private static final IOFileFilter iofilesFilter = DirectoryWalkerTestCaseJava4.createNameFilter(ioFiles);
    private static final IOFileFilter outputFilesFilter = DirectoryWalkerTestCaseJava4.createNameFilter(outputFiles);
    private static final IOFileFilter ioDirAndFilesFilter = new OrFileFilter(dirsFilter, iofilesFilter);
    private static final IOFileFilter dirsAndFilesFilter = new OrFileFilter(ioDirAndFilesFilter, outputFilesFilter);
    private static final IOFileFilter NOT_SVN = FileFilterUtils.makeSVNAware(null);

    @Test
    public void testFilter() {
        List<File> results = new TestFileFinder((FileFilter)dirsAndFilesFilter, -1).find(javaDir);
        Assert.assertEquals((String)"Result Size", (long)(1 + dirs.length + ioFiles.length + outputFiles.length), (long)results.size());
        Assert.assertTrue((String)"Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("Dir", dirs, results);
        this.checkContainsFiles("IO File", ioFiles, results);
        this.checkContainsFiles("Output File", outputFiles, results);
    }

    @Test
    public void testFilterAndLimitA() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 0).find(javaDir);
        Assert.assertEquals((String)"[A] Result Size", (long)1L, (long)results.size());
        Assert.assertTrue((String)"[A] Start Dir", (boolean)results.contains(javaDir));
    }

    @Test
    public void testFilterAndLimitB() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 1).find(javaDir);
        Assert.assertEquals((String)"[B] Result Size", (long)2L, (long)results.size());
        Assert.assertTrue((String)"[B] Start Dir", (boolean)results.contains(javaDir));
        Assert.assertTrue((String)"[B] Org Dir", (boolean)results.contains(orgDir));
    }

    @Test
    public void testFilterAndLimitC() {
        List<File> results = new TestFileFinder((FileFilter)NOT_SVN, 3).find(javaDir);
        Assert.assertEquals((String)"[C] Result Size", (long)4L, (long)results.size());
        Assert.assertTrue((String)"[C] Start Dir", (boolean)results.contains(javaDir));
        Assert.assertTrue((String)"[C] Org Dir", (boolean)results.contains(orgDir));
        Assert.assertTrue((String)"[C] Apache Dir", (boolean)results.contains(apacheDir));
        Assert.assertTrue((String)"[C] Commons Dir", (boolean)results.contains(commonsDir));
    }

    @Test
    public void testFilterAndLimitD() {
        List<File> results = new TestFileFinder((FileFilter)dirsAndFilesFilter, 5).find(javaDir);
        Assert.assertEquals((String)"[D] Result Size", (long)(1 + dirs.length + ioFiles.length), (long)results.size());
        Assert.assertTrue((String)"[D] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[D] Dir", dirs, results);
        this.checkContainsFiles("[D] File", ioFiles, results);
    }

    @Test
    public void testFilterDirAndFile1() {
        List<File> results = new TestFileFinder(dirsFilter, iofilesFilter, -1).find(javaDir);
        Assert.assertEquals((String)"[DirAndFile1] Result Size", (long)(1 + dirs.length + ioFiles.length), (long)results.size());
        Assert.assertTrue((String)"[DirAndFile1] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile1] Dir", dirs, results);
        this.checkContainsFiles("[DirAndFile1] File", ioFiles, results);
    }

    @Test
    public void testFilterDirAndFile2() {
        List<File> results = new TestFileFinder(null, null, -1).find(javaDir);
        Assert.assertTrue((String)"[DirAndFile2] Result Size", (results.size() > 1 + dirs.length + ioFiles.length ? 1 : 0) != 0);
        Assert.assertTrue((String)"[DirAndFile2] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile2] Dir", dirs, results);
        this.checkContainsFiles("[DirAndFile2] File", ioFiles, results);
    }

    @Test
    public void testFilterDirAndFile3() {
        List<File> results = new TestFileFinder(dirsFilter, null, -1).find(javaDir);
        List resultDirs = this.directoriesOnly(results);
        Assert.assertEquals((String)"[DirAndFile3] Result Size", (long)(1 + dirs.length), (long)resultDirs.size());
        Assert.assertTrue((String)"[DirAndFile3] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile3] Dir", dirs, resultDirs);
    }

    @Test
    public void testFilterDirAndFile4() {
        List<File> results = new TestFileFinder(null, iofilesFilter, -1).find(javaDir);
        List resultFiles = this.filesOnly(results);
        Assert.assertEquals((String)"[DirAndFile4] Result Size", (long)ioFiles.length, (long)resultFiles.size());
        Assert.assertTrue((String)"[DirAndFile4] Start Dir", (boolean)results.contains(javaDir));
        this.checkContainsFiles("[DirAndFile4] File", ioFiles, resultFiles);
    }

    @Test
    public void testLimitToCurrent() {
        List<File> results = new TestFileFinder(null, 0).find(current);
        Assert.assertEquals((String)"Result Size", (long)1L, (long)results.size());
        Assert.assertTrue((String)"Current Dir", (boolean)results.contains(new File(".")));
    }

    @Test
    public void testMissingStartDirectory() {
        File invalidDir = new File("invalid-dir");
        List<File> results = new TestFileFinder(null, -1).find(invalidDir);
        Assert.assertEquals((String)"Result Size", (long)1L, (long)results.size());
        Assert.assertTrue((String)"Current Dir", (boolean)results.contains(invalidDir));
        try {
            new TestFileFinder(null, -1).find(null);
            Assert.fail((String)"Null start directory didn't throw Exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testHandleStartDirectoryFalse() {
        List<File> results = new TestFalseFileFinder(null, -1).find(current);
        Assert.assertEquals((String)"Result Size", (long)0L, (long)results.size());
    }

    private void checkContainsFiles(String prefix, File[] files, Collection results) {
        for (int i = 0; i < files.length; ++i) {
            Assert.assertTrue((String)(prefix + "[" + i + "] " + files[i]), (boolean)results.contains(files[i]));
        }
    }

    private List directoriesOnly(Collection<File> results) {
        ArrayList<File> list = new ArrayList<File>(results.size());
        for (File file : results) {
            if (!file.isDirectory()) continue;
            list.add(file);
        }
        return list;
    }

    private List filesOnly(Collection<File> results) {
        ArrayList<File> list = new ArrayList<File>(results.size());
        for (File file : results) {
            if (!file.isFile()) continue;
            list.add(file);
        }
        return list;
    }

    private static IOFileFilter createNameFilter(File[] files) {
        String[] names = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            names[i] = files[i].getName();
        }
        return new NameFileFilter(names);
    }

    @Test
    public void testCancel() throws IOException {
        String cancelName = null;
        try {
            cancelName = "DirectoryWalker.java";
            new TestCancelWalker(cancelName, false).find(javaDir);
            Assert.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            Assert.assertEquals((String)("File:  " + cancelName), (Object)cancelName, (Object)cancel.getFile().getName());
            Assert.assertEquals((String)("Depth: " + cancelName), (long)5L, (long)cancel.getDepth());
        }
        try {
            cancelName = "commons";
            new TestCancelWalker(cancelName, false).find(javaDir);
            Assert.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            Assert.assertEquals((String)("File:  " + cancelName), (Object)cancelName, (Object)cancel.getFile().getName());
            Assert.assertEquals((String)("Depth: " + cancelName), (long)3L, (long)cancel.getDepth());
        }
        List results = new TestCancelWalker(cancelName, true).find(javaDir);
        File lastFile = (File)results.get(results.size() - 1);
        Assert.assertEquals((String)("Suppress:  " + cancelName), (Object)cancelName, (Object)lastFile.getName());
    }

    @Test
    public void testMultiThreadCancel() throws IOException {
        String cancelName = "DirectoryWalker.java";
        TestMultiThreadCancelWalker walker = new TestMultiThreadCancelWalker(cancelName, false);
        try {
            walker.find(javaDir);
            Assert.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            File last = (File)walker.results.get(walker.results.size() - 1);
            Assert.assertEquals((Object)cancelName, (Object)last.getName());
            Assert.assertEquals((String)("Depth: " + cancelName), (long)5L, (long)cancel.getDepth());
        }
        try {
            cancelName = "commons";
            walker = new TestMultiThreadCancelWalker(cancelName, false);
            walker.find(javaDir);
            Assert.fail((String)("CancelException not thrown for '" + cancelName + "'"));
        }
        catch (DirectoryWalker.CancelException cancel) {
            Assert.assertEquals((String)("File:  " + cancelName), (Object)cancelName, (Object)cancel.getFile().getName());
            Assert.assertEquals((String)("Depth: " + cancelName), (long)3L, (long)cancel.getDepth());
        }
        walker = new TestMultiThreadCancelWalker(cancelName, true);
        List results = walker.find(javaDir);
        File lastFile = (File)results.get(results.size() - 1);
        Assert.assertEquals((String)("Suppress:  " + cancelName), (Object)cancelName, (Object)lastFile.getName());
    }

    static class TestMultiThreadCancelWalker
    extends DirectoryWalker {
        private final String cancelFileName;
        private final boolean suppressCancel;
        private boolean cancelled;
        public List results;

        TestMultiThreadCancelWalker(String cancelFileName, boolean suppressCancel) {
            this.cancelFileName = cancelFileName;
            this.suppressCancel = suppressCancel;
        }

        protected List find(File startDirectory) throws IOException {
            this.results = new ArrayList();
            this.walk(startDirectory, this.results);
            return this.results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection results) throws IOException {
            results.add(directory);
            Assert.assertFalse((boolean)this.cancelled);
            if (this.cancelFileName.equals(directory.getName())) {
                this.cancelled = true;
            }
        }

        protected void handleFile(File file, int depth, Collection results) throws IOException {
            results.add(file);
            Assert.assertFalse((boolean)this.cancelled);
            if (this.cancelFileName.equals(file.getName())) {
                this.cancelled = true;
            }
        }

        protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
            return this.cancelled;
        }

        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            if (!this.suppressCancel) {
                super.handleCancelled(startDirectory, results, cancel);
            }
        }
    }

    static class TestCancelWalker
    extends DirectoryWalker {
        private final String cancelFileName;
        private final boolean suppressCancel;

        TestCancelWalker(String cancelFileName, boolean suppressCancel) {
            this.cancelFileName = cancelFileName;
            this.suppressCancel = suppressCancel;
        }

        protected List find(File startDirectory) throws IOException {
            ArrayList results = new ArrayList();
            this.walk(startDirectory, results);
            return results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection results) throws IOException {
            results.add(directory);
            if (this.cancelFileName.equals(directory.getName())) {
                throw new DirectoryWalker.CancelException(directory, depth);
            }
        }

        protected void handleFile(File file, int depth, Collection results) throws IOException {
            results.add(file);
            if (this.cancelFileName.equals(file.getName())) {
                throw new DirectoryWalker.CancelException(file, depth);
            }
        }

        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            if (!this.suppressCancel) {
                super.handleCancelled(startDirectory, results, cancel);
            }
        }
    }

    private static class TestFalseFileFinder
    extends TestFileFinder {
        protected TestFalseFileFinder(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected boolean handleDirectory(File directory, int depth, Collection results) {
            return false;
        }
    }

    private static class TestFileFinder
    extends DirectoryWalker {
        protected TestFileFinder(FileFilter filter, int depthLimit) {
            super(filter, depthLimit);
        }

        protected TestFileFinder(IOFileFilter dirFilter, IOFileFilter fileFilter, int depthLimit) {
            super(dirFilter, fileFilter, depthLimit);
        }

        protected List<File> find(File startDirectory) {
            ArrayList<File> results = new ArrayList<File>();
            try {
                this.walk(startDirectory, results);
            }
            catch (IOException ex) {
                Assert.fail((String)ex.toString());
            }
            return results;
        }

        protected void handleDirectoryEnd(File directory, int depth, Collection results) {
            results.add(directory);
        }

        protected void handleFile(File file, int depth, Collection results) {
            results.add(file);
        }
    }
}

