/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUtilsCleanSymlinksTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File top;

    @Before
    public void setUp() throws Exception {
        this.top = this.temporaryFolder.getRoot();
    }

    @Test
    public void testCleanDirWithSymlinkFile() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realOuter = new File(this.top, "realouter");
        Assert.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        Assert.assertTrue((boolean)realInner.mkdirs());
        File realFile = new File(realInner, "file1");
        FileUtils.touch((File)realFile);
        Assert.assertEquals((long)1L, (long)realInner.list().length);
        File randomFile = new File(this.top, "randomfile");
        FileUtils.touch((File)randomFile);
        File symlinkFile = new File(realInner, "fakeinner");
        this.setupSymlink(randomFile, symlinkFile);
        Assert.assertEquals((long)2L, (long)realInner.list().length);
        FileUtils.cleanDirectory((File)realOuter);
        Assert.assertEquals((long)0L, (long)realOuter.list().length);
        Assert.assertTrue((boolean)randomFile.exists());
        Assert.assertFalse((boolean)symlinkFile.exists());
    }

    @Test
    public void testCleanDirWithASymlinkDir() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realOuter = new File(this.top, "realouter");
        Assert.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        Assert.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        Assert.assertEquals((long)1L, (long)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        Assert.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assert.assertEquals((long)1L, (long)randomDirectory.list().length);
        File symlinkDirectory = new File(realOuter, "fakeinner");
        this.setupSymlink(randomDirectory, symlinkDirectory);
        Assert.assertEquals((long)1L, (long)symlinkDirectory.list().length);
        FileUtils.cleanDirectory((File)realOuter);
        Assert.assertEquals((long)0L, (long)realOuter.list().length);
        Assert.assertEquals((String)"Contents of sym link should not have been removed", (long)1L, (long)randomDirectory.list().length);
    }

    @Test
    public void testCleanDirWithParentSymlinks() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realParent = new File(this.top, "realparent");
        Assert.assertTrue((boolean)realParent.mkdirs());
        File realInner = new File(realParent, "realinner");
        Assert.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        Assert.assertEquals((long)1L, (long)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        Assert.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assert.assertEquals((long)1L, (long)randomDirectory.list().length);
        File symlinkDirectory = new File(realParent, "fakeinner");
        this.setupSymlink(randomDirectory, symlinkDirectory);
        Assert.assertEquals((long)1L, (long)symlinkDirectory.list().length);
        File symlinkParentDirectory = new File(this.top, "fakeouter");
        this.setupSymlink(realParent, symlinkParentDirectory);
        FileUtils.cleanDirectory((File)symlinkParentDirectory);
        Assert.assertEquals((long)0L, (long)symlinkParentDirectory.list().length);
        Assert.assertEquals((long)0L, (long)realParent.list().length);
        Assert.assertEquals((String)"Contents of sym link should not have been removed", (long)1L, (long)randomDirectory.list().length);
    }

    @Test
    public void testStillClearsIfGivenDirectoryIsASymlink() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomDirectory = new File(this.top, "randomDir");
        Assert.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        Assert.assertEquals((long)1L, (long)randomDirectory.list().length);
        File symlinkDirectory = new File(this.top, "fakeDir");
        this.setupSymlink(randomDirectory, symlinkDirectory);
        FileUtils.cleanDirectory((File)symlinkDirectory);
        Assert.assertEquals((long)0L, (long)symlinkDirectory.list().length);
        Assert.assertEquals((long)0L, (long)randomDirectory.list().length);
    }

    @Test
    public void testIdentifiesSymlinkDir() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomDirectory = new File(this.top, "randomDir");
        Assert.assertTrue((boolean)randomDirectory.mkdirs());
        File symlinkDirectory = new File(this.top, "fakeDir");
        this.setupSymlink(randomDirectory, symlinkDirectory);
        Assert.assertTrue((boolean)FileUtils.isSymlink((File)symlinkDirectory));
        Assert.assertFalse((boolean)FileUtils.isSymlink((File)randomDirectory));
    }

    @Test
    public void testIdentifiesSymlinkFile() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomFile = new File(this.top, "randomfile");
        FileUtils.touch((File)randomFile);
        File symlinkFile = new File(this.top, "fakeinner");
        this.setupSymlink(randomFile, symlinkFile);
        Assert.assertTrue((boolean)FileUtils.isSymlink((File)symlinkFile));
        Assert.assertFalse((boolean)FileUtils.isSymlink((File)randomFile));
    }

    @Test
    public void testIdentifiesBrokenSymlinkFile() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File noexistFile = new File(this.top, "noexist");
        File symlinkFile = new File(this.top, "fakeinner");
        File badSymlinkInPathFile = new File(symlinkFile, "fakeinner");
        File noexistParentFile = new File("noexist", "file");
        this.setupSymlink(noexistFile, symlinkFile);
        Assert.assertTrue((boolean)FileUtils.isSymlink((File)symlinkFile));
        Assert.assertFalse((boolean)FileUtils.isSymlink((File)noexistFile));
        Assert.assertFalse((boolean)FileUtils.isSymlink((File)noexistParentFile));
        Assert.assertFalse((boolean)FileUtils.isSymlink((File)badSymlinkInPathFile));
    }

    @Test
    public void testCorrectlyIdentifySymlinkWithParentSymLink() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realParent = new File(this.top, "realparent");
        Assert.assertTrue((boolean)realParent.mkdirs());
        File symlinkParentDirectory = new File(this.top, "fakeparent");
        this.setupSymlink(realParent, symlinkParentDirectory);
        File realChild = new File(symlinkParentDirectory, "realChild");
        Assert.assertTrue((boolean)realChild.mkdirs());
        File symlinkChild = new File(symlinkParentDirectory, "fakeChild");
        this.setupSymlink(realChild, symlinkChild);
        Assert.assertTrue((boolean)FileUtils.isSymlink((File)symlinkChild));
        Assert.assertFalse((boolean)FileUtils.isSymlink((File)realChild));
    }

    private void setupSymlink(File res, File link) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add("ln");
        args.add("-s");
        args.add(res.getAbsolutePath());
        args.add(link.getAbsolutePath());
        Process proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        proc.waitFor();
    }
}

