/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.junit.Assert;
import org.junit.Test;

public class FilenameUtilsWildcardTestCase {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    @Test
    public void testMatch() {
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch(null, (String)"Foo"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", null));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch(null, null));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)"*"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"", (String)"?"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo*"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo?"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar and Catflap", (String)"Fo*"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"New Bookmarks", (String)"N?w ?o?k??r?s"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Bar"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar Foo", (String)"F*o Bar*"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Adobe Acrobat Installer", (String)"Ad*er"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BarFoo", (String)"*Foo"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FooBar", (String)"Foo*"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*"));
    }

    @Test
    public void testMatchOnSystem() {
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem(null, (String)"Foo"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", null));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem(null, null));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Foo"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"", (String)""));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Fo*"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Fo?"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo Bar and Catflap", (String)"Fo*"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"New Bookmarks", (String)"N?w ?o?k??r?s"));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Bar"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo Bar Foo", (String)"F*o Bar*"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Adobe Acrobat Installer", (String)"Ad*er"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"*Foo"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"BarFoo", (String)"*Foo"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"Foo", (String)"Foo*"));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatchOnSystem((String)"FooBar", (String)"Foo*"));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem((String)"FOO", (String)"*Foo"));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem((String)"BARFOO", (String)"*Foo"));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem((String)"FOO", (String)"Foo*"));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatchOnSystem((String)"FOOBAR", (String)"Foo*"));
    }

    @Test
    public void testMatchCaseSpecified() {
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch(null, (String)"Foo", (IOCase)IOCase.SENSITIVE));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", null, (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch(null, null, (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"", (String)"", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo*", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Fo?", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar and Catflap", (String)"Fo*", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"New Bookmarks", (String)"N?w ?o?k??r?s", (IOCase)IOCase.SENSITIVE));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Bar", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo Bar Foo", (String)"F*o Bar*", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Adobe Acrobat Installer", (String)"Ad*er", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BarFoo", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"Foo", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FooBar", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.SENSITIVE));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assert.assertFalse((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.SENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.INSENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.INSENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.INSENSITIVE));
        Assert.assertTrue((boolean)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.INSENSITIVE));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch((String)"FOO", (String)"*Foo", (IOCase)IOCase.SYSTEM));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch((String)"BARFOO", (String)"*Foo", (IOCase)IOCase.SYSTEM));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch((String)"FOO", (String)"Foo*", (IOCase)IOCase.SYSTEM));
        Assert.assertEquals((Object)WINDOWS, (Object)FilenameUtils.wildcardMatch((String)"FOOBAR", (String)"Foo*", (IOCase)IOCase.SYSTEM));
    }

    @Test
    public void testSplitOnTokens() {
        Assert.assertArrayEquals((Object[])new String[]{"Ad", "*", "er"}, (Object[])FilenameUtils.splitOnTokens((String)"Ad*er"));
        Assert.assertArrayEquals((Object[])new String[]{"Ad", "?", "er"}, (Object[])FilenameUtils.splitOnTokens((String)"Ad?er"));
        Assert.assertArrayEquals((Object[])new String[]{"Test", "*", "?", "One"}, (Object[])FilenameUtils.splitOnTokens((String)"Test*?One"));
        Assert.assertArrayEquals((Object[])new String[]{"Test", "?", "*", "One"}, (Object[])FilenameUtils.splitOnTokens((String)"Test?*One"));
        Assert.assertArrayEquals((Object[])new String[]{"*"}, (Object[])FilenameUtils.splitOnTokens((String)"****"));
        Assert.assertArrayEquals((Object[])new String[]{"*", "?", "?", "*"}, (Object[])FilenameUtils.splitOnTokens((String)"*??*"));
        Assert.assertArrayEquals((Object[])new String[]{"*", "?", "*", "?", "*"}, (Object[])FilenameUtils.splitOnTokens((String)"*?**?*"));
        Assert.assertArrayEquals((Object[])new String[]{"*", "?", "*", "?", "*"}, (Object[])FilenameUtils.splitOnTokens((String)"*?***?*"));
        Assert.assertArrayEquals((Object[])new String[]{"h", "?", "?", "*"}, (Object[])FilenameUtils.splitOnTokens((String)"h??*"));
        Assert.assertArrayEquals((Object[])new String[]{""}, (Object[])FilenameUtils.splitOnTokens((String)""));
    }

    private void assertMatch(String text, String wildcard, boolean expected) {
        Assert.assertEquals((String)(text + " " + wildcard), (Object)expected, (Object)FilenameUtils.wildcardMatch((String)text, (String)wildcard));
    }

    @Test
    public void testMatch2() {
        this.assertMatch("log.txt", "log.txt", true);
        this.assertMatch("log.txt1", "log.txt", false);
        this.assertMatch("log.txt", "log.txt*", true);
        this.assertMatch("log.txt", "log.txt*1", false);
        this.assertMatch("log.txt", "*log.txt*", true);
        this.assertMatch("log.txt", "*.txt", true);
        this.assertMatch("txt.log", "*.txt", false);
        this.assertMatch("config.ini", "*.ini", true);
        this.assertMatch("config.txt.bak", "con*.txt", false);
        this.assertMatch("log.txt9", "*.txt?", true);
        this.assertMatch("log.txt", "*.txt?", false);
        this.assertMatch("progtestcase.java~5~", "*test*.java~*~", true);
        this.assertMatch("progtestcase.java;5~", "*test*.java~*~", false);
        this.assertMatch("progtestcase.java~5", "*test*.java~*~", false);
        this.assertMatch("log.txt", "log.*", true);
        this.assertMatch("log.txt", "log?*", true);
        this.assertMatch("log.txt12", "log.txt??", true);
        this.assertMatch("log.log", "log**log", true);
        this.assertMatch("log.log", "log**", true);
        this.assertMatch("log.log", "log.**", true);
        this.assertMatch("log.log", "**.log", true);
        this.assertMatch("log.log", "**log", true);
        this.assertMatch("log.log", "log*log", true);
        this.assertMatch("log.log", "log*", true);
        this.assertMatch("log.log", "log.*", true);
        this.assertMatch("log.log", "*.log", true);
        this.assertMatch("log.log", "*log", true);
        this.assertMatch("log.log", "*log?", false);
        this.assertMatch("log.log", "*log?*", true);
        this.assertMatch("log.log.abc", "*log?abc", true);
        this.assertMatch("log.log.abc.log.abc", "*log?abc", true);
        this.assertMatch("log.log.abc.log.abc.d", "*log?abc?d", true);
    }

    @Test
    public void test_IO_246() {
        this.assertMatch("aaa", "aa*?", true);
        this.assertMatch("", "?*", false);
        this.assertMatch("a", "a?*", false);
        this.assertMatch("aa", "aa?*", false);
        this.assertMatch("a", "?*", true);
        this.assertMatch("aa", "?*", true);
        this.assertMatch("aaa", "?*", true);
        this.assertMatch("", "?", false);
        this.assertMatch("a", "a?", false);
        this.assertMatch("aa", "aa?", false);
        this.assertMatch("aab", "aa?", true);
        this.assertMatch("aaa", "*a", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocaleIndependence() {
        Locale orig = Locale.getDefault();
        Locale[] locales = Locale.getAvailableLocales();
        String[][] data = new String[][]{{"I", "i"}, {"i", "I"}, {"i", "\u0130"}, {"i", "\u0131"}, {"\u03a3", "\u03c2"}, {"\u03a3", "\u03c3"}, {"\u03c2", "\u03c3"}};
        try {
            for (int i = 0; i < data.length; ++i) {
                for (Locale locale : locales) {
                    Locale.setDefault(locale);
                    Assert.assertTrue((String)("Test data corrupt: " + i), (boolean)data[i][0].equalsIgnoreCase(data[i][1]));
                    boolean match = FilenameUtils.wildcardMatch((String)data[i][0], (String)data[i][1], (IOCase)IOCase.INSENSITIVE);
                    Assert.assertTrue((String)(Locale.getDefault().toString() + ": " + i), (boolean)match);
                }
            }
        }
        finally {
            Locale.setDefault(orig);
        }
    }
}

