/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class ComparatorAbstractTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    protected AbstractFileComparator comparator;
    protected Comparator<File> reverse;
    protected File equalFile1;
    protected File equalFile2;
    protected File lessFile;
    protected File moreFile;

    protected File getTestDirectory() {
        return this.temporaryFolder.getRoot();
    }

    @Test
    public void testComparator() {
        Assert.assertEquals((String)"equal", (long)0L, (long)this.comparator.compare((Object)this.equalFile1, (Object)this.equalFile2));
        Assert.assertTrue((String)"less", (this.comparator.compare((Object)this.lessFile, (Object)this.moreFile) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"more", (this.comparator.compare((Object)this.moreFile, (Object)this.lessFile) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReverseComparator() {
        Assert.assertEquals((String)"equal", (long)0L, (long)this.reverse.compare(this.equalFile1, this.equalFile2));
        Assert.assertTrue((String)"less", (this.reverse.compare(this.moreFile, this.lessFile) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"more", (this.reverse.compare(this.lessFile, this.moreFile) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSortArrayNull() {
        Assert.assertNull((Object)this.comparator.sort((File[])null));
    }

    @Test
    public void testSortArray() {
        File[] files = new File[]{this.equalFile1, this.moreFile, this.lessFile};
        this.comparator.sort(files);
        Assert.assertSame((String)"equal", (Object)this.lessFile, (Object)files[0]);
        Assert.assertSame((String)"less", (Object)this.equalFile1, (Object)files[1]);
        Assert.assertSame((String)"more", (Object)this.moreFile, (Object)files[2]);
    }

    @Test
    public void testSortList() {
        ArrayList<File> files = new ArrayList<File>();
        files.add(this.equalFile1);
        files.add(this.moreFile);
        files.add(this.lessFile);
        this.comparator.sort(files);
        Assert.assertSame((String)"equal", (Object)this.lessFile, files.get(0));
        Assert.assertSame((String)"less", (Object)this.equalFile1, files.get(1));
        Assert.assertSame((String)"more", (Object)this.moreFile, files.get(2));
    }

    @Test
    public void testSortListNull() {
        Assert.assertNull((Object)this.comparator.sort((List)null));
    }

    @Test
    public void testToString() {
        Assert.assertNotNull((String)"comparator", (Object)this.comparator.toString());
        Assert.assertTrue((String)"reverse", (boolean)this.reverse.toString().startsWith("ReverseComparator["));
    }
}

