/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CloseShieldInputStreamTest {
    private byte[] data;
    private InputStream original;
    private InputStream shielded;
    private boolean closed;

    @Before
    public void setUp() {
        this.data = new byte[]{120, 121, 122};
        this.original = new ByteArrayInputStream(this.data){

            @Override
            public void close() {
                CloseShieldInputStreamTest.this.closed = true;
            }
        };
        this.shielded = new CloseShieldInputStream(this.original);
        this.closed = false;
    }

    @Test
    public void testClose() throws IOException {
        this.shielded.close();
        Assert.assertFalse((String)"closed", (boolean)this.closed);
        Assert.assertEquals((String)"read()", (long)-1L, (long)this.shielded.read());
        Assert.assertEquals((String)"read()", (long)this.data[0], (long)this.original.read());
    }
}

