/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ChunkedWriter;
import org.junit.Assert;
import org.junit.Test;

public class ChunkedWriterTest {
    @Test
    public void write_four_chunks() throws Exception {
        AtomicInteger numWrites = new AtomicInteger();
        OutputStreamWriter osw = this.getOutputStreamWriter(numWrites);
        ChunkedWriter chunked = new ChunkedWriter((Writer)osw, 10);
        chunked.write("0123456789012345678901234567891".toCharArray());
        chunked.flush();
        Assert.assertEquals((long)4L, (long)numWrites.get());
        chunked.close();
    }

    @Test
    public void write_two_chunks_default_constructor() throws Exception {
        AtomicInteger numWrites = new AtomicInteger();
        OutputStreamWriter osw = this.getOutputStreamWriter(numWrites);
        ChunkedWriter chunked = new ChunkedWriter((Writer)osw);
        chunked.write(new char[4097]);
        chunked.flush();
        Assert.assertEquals((long)2L, (long)numWrites.get());
        chunked.close();
    }

    private OutputStreamWriter getOutputStreamWriter(final AtomicInteger numWrites) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return new OutputStreamWriter((OutputStream)baos){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                numWrites.incrementAndGet();
                super.write(cbuf, off, len);
            }
        };
    }

    @Test(expected=IllegalArgumentException.class)
    public void negative_chunksize_not_permitted() throws Exception {
        new ChunkedWriter((Writer)new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()), 0).close();
    }
}

