/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CloseShieldOutputStreamTest {
    private ByteArrayOutputStream original;
    private OutputStream shielded;
    private boolean closed;

    @Before
    public void setUp() {
        this.original = new ByteArrayOutputStream(){

            public void close() {
                CloseShieldOutputStreamTest.this.closed = true;
            }
        };
        this.shielded = new CloseShieldOutputStream((OutputStream)this.original);
        this.closed = false;
    }

    @Test
    public void testClose() throws IOException {
        this.shielded.close();
        Assert.assertFalse((String)"closed", (boolean)this.closed);
        try {
            this.shielded.write(120);
            Assert.fail((String)"write(b)");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.original.write(121);
        Assert.assertEquals((long)1L, (long)this.original.size());
        Assert.assertEquals((long)121L, (long)this.original.toByteArray()[0]);
    }
}

