/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeferredFileOutputStreamTest {
    private final String testString = "0123456789";
    private final byte[] testBytes = "0123456789".getBytes();
    private final int initialBufferSize;

    @Parameterized.Parameters(name="initialBufferSize = {0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({1}, {2}, {4}, {8}, {16}, {32}, {64}, {128}, {256}, {512}, {1024}, {2048}, {4096});
    }

    public DeferredFileOutputStreamTest(int initialBufferSize) {
        this.initialBufferSize = initialBufferSize;
    }

    @Test
    public void testBelowThreshold() {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length + 42, this.initialBufferSize, null);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertTrue((boolean)dfos.isInMemory());
        byte[] resultBytes = dfos.getData();
        Assert.assertEquals((long)this.testBytes.length, (long)resultBytes.length);
        Assert.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
    }

    @Test
    public void testAtThreshold() {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length, this.initialBufferSize, null);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertTrue((boolean)dfos.isInMemory());
        byte[] resultBytes = dfos.getData();
        Assert.assertEquals((long)this.testBytes.length, (long)resultBytes.length);
        Assert.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
    }

    @Test
    public void testAboveThreshold() {
        File testFile = new File("testAboveThreshold.dat");
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, this.initialBufferSize, testFile);
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertFalse((boolean)dfos.isInMemory());
        Assert.assertNull((Object)dfos.getData());
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    @Test
    public void testThresholdReached() {
        File testFile = new File("testThresholdReached.dat");
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length / 2, this.initialBufferSize, testFile);
        int chunkSize = this.testBytes.length / 3;
        try {
            dfos.write(this.testBytes, 0, chunkSize);
            dfos.write(this.testBytes, chunkSize, chunkSize);
            dfos.write(this.testBytes, chunkSize * 2, this.testBytes.length - chunkSize * 2);
            dfos.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertFalse((boolean)dfos.isInMemory());
        Assert.assertNull((Object)dfos.getData());
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    @Test
    public void testWriteToSmall() {
        File testFile = new File("testWriteToMem.dat");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.initialBufferSize);
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length * 2, this.initialBufferSize, testFile);
        try {
            dfos.write(this.testBytes);
            Assert.assertFalse((boolean)testFile.exists());
            Assert.assertTrue((boolean)dfos.isInMemory());
            try {
                dfos.writeTo((OutputStream)baos);
                Assert.fail((String)"Should not have been able to write before closing");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dfos.close();
            dfos.writeTo((OutputStream)baos);
        }
        catch (IOException ioe) {
            Assert.fail((String)"Unexpected IOException");
        }
        byte[] copiedBytes = baos.toByteArray();
        Assert.assertTrue((boolean)Arrays.equals(this.testBytes, copiedBytes));
        testFile.delete();
    }

    @Test
    public void testWriteToLarge() {
        File testFile = new File("testWriteToFile.dat");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.initialBufferSize);
        testFile.delete();
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length / 2, testFile);
        try {
            dfos.write(this.testBytes);
            Assert.assertTrue((boolean)testFile.exists());
            Assert.assertFalse((boolean)dfos.isInMemory());
            try {
                dfos.writeTo((OutputStream)baos);
                Assert.fail((String)"Should not have been able to write before closeing");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dfos.close();
            dfos.writeTo((OutputStream)baos);
        }
        catch (IOException ioe) {
            Assert.fail((String)"Unexpected IOException");
        }
        byte[] copiedBytes = baos.toByteArray();
        Assert.assertTrue((boolean)Arrays.equals(this.testBytes, copiedBytes));
        this.verifyResultFile(testFile);
        testFile.delete();
    }

    @Test
    public void testTempFileBelowThreshold() {
        String prefix = "commons-io-test";
        String suffix = ".out";
        File tempDir = new File(".");
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length + 42, this.initialBufferSize, "commons-io-test", ".out", tempDir);
        Assert.assertNull((String)"Check file is null-A", (Object)dfos.getFile());
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertTrue((boolean)dfos.isInMemory());
        Assert.assertNull((String)"Check file is null-B", (Object)dfos.getFile());
    }

    @Test
    public void testTempFileAboveThreshold() {
        String prefix = "commons-io-test";
        String suffix = ".out";
        File tempDir = new File(".");
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, this.initialBufferSize, "commons-io-test", ".out", tempDir);
        Assert.assertNull((String)"Check file is null-A", (Object)dfos.getFile());
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertFalse((boolean)dfos.isInMemory());
        Assert.assertNull((Object)dfos.getData());
        Assert.assertNotNull((String)"Check file not null", (Object)dfos.getFile());
        Assert.assertTrue((String)"Check file exists", (boolean)dfos.getFile().exists());
        Assert.assertTrue((String)"Check prefix", (boolean)dfos.getFile().getName().startsWith("commons-io-test"));
        Assert.assertTrue((String)"Check suffix", (boolean)dfos.getFile().getName().endsWith(".out"));
        Assert.assertEquals((String)"Check dir", (Object)tempDir.getPath(), (Object)dfos.getFile().getParent());
        this.verifyResultFile(dfos.getFile());
        dfos.getFile().delete();
    }

    @Test
    public void testTempFileAboveThresholdPrefixOnly() {
        String prefix = "commons-io-test";
        String suffix = null;
        File tempDir = null;
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(this.testBytes.length - 5, this.initialBufferSize, "commons-io-test", suffix, tempDir);
        Assert.assertNull((String)"Check file is null-A", (Object)dfos.getFile());
        try {
            dfos.write(this.testBytes, 0, this.testBytes.length);
            dfos.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
        Assert.assertFalse((boolean)dfos.isInMemory());
        Assert.assertNull((Object)dfos.getData());
        Assert.assertNotNull((String)"Check file not null", (Object)dfos.getFile());
        Assert.assertTrue((String)"Check file exists", (boolean)dfos.getFile().exists());
        Assert.assertTrue((String)"Check prefix", (boolean)dfos.getFile().getName().startsWith("commons-io-test"));
        Assert.assertTrue((String)"Check suffix", (boolean)dfos.getFile().getName().endsWith(".tmp"));
        this.verifyResultFile(dfos.getFile());
        dfos.getFile().delete();
    }

    @Test
    public void testTempFileError() throws Exception {
        String prefix = null;
        String suffix = ".out";
        File tempDir = new File(".");
        try {
            new DeferredFileOutputStream(this.testBytes.length - 5, prefix, ".out", tempDir).close();
            Assert.fail((String)"Expected IllegalArgumentException ");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void verifyResultFile(File testFile) {
        try {
            FileInputStream fis = new FileInputStream(testFile);
            Assert.assertEquals((long)this.testBytes.length, (long)fis.available());
            byte[] resultBytes = new byte[this.testBytes.length];
            Assert.assertEquals((long)this.testBytes.length, (long)fis.read(resultBytes));
            Assert.assertTrue((boolean)Arrays.equals(resultBytes, this.testBytes));
            Assert.assertEquals((long)-1L, (long)fis.read(resultBytes));
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)"Unexpected FileNotFoundException");
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException");
        }
    }
}

