/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.FactoryUtils;
import org.apache.commons.collections4.FunctorException;
import org.apache.commons.collections4.TestUtils;
import org.apache.commons.collections4.functors.ConstantFactory;
import org.apache.commons.collections4.functors.ExceptionFactory;
import org.junit.Assert;
import org.junit.Test;

public class FactoryUtilsTest {
    @Test
    public void testExceptionFactory() {
        Assert.assertNotNull((Object)FactoryUtils.exceptionFactory());
        Assert.assertSame((Object)FactoryUtils.exceptionFactory(), (Object)FactoryUtils.exceptionFactory());
        try {
            FactoryUtils.exceptionFactory().create();
        }
        catch (FunctorException ex) {
            try {
                FactoryUtils.exceptionFactory().create();
            }
            catch (FunctorException ex2) {
                return;
            }
        }
        Assert.fail();
    }

    @Test
    public void testNullFactory() {
        Factory factory = FactoryUtils.nullFactory();
        Assert.assertNotNull((Object)factory);
        Object created = factory.create();
        Assert.assertNull((Object)created);
    }

    @Test
    public void testConstantFactoryNull() {
        Factory factory = FactoryUtils.constantFactory(null);
        Assert.assertNotNull((Object)factory);
        Object created = factory.create();
        Assert.assertNull((Object)created);
    }

    @Test
    public void testConstantFactoryConstant() {
        Integer constant = 9;
        Factory factory = FactoryUtils.constantFactory((Object)constant);
        Assert.assertNotNull((Object)factory);
        Integer created = (Integer)factory.create();
        Assert.assertSame((Object)constant, (Object)created);
    }

    @Test
    public void testPrototypeFactoryNull() {
        Assert.assertSame((Object)ConstantFactory.NULL_INSTANCE, (Object)FactoryUtils.prototypeFactory(null));
    }

    @Test
    public void testPrototypeFactoryPublicCloneMethod() throws Exception {
        Date proto = new Date();
        Factory factory = FactoryUtils.prototypeFactory((Object)proto);
        Assert.assertNotNull((Object)factory);
        Date created = (Date)factory.create();
        Assert.assertTrue((proto != created ? 1 : 0) != 0);
        Assert.assertEquals((Object)proto, (Object)created);
    }

    @Test
    public void testPrototypeFactoryPublicCopyConstructor() throws Exception {
        Mock1 proto = new Mock1(6);
        Factory factory = FactoryUtils.prototypeFactory((Object)proto);
        Assert.assertNotNull((Object)factory);
        Object created = factory.create();
        Assert.assertTrue((proto != created ? 1 : 0) != 0);
        Assert.assertEquals((Object)proto, (Object)created);
    }

    @Test
    public void testPrototypeFactoryPublicSerialization() throws Exception {
        Integer proto = 9;
        Factory factory = FactoryUtils.prototypeFactory((Object)proto);
        Assert.assertNotNull((Object)factory);
        Integer created = (Integer)factory.create();
        Assert.assertTrue((proto != created ? 1 : 0) != 0);
        Assert.assertEquals((Object)proto, (Object)created);
    }

    @Test
    public void testPrototypeFactoryPublicSerializationError() {
        Mock2 proto = new Mock2(new Object());
        Factory factory = FactoryUtils.prototypeFactory((Object)proto);
        Assert.assertNotNull((Object)factory);
        try {
            factory.create();
        }
        catch (FunctorException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof IOException));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testPrototypeFactoryPublicBad() {
        Object proto = new Object();
        try {
            FactoryUtils.prototypeFactory((Object)proto);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        Assert.fail();
    }

    @Test(expected=NullPointerException.class)
    public void instantiateFactoryNull() {
        FactoryUtils.instantiateFactory(null);
    }

    @Test
    public void instantiateFactorySimple() {
        Factory factory = FactoryUtils.instantiateFactory(Mock3.class);
        Assert.assertNotNull((Object)factory);
        Mock3 created = (Mock3)factory.create();
        Assert.assertEquals((long)0L, (long)created.getValue());
        created = (Mock3)factory.create();
        Assert.assertEquals((long)1L, (long)created.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void instantiateFactoryMismatch() {
        FactoryUtils.instantiateFactory(Date.class, null, (Object[])new Object[]{null});
    }

    @Test(expected=IllegalArgumentException.class)
    public void instantiateFactoryNoConstructor() {
        FactoryUtils.instantiateFactory(Date.class, (Class[])new Class[]{Long.class}, (Object[])new Object[]{null});
    }

    @Test
    public void instantiateFactoryComplex() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        Factory factory = FactoryUtils.instantiateFactory(Date.class, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{70, 0, 2});
        Assert.assertNotNull((Object)factory);
        Date created = (Date)factory.create();
        Assert.assertEquals((Object)new Date(86400000L), (Object)created);
    }

    @Test
    public void testSingletonPatternInSerialization() {
        Object[] singletones;
        for (Object original : singletones = new Object[]{ExceptionFactory.INSTANCE}) {
            TestUtils.assertSameAfterSerialization("Singletone patern broken for " + original.getClass(), original);
        }
    }

    public static class Mock3 {
        private static int cCounter = 0;
        private final int iVal = cCounter++;

        public int getValue() {
            return this.iVal;
        }
    }

    public static class Mock2
    implements Serializable {
        private static final long serialVersionUID = 4899282162482588924L;
        private final Object iVal;

        public Mock2(Object val) {
            this.iVal = val;
        }

        public boolean equals(Object obj) {
            return obj instanceof Mock2 && this.iVal == ((Mock2)obj).iVal;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class Mock1 {
        private final int iVal;

        public Mock1(int val) {
            this.iVal = val;
        }

        public Mock1(Mock1 mock) {
            this.iVal = mock.iVal;
        }

        public boolean equals(Object obj) {
            return obj instanceof Mock1 && this.iVal == ((Mock1)obj).iVal;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

