/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Get;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.Put;
import org.apache.commons.collections4.SplitMapUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.functors.NOPTransformer;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.collections4.splitmap.TransformedSplitMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SplitMapUtilsTest {
    private Map<String, Integer> backingMap;
    private TransformedSplitMap<String, String, String, Integer> transformedMap;
    private final Transformer<String, Integer> stringToInt = new Transformer<String, Integer>(){

        public Integer transform(String input) {
            return Integer.valueOf(input);
        }
    };

    @Before
    public void setUp() throws Exception {
        this.backingMap = new HashMap<String, Integer>();
        this.transformedMap = TransformedSplitMap.transformingMap(this.backingMap, (Transformer)NOPTransformer.nopTransformer(), this.stringToInt);
        for (int i = 0; i < 10; ++i) {
            this.transformedMap.put((Object)String.valueOf(i), (Object)String.valueOf(i));
        }
    }

    @Test
    public void testReadableMap() {
        final IterableMap map = SplitMapUtils.readableMap(this.transformedMap);
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)map.containsValue((Object)String.valueOf(i)));
            Assert.assertEquals((long)i, (long)((Integer)map.get((Object)String.valueOf(i))).intValue());
        }
        MapIterator it = map.mapIterator();
        while (it.hasNext()) {
            String k = (String)it.next();
            Assert.assertEquals((Object)k, (Object)it.getKey());
            Assert.assertEquals((Object)Integer.valueOf(k), (Object)it.getValue());
        }
        Assert.assertTrue((boolean)(map instanceof Unmodifiable));
        int sz = map.size();
        this.attemptPutOperation(new Runnable(){

            @Override
            public void run() {
                map.clear();
            }
        });
        Assert.assertEquals((long)sz, (long)map.size());
        this.attemptPutOperation(new Runnable(){

            @Override
            public void run() {
                map.put((Object)"foo", (Object)100);
            }
        });
        final HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("foo", 100);
        m.put("bar", 200);
        m.put("baz", 300);
        this.attemptPutOperation(new Runnable(){

            @Override
            public void run() {
                map.putAll((Map)m);
            }
        });
        IterableMap other = SplitMapUtils.readableMap(this.transformedMap);
        Assert.assertEquals((Object)other, (Object)map);
        Assert.assertEquals((long)other.hashCode(), (long)map.hashCode());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)((Integer)map.remove((Object)String.valueOf(i))).intValue());
            Assert.assertEquals((long)(--sz), (long)map.size());
        }
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertSame((Object)map, (Object)SplitMapUtils.readableMap((Get)map));
    }

    @Test
    public void testAlreadyReadableMap() {
        HashedMap hashedMap = new HashedMap();
        Assert.assertSame((Object)hashedMap, (Object)SplitMapUtils.readableMap((Get)hashedMap));
    }

    @Test
    public void testWritableMap() {
        final Map map = SplitMapUtils.writableMap(this.transformedMap);
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.get(null);
            }
        });
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.entrySet();
            }
        });
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.keySet();
            }
        });
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.values();
            }
        });
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.size();
            }
        });
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.isEmpty();
            }
        });
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.containsKey(null);
            }
        });
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.containsValue(null);
            }
        });
        this.attemptGetOperation(new Runnable(){

            @Override
            public void run() {
                map.remove(null);
            }
        });
        Map other = SplitMapUtils.writableMap(this.transformedMap);
        Assert.assertEquals((Object)other, (Object)map);
        Assert.assertEquals((long)other.hashCode(), (long)map.hashCode());
        int sz = this.backingMap.size();
        Assert.assertFalse((boolean)this.backingMap.containsKey("foo"));
        map.put("new", "66");
        Assert.assertEquals((long)(++sz), (long)this.backingMap.size());
        HashMap<String, String> more = new HashMap<String, String>();
        more.put("foo", "77");
        more.put("bar", "88");
        more.put("baz", "99");
        map.putAll(more);
        Assert.assertEquals((long)(sz + more.size()), (long)this.backingMap.size());
        map.clear();
        Assert.assertTrue((boolean)this.backingMap.isEmpty());
        Assert.assertSame((Object)map, (Object)SplitMapUtils.writableMap((Put)((Put)map)));
    }

    @Test
    public void testAlreadyWritableMap() {
        HashedMap hashedMap = new HashedMap();
        Assert.assertSame((Object)hashedMap, (Object)SplitMapUtils.writableMap((Put)hashedMap));
    }

    private void attemptGetOperation(Runnable r) {
        this.attemptMapOperation("Put exposed as writable Map must not allow Get operations", r);
    }

    private void attemptPutOperation(Runnable r) {
        this.attemptMapOperation("Get exposed as writable Map must not allow Put operations", r);
    }

    private void attemptMapOperation(String s, Runnable r) {
        try {
            r.run();
            Assert.fail((String)s);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

