/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AbstractPredicateTest;
import org.apache.commons.collections4.functors.EqualPredicate;
import org.apache.commons.collections4.functors.NullPredicate;
import org.junit.Assert;
import org.junit.Test;

public class EqualPredicateTest
extends AbstractPredicateTest {
    private static final EqualsTestObject FALSE_OBJECT = new EqualsTestObject(false);
    private static final EqualsTestObject TRUE_OBJECT = new EqualsTestObject(true);

    protected Predicate<Object> generatePredicate() {
        return EqualPredicate.equalPredicate(null);
    }

    @Test
    public void testNullArgumentEqualsNullPredicate() throws Exception {
        Assert.assertSame((Object)NullPredicate.nullPredicate(), (Object)EqualPredicate.equalPredicate(null));
    }

    @Test
    public void objectFactoryUsesEqualsForTest() throws Exception {
        Predicate predicate = EqualPredicate.equalPredicate((Object)FALSE_OBJECT);
        this.assertFalse(predicate, FALSE_OBJECT);
        this.assertTrue(EqualPredicate.equalPredicate((Object)TRUE_OBJECT), TRUE_OBJECT);
    }

    @Test
    public void testPredicateTypeCanBeSuperClassOfObject() throws Exception {
        Predicate predicate = EqualPredicate.equalPredicate((Object)4);
        this.assertTrue(predicate, 4);
    }

    public static class EqualsTestObject {
        private final boolean b;

        public EqualsTestObject(boolean b) {
            this.b = b;
        }

        public boolean equals(Object obj) {
            return this.b;
        }
    }
}

