/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.BoundedIterator;
import org.junit.Test;

public class BoundedIteratorTest<E>
extends AbstractIteratorTest<E> {
    private final String[] testArray = new String[]{"a", "b", "c", "d", "e", "f", "g"};
    private List<E> testList;

    public BoundedIteratorTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.testList = Arrays.asList((Object[])this.testArray);
    }

    @Override
    public Iterator<E> makeEmptyIterator() {
        return new BoundedIterator(Collections.emptyList().iterator(), 0L, 10L);
    }

    @Override
    public Iterator<E> makeObject() {
        return new BoundedIterator(new ArrayList<E>(this.testList).iterator(), 1L, (long)(this.testList.size() - 1));
    }

    @Test
    public void testBounded() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 2L, 4L);
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"c", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"d", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"e", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"f", iter.next());
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testSameAsDecorated() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 0L, (long)this.testList.size());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"a", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"b", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"c", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"d", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"e", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"f", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"g", iter.next());
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyBounded() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 3L, 0L);
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeOffset() {
        try {
            new BoundedIterator(this.testList.iterator(), -1L, 4L);
            BoundedIteratorTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNegativeMax() {
        try {
            new BoundedIterator(this.testList.iterator(), 3L, -1L);
            BoundedIteratorTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOffsetGreaterThanSize() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 10L, 4L);
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxGreaterThanSize() {
        BoundedIterator iter = new BoundedIterator(this.testList.iterator(), 1L, 10L);
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"b", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"c", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"d", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"e", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"f", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"g", iter.next());
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveWithoutCallingNext() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        try {
            iter.remove();
            BoundedIteratorTest.fail((String)"Expected IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveCalledTwice() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"b", iter.next());
        iter.remove();
        try {
            iter.remove();
            BoundedIteratorTest.fail((String)"Expected IllegalStateException.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveFirst() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"b", iter.next());
        iter.remove();
        BoundedIteratorTest.assertFalse((boolean)testListCopy.contains("b"));
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"c", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"d", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"e", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"f", iter.next());
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveMiddle() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"b", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"c", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"d", iter.next());
        iter.remove();
        BoundedIteratorTest.assertFalse((boolean)testListCopy.contains("d"));
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"e", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"f", iter.next());
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveLast() {
        ArrayList<E> testListCopy = new ArrayList<E>(this.testList);
        BoundedIterator iter = new BoundedIterator(testListCopy.iterator(), 1L, 5L);
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"b", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"c", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"d", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"e", iter.next());
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"f", iter.next());
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        iter.remove();
        BoundedIteratorTest.assertFalse((boolean)testListCopy.contains("f"));
        BoundedIteratorTest.assertFalse((boolean)iter.hasNext());
        try {
            iter.next();
            BoundedIteratorTest.fail((String)"Expected NoSuchElementException.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveUnsupported() {
        AbstractIteratorDecorator mockIterator = new AbstractIteratorDecorator<E>(this.testList.iterator()){

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        BoundedIterator iter = new BoundedIterator((Iterator)mockIterator, 1L, 5L);
        BoundedIteratorTest.assertTrue((boolean)iter.hasNext());
        BoundedIteratorTest.assertEquals((Object)"b", iter.next());
        try {
            iter.remove();
            BoundedIteratorTest.fail((String)"Expected UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

