/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ObjectArrayIterator;

public class ObjectArrayIteratorTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three"};

    public ObjectArrayIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public ObjectArrayIterator<E> makeEmptyIterator() {
        return new ObjectArrayIterator(new Object[0]);
    }

    @Override
    public ObjectArrayIterator<E> makeObject() {
        return new ObjectArrayIterator((Object[])this.testArray);
    }

    public ObjectArrayIterator<E> makeArrayIterator() {
        return new ObjectArrayIterator(new Object[0]);
    }

    public ObjectArrayIterator<E> makeArrayIterator(E[] array) {
        return new ObjectArrayIterator((Object[])array);
    }

    public ObjectArrayIterator<E> makeArrayIterator(E[] array, int index) {
        return new ObjectArrayIterator((Object[])array, index);
    }

    public ObjectArrayIterator<E> makeArrayIterator(E[] array, int start, int end) {
        return new ObjectArrayIterator((Object[])array, start, end);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    public void testIterator() {
        ObjectArrayIterator<E> iter = this.makeObject();
        for (String testValue : this.testArray) {
            Object iterValue = iter.next();
            ObjectArrayIteratorTest.assertEquals((String)"Iteration value is correct", (Object)testValue, iterValue);
        }
        ObjectArrayIteratorTest.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            ObjectArrayIteratorTest.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testNullArray() {
        try {
            this.makeArrayIterator(null);
            ObjectArrayIteratorTest.fail((String)"Constructor should throw a NullPointerException when constructed with a null array");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testReset() {
        ObjectArrayIterator<Object> it = this.makeArrayIterator((Object[])this.testArray);
        it.next();
        it.reset();
        ObjectArrayIteratorTest.assertEquals((Object)"One", (Object)it.next());
    }
}

