/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractListIteratorTest;
import org.apache.commons.collections4.iterators.ReverseListIterator;

public class ReverseListIteratorTest<E>
extends AbstractListIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three", "Four"};

    public ReverseListIteratorTest(String testName) {
        super(testName);
    }

    @Override
    public ListIterator<E> makeEmptyIterator() {
        return new ReverseListIterator(new ArrayList());
    }

    @Override
    public ReverseListIterator<E> makeObject() {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
        return new ReverseListIterator(list);
    }

    @Override
    public void testEmptyListIteratorIsIndeedEmpty() {
        Iterator it = this.makeEmptyIterator();
        ReverseListIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        ReverseListIteratorTest.assertEquals((int)-1, (int)it.nextIndex());
        ReverseListIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        ReverseListIteratorTest.assertEquals((int)0, (int)it.previousIndex());
        try {
            it.next();
            ReverseListIteratorTest.fail((String)"NoSuchElementException must be thrown from empty ListIterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            it.previous();
            ReverseListIteratorTest.fail((String)"NoSuchElementException must be thrown from empty ListIterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public void testWalkForwardAndBack() {
        ArrayList list = new ArrayList();
        ReverseListIterator<E> it = this.makeObject();
        while (it.hasNext()) {
            list.add(it.next());
        }
        ReverseListIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
        for (int i = list.size() - 1; i >= 0; --i) {
            ReverseListIteratorTest.assertEquals((String)("" + i), (int)(list.size() - i - 2), (int)it.nextIndex());
            ReverseListIteratorTest.assertEquals((int)(list.size() - i - 1), (int)it.previousIndex());
            Object obj = list.get(i);
            ReverseListIteratorTest.assertEquals(obj, it.previous());
        }
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ReverseListIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        try {
            it.previous();
            ReverseListIteratorTest.fail((String)"NoSuchElementException must be thrown from previous at start of ListIterator");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testReverse() {
        ReverseListIterator<E> it = this.makeObject();
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ReverseListIteratorTest.assertEquals((int)3, (int)it.nextIndex());
        ReverseListIteratorTest.assertEquals((boolean)false, (boolean)it.hasPrevious());
        ReverseListIteratorTest.assertEquals((int)4, (int)it.previousIndex());
        ReverseListIteratorTest.assertEquals((Object)"Four", it.next());
        ReverseListIteratorTest.assertEquals((int)2, (int)it.nextIndex());
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ReverseListIteratorTest.assertEquals((int)3, (int)it.previousIndex());
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
        ReverseListIteratorTest.assertEquals((Object)"Three", it.next());
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ReverseListIteratorTest.assertEquals((int)1, (int)it.nextIndex());
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
        ReverseListIteratorTest.assertEquals((int)2, (int)it.previousIndex());
        ReverseListIteratorTest.assertEquals((Object)"Two", it.next());
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasNext());
        ReverseListIteratorTest.assertEquals((int)0, (int)it.nextIndex());
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
        ReverseListIteratorTest.assertEquals((int)1, (int)it.previousIndex());
        ReverseListIteratorTest.assertEquals((Object)"One", it.next());
        ReverseListIteratorTest.assertEquals((boolean)false, (boolean)it.hasNext());
        ReverseListIteratorTest.assertEquals((int)-1, (int)it.nextIndex());
        ReverseListIteratorTest.assertEquals((boolean)true, (boolean)it.hasPrevious());
        ReverseListIteratorTest.assertEquals((int)0, (int)it.previousIndex());
        ReverseListIteratorTest.assertEquals((Object)"One", it.previous());
        ReverseListIteratorTest.assertEquals((Object)"Two", it.previous());
        ReverseListIteratorTest.assertEquals((Object)"Three", it.previous());
        ReverseListIteratorTest.assertEquals((Object)"Four", it.previous());
    }

    public void testReset() {
        ReverseListIterator<E> it = this.makeObject();
        ReverseListIteratorTest.assertEquals((Object)"Four", (Object)it.next());
        it.reset();
        ReverseListIteratorTest.assertEquals((Object)"Four", (Object)it.next());
        it.next();
        it.next();
        it.reset();
        ReverseListIteratorTest.assertEquals((Object)"Four", (Object)it.next());
    }
}

