/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.Map;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.keyvalue.AbstractMapEntryTest;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.collections4.keyvalue.UnmodifiableMapEntry;
import org.junit.Assert;
import org.junit.Test;

public class UnmodifiableMapEntryTest<K, V>
extends AbstractMapEntryTest<K, V> {
    @Override
    public Map.Entry<K, V> makeMapEntry() {
        return new UnmodifiableMapEntry(null, null);
    }

    @Override
    public Map.Entry<K, V> makeMapEntry(K key, V value) {
        return new UnmodifiableMapEntry(key, value);
    }

    @Override
    @Test
    public void testConstructors() {
        UnmodifiableMapEntry entry = new UnmodifiableMapEntry((Object)"name", (Object)"duke");
        Assert.assertSame((Object)"name", entry.getKey());
        Assert.assertSame((Object)"duke", entry.getValue());
        DefaultKeyValue pair = new DefaultKeyValue((Object)"name", (Object)"duke");
        entry = new UnmodifiableMapEntry((KeyValue)pair);
        Assert.assertSame((Object)"name", entry.getKey());
        Assert.assertSame((Object)"duke", entry.getValue());
        UnmodifiableMapEntry entry2 = new UnmodifiableMapEntry((Map.Entry)entry);
        Assert.assertSame((Object)"name", entry2.getKey());
        Assert.assertSame((Object)"duke", entry2.getValue());
        Assert.assertTrue((boolean)(entry instanceof Unmodifiable));
    }

    @Override
    public void testAccessorsAndMutators() {
        Map.Entry<String, String> entry = this.makeMapEntry("name", "duke");
        Assert.assertSame((Object)"name", (Object)entry.getKey());
        Assert.assertSame((Object)"duke", (Object)entry.getValue());
        entry = this.makeMapEntry(null, null);
        Assert.assertSame(null, (Object)entry.getKey());
        Assert.assertSame(null, (Object)entry.getValue());
    }

    @Override
    @Test
    public void testSelfReferenceHandling() {
    }

    @Test
    public void testUnmodifiable() {
        Map.Entry<K, Object> entry = this.makeMapEntry();
        try {
            entry.setValue(null);
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

