/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.PredicatedMap;

public class PredicatedMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    protected static final Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected static final Predicate<Object> testPredicate = new Predicate<Object>(){

        public boolean evaluate(Object o) {
            return o instanceof String;
        }
    };

    public PredicatedMapTest(String testName) {
        super(testName);
    }

    protected IterableMap<K, V> decorateMap(Map<K, V> map, Predicate<? super K> keyPredicate, Predicate<? super V> valuePredicate) {
        return PredicatedMap.predicatedMap(map, keyPredicate, valuePredicate);
    }

    @Override
    public IterableMap<K, V> makeObject() {
        return this.decorateMap(new HashMap(), truePredicate, truePredicate);
    }

    public IterableMap<K, V> makeTestMap() {
        return this.decorateMap(new HashMap(), testPredicate, testPredicate);
    }

    public void testEntrySet() {
        IterableMap<String, String> map = this.makeTestMap();
        PredicatedMapTest.assertTrue((String)"returned entryset should not be null", (map.entrySet() != null ? 1 : 0) != 0);
        map = this.decorateMap(new HashMap(), null, null);
        map.put("oneKey", "oneValue");
        PredicatedMapTest.assertTrue((String)"returned entryset should contain one entry", (map.entrySet().size() == 1 ? 1 : 0) != 0);
        map = this.decorateMap((Map<K, V>)map, null, null);
    }

    public void testPut() {
        Map.Entry entry2;
        IterableMap<Object, Object> map = this.makeTestMap();
        try {
            map.put("Hi", 3);
            PredicatedMapTest.fail((String)"Illegal value should raise IllegalArgument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            map.put(3, "Hi");
            PredicatedMapTest.fail((String)"Illegal key should raise IllegalArgument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedMapTest.assertTrue((!map.containsKey(3) ? 1 : 0) != 0);
        PredicatedMapTest.assertTrue((!map.containsValue(3) ? 1 : 0) != 0);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("A", "a");
        map2.put("B", "b");
        map2.put("C", "c");
        map2.put("c", 3);
        try {
            map.putAll(map2);
            PredicatedMapTest.fail((String)"Illegal value should raise IllegalArgument");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        map.put("E", "e");
        Iterator iterator = map.entrySet().iterator();
        try {
            entry2 = iterator.next();
            entry2.setValue(3);
            PredicatedMapTest.fail((String)"Illegal value should raise IllegalArgument");
        }
        catch (IllegalArgumentException entry2) {
            // empty catch block
        }
        map.put("F", "f");
        iterator = map.entrySet().iterator();
        entry2 = iterator.next();
        entry2.setValue("x");
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

