/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.AbstractMultiValuedMapTest;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class ArrayListValuedHashMapTest<K, V>
extends AbstractMultiValuedMapTest<K, V> {
    public ArrayListValuedHashMapTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(ArrayListValuedHashMapTest.class);
    }

    @Override
    public ListValuedMap<K, V> makeObject() {
        return new ArrayListValuedHashMap();
    }

    public void testListValuedMapAdd() {
        ListValuedMap<K, V> listMap = this.makeObject();
        ArrayListValuedHashMapTest.assertTrue((boolean)(listMap.get((Object)"whatever") instanceof List));
        List list = listMap.get((Object)"A");
        list.add("a1");
        ArrayListValuedHashMapTest.assertEquals((int)1, (int)listMap.size());
        ArrayListValuedHashMapTest.assertTrue((boolean)listMap.containsKey((Object)"A"));
    }

    public void testListValuedMapAddViaListIterator() {
        ListValuedMap<K, V> listMap = this.makeObject();
        ListIterator<String> listIt = listMap.get((Object)"B").listIterator();
        ArrayListValuedHashMapTest.assertFalse((boolean)listIt.hasNext());
        listIt.add("b1");
        listIt.add("b2");
        listIt.add("b3");
        ArrayListValuedHashMapTest.assertEquals((int)3, (int)listMap.size());
        ArrayListValuedHashMapTest.assertTrue((boolean)listMap.containsKey((Object)"B"));
        ArrayListValuedHashMapTest.assertFalse((boolean)listIt.hasNext());
    }

    public void testListValuedMapRemove() {
        ListValuedMap<K, V> listMap = this.makeObject();
        List list = listMap.get((Object)"A");
        list.add("a1");
        list.add("a2");
        list.add("a3");
        ArrayListValuedHashMapTest.assertEquals((int)3, (int)listMap.size());
        ArrayListValuedHashMapTest.assertEquals((Object)"a1", list.remove(0));
        ArrayListValuedHashMapTest.assertEquals((int)2, (int)listMap.size());
        ArrayListValuedHashMapTest.assertEquals((Object)"a2", list.remove(0));
        ArrayListValuedHashMapTest.assertEquals((int)1, (int)listMap.size());
        ArrayListValuedHashMapTest.assertEquals((Object)"a3", list.remove(0));
        ArrayListValuedHashMapTest.assertEquals((int)0, (int)listMap.size());
        ArrayListValuedHashMapTest.assertFalse((boolean)listMap.containsKey((Object)"A"));
    }

    public void testListValuedMapRemoveViaListIterator() {
        ListValuedMap<K, V> listMap = this.makeObject();
        ListIterator<String> listIt = listMap.get((Object)"B").listIterator();
        listIt.add("b1");
        listIt.add("b2");
        ArrayListValuedHashMapTest.assertEquals((int)2, (int)listMap.size());
        ArrayListValuedHashMapTest.assertTrue((boolean)listMap.containsKey((Object)"B"));
        listIt = listMap.get((Object)"B").listIterator();
        while (listIt.hasNext()) {
            listIt.next();
            listIt.remove();
        }
        ArrayListValuedHashMapTest.assertFalse((boolean)listMap.containsKey((Object)"B"));
        listIt.add("b1");
        listIt.add("b2");
        ArrayListValuedHashMapTest.assertTrue((boolean)listMap.containsKey((Object)"B"));
        ArrayListValuedHashMapTest.assertEquals((int)2, (int)listMap.get((Object)"B").size());
    }

    public void testEqualsHashCodeContract() {
        ListValuedMap<K, V> map1 = this.makeObject();
        ListValuedMap<K, V> map2 = this.makeObject();
        map1.put((Object)"a", (Object)"a1");
        map1.put((Object)"a", (Object)"a2");
        map2.put((Object)"a", (Object)"a1");
        map2.put((Object)"a", (Object)"a2");
        ArrayListValuedHashMapTest.assertEquals(map1, map2);
        ArrayListValuedHashMapTest.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map2.put((Object)"a", (Object)"a2");
        ArrayListValuedHashMapTest.assertNotSame(map1, map2);
        ArrayListValuedHashMapTest.assertNotSame((Object)map1.hashCode(), (Object)map2.hashCode());
    }

    public void testListValuedMapEqualsHashCodeContract() {
        ListValuedMap<K, V> map1 = this.makeObject();
        ListValuedMap<K, V> map2 = this.makeObject();
        map1.put((Object)"a", (Object)"a1");
        map1.put((Object)"a", (Object)"a2");
        map2.put((Object)"a", (Object)"a1");
        map2.put((Object)"a", (Object)"a2");
        ArrayListValuedHashMapTest.assertEquals(map1, map2);
        ArrayListValuedHashMapTest.assertEquals((int)map1.hashCode(), (int)map2.hashCode());
        map1.put((Object)"b", (Object)"b1");
        map1.put((Object)"b", (Object)"b2");
        map2.put((Object)"b", (Object)"b2");
        map2.put((Object)"b", (Object)"b1");
        ArrayListValuedHashMapTest.assertNotSame(map1, map2);
        ArrayListValuedHashMapTest.assertNotSame((Object)map1.hashCode(), (Object)map2.hashCode());
    }
}

