/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.collections4.collection.AbstractCollectionTest;

public abstract class AbstractQueueTest<E>
extends AbstractCollectionTest<E> {
    public AbstractQueueTest(String testName) {
        super(testName);
    }

    public boolean isSetSupported() {
        return true;
    }

    @Override
    public void verify() {
        super.verify();
        Iterator iterator1 = this.getCollection().iterator();
        for (Object e : this.getConfirmed()) {
            AbstractQueueTest.assertTrue((boolean)iterator1.hasNext());
            Object o1 = iterator1.next();
            Object o2 = e;
            AbstractQueueTest.assertEquals(o1, o2);
        }
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public abstract Queue<E> makeObject();

    @Override
    public Queue<E> makeFullCollection() {
        Collection queue = this.makeObject();
        queue.addAll(Arrays.asList(this.getFullElements()));
        return queue;
    }

    @Override
    public Queue<E> getCollection() {
        return (Queue)super.getCollection();
    }

    public void testQueueOffer() {
        E[] elements;
        if (!this.isAddSupported()) {
            return;
        }
        for (Object element : elements = this.getFullElements()) {
            this.resetEmpty();
            boolean r = this.getCollection().offer(element);
            this.getConfirmed().add(element);
            this.verify();
            AbstractQueueTest.assertTrue((String)"Empty queue changed after add", (boolean)r);
            AbstractQueueTest.assertEquals((String)"Queue size is 1 after first add", (int)1, (int)this.getCollection().size());
        }
        this.resetEmpty();
        int size = 0;
        for (Object element : elements) {
            boolean r = this.getCollection().offer(element);
            this.getConfirmed().add(element);
            this.verify();
            if (r) {
                ++size;
            }
            AbstractQueueTest.assertEquals((String)"Queue size should grow after add", (int)size, (int)this.getCollection().size());
            AbstractQueueTest.assertTrue((String)"Queue should contain added element", (boolean)this.getCollection().contains(element));
        }
    }

    public void testQueueElement() {
        this.resetEmpty();
        try {
            this.getCollection().element();
            AbstractQueueTest.fail((String)"Queue.element should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.resetFull();
        AbstractQueueTest.assertTrue((boolean)this.getConfirmed().contains(this.getCollection().element()));
        if (!this.isRemoveSupported()) {
            return;
        }
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            Object element = this.getCollection().element();
            if (!this.isNullSupported()) {
                AbstractQueueTest.assertNotNull(element);
            }
            AbstractQueueTest.assertTrue((boolean)this.getConfirmed().contains(element));
            this.getCollection().remove(element);
            this.getConfirmed().remove(element);
            this.verify();
        }
        try {
            this.getCollection().element();
            AbstractQueueTest.fail((String)"Queue.element should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testQueuePeek() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Object element = this.getCollection().peek();
        AbstractQueueTest.assertNull(element);
        this.resetFull();
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            element = this.getCollection().peek();
            if (!this.isNullSupported()) {
                AbstractQueueTest.assertNotNull(element);
            }
            AbstractQueueTest.assertTrue((boolean)this.getConfirmed().contains(element));
            this.getCollection().remove(element);
            this.getConfirmed().remove(element);
            this.verify();
        }
        element = this.getCollection().peek();
        AbstractQueueTest.assertNull(element);
    }

    public void testQueueRemove() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        try {
            this.getCollection().remove();
            AbstractQueueTest.fail((String)"Queue.remove should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.resetFull();
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            Object element = this.getCollection().remove();
            boolean success = this.getConfirmed().remove(element);
            AbstractQueueTest.assertTrue((String)"remove should return correct element", (boolean)success);
            this.verify();
        }
        try {
            this.getCollection().element();
            AbstractQueueTest.fail((String)"Queue.remove should throw NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testQueuePoll() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Object element = this.getCollection().poll();
        AbstractQueueTest.assertNull(element);
        this.resetFull();
        int max = this.getFullElements().length;
        for (int i = 0; i < max; ++i) {
            element = this.getCollection().poll();
            boolean success = this.getConfirmed().remove(element);
            AbstractQueueTest.assertTrue((String)"poll should return correct element", (boolean)success);
            this.verify();
        }
        element = this.getCollection().poll();
        AbstractQueueTest.assertNull(element);
    }

    public void testEmptyQueueSerialization() throws IOException, ClassNotFoundException {
        Collection queue = this.makeObject();
        if (!(queue instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] objekt = this.writeExternalFormToBytes((Serializable)((Object)queue));
        Queue queue2 = (Queue)this.readExternalFormFromBytes(objekt);
        AbstractQueueTest.assertEquals((String)"Both queues are empty", (int)0, (int)queue.size());
        AbstractQueueTest.assertEquals((String)"Both queues are empty", (int)0, (int)queue2.size());
    }

    public void testFullQueueSerialization() throws IOException, ClassNotFoundException {
        Collection queue = this.makeFullCollection();
        int size = this.getFullElements().length;
        if (!(queue instanceof Serializable) || !this.isTestSerialization()) {
            return;
        }
        byte[] objekt = this.writeExternalFormToBytes((Serializable)((Object)queue));
        Queue queue2 = (Queue)this.readExternalFormFromBytes(objekt);
        AbstractQueueTest.assertEquals((String)"Both queues are same size", (int)size, (int)queue.size());
        AbstractQueueTest.assertEquals((String)"Both queues are same size", (int)size, (int)queue2.size());
    }

    public void testEmptyQueueCompatibility() throws IOException, ClassNotFoundException {
        Collection queue = this.makeObject();
        if (queue instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Queue queue2 = (Queue)this.readExternalFormFromDisk(this.getCanonicalEmptyCollectionName(queue));
            AbstractQueueTest.assertEquals((String)"Queue is empty", (int)0, (int)queue2.size());
        }
    }

    public void testFullQueueCompatibility() throws IOException, ClassNotFoundException {
        Collection queue = this.makeFullCollection();
        if (queue instanceof Serializable && !this.skipSerializedCanonicalTests() && this.isTestSerialization()) {
            Queue queue2 = (Queue)this.readExternalFormFromDisk(this.getCanonicalFullCollectionName(queue));
            AbstractQueueTest.assertEquals((String)"Queues are not the right size", (int)queue.size(), (int)queue2.size());
        }
    }
}

