/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.Assert;
import org.junit.Test;

public class DiffResultTest {
    private static final SimpleClass SIMPLE_FALSE = new SimpleClass(false);
    private static final SimpleClass SIMPLE_TRUE = new SimpleClass(true);
    private static final ToStringStyle SHORT_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;

    @Test(expected=UnsupportedOperationException.class)
    public void testListIsNonModifiable() {
        SimpleClass lhs = new SimpleClass(true);
        SimpleClass rhs = new SimpleClass(false);
        List diffs = lhs.diff(rhs).getDiffs();
        DiffResult list = new DiffResult((Object)lhs, (Object)rhs, diffs, SHORT_STYLE);
        Assert.assertEquals((Object)diffs, (Object)list.getDiffs());
        Assert.assertEquals((long)1L, (long)list.getNumberOfDiffs());
        list.getDiffs().remove(0);
    }

    @Test
    public void testIterator() {
        SimpleClass lhs = new SimpleClass(true);
        SimpleClass rhs = new SimpleClass(false);
        List diffs = lhs.diff(rhs).getDiffs();
        Iterator expectedIterator = diffs.iterator();
        DiffResult list = new DiffResult((Object)lhs, (Object)rhs, diffs, SHORT_STYLE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)expectedIterator.hasNext());
            Assert.assertEquals(expectedIterator.next(), iterator.next());
        }
    }

    @Test
    public void testToStringOutput() {
        DiffResult list = new DiffBuilder((Object)new EmptyClass(), (Object)new EmptyClass(), ToStringStyle.SHORT_PREFIX_STYLE).append("test", false, true).build();
        Assert.assertEquals((Object)"DiffResultTest.EmptyClass[test=false] differs from DiffResultTest.EmptyClass[test=true]", (Object)list.toString());
    }

    @Test
    public void testToStringSpecifyStyleOutput() {
        DiffResult list = SIMPLE_FALSE.diff(SIMPLE_TRUE);
        Assert.assertTrue((boolean)list.getToStringStyle().equals(SHORT_STYLE));
        String lhsString = new ToStringBuilder((Object)SIMPLE_FALSE, ToStringStyle.MULTI_LINE_STYLE).append(SimpleClass.getFieldName(), SIMPLE_FALSE.booleanField).build();
        String rhsString = new ToStringBuilder((Object)SIMPLE_TRUE, ToStringStyle.MULTI_LINE_STYLE).append(SimpleClass.getFieldName(), SIMPLE_TRUE.booleanField).build();
        String expectedOutput = String.format("%s differs from %s", lhsString, rhsString);
        Assert.assertEquals((Object)expectedOutput, (Object)list.toString(ToStringStyle.MULTI_LINE_STYLE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullLhs() {
        new DiffResult(null, (Object)SIMPLE_FALSE, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), SHORT_STYLE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullRhs() {
        new DiffResult((Object)SIMPLE_TRUE, null, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), SHORT_STYLE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullList() {
        new DiffResult((Object)SIMPLE_TRUE, (Object)SIMPLE_FALSE, null, SHORT_STYLE);
    }

    @Test
    public void testNullStyle() {
        DiffResult diffResult = new DiffResult((Object)SIMPLE_TRUE, (Object)SIMPLE_FALSE, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), null);
        Assert.assertEquals((Object)ToStringStyle.DEFAULT_STYLE, (Object)diffResult.getToStringStyle());
    }

    @Test
    public void testNoDifferencesString() {
        DiffResult diffResult = new DiffBuilder((Object)SIMPLE_TRUE, (Object)SIMPLE_TRUE, SHORT_STYLE).build();
        Assert.assertEquals((Object)"", (Object)diffResult.toString());
    }

    private static class EmptyClass {
        private EmptyClass() {
        }
    }

    private static class SimpleClass
    implements Diffable<SimpleClass> {
        private final boolean booleanField;

        public SimpleClass(boolean booleanField) {
            this.booleanField = booleanField;
        }

        public static String getFieldName() {
            return "booleanField";
        }

        public DiffResult diff(SimpleClass obj) {
            return new DiffBuilder((Object)this, (Object)obj, ToStringStyle.SHORT_PREFIX_STYLE).append(SimpleClass.getFieldName(), this.booleanField, obj.booleanField).build();
        }
    }
}

