/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerTest;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AtomicSafeInitializerTest
extends AbstractConcurrentInitializerTest {
    private AtomicSafeInitializerTestImpl initializer;

    @Before
    public void setUp() throws Exception {
        this.initializer = new AtomicSafeInitializerTestImpl();
    }

    @Override
    protected ConcurrentInitializer<Object> createInitializer() {
        return this.initializer;
    }

    @Test
    public void testNumberOfInitializeInvocations() throws ConcurrentException, InterruptedException {
        this.testGetConcurrent();
        Assert.assertEquals((String)"Wrong number of invocations", (long)1L, (long)this.initializer.initCounter.get());
    }

    private static class AtomicSafeInitializerTestImpl
    extends AtomicSafeInitializer<Object> {
        final AtomicInteger initCounter = new AtomicInteger();

        private AtomicSafeInitializerTestImpl() {
        }

        protected Object initialize() throws ConcurrentException {
            this.initCounter.incrementAndGet();
            return new Object();
        }
    }
}

