/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.junit.Assert;
import org.junit.Test;

public class MutableTripleTest {
    @Test
    public void testBasic() throws Exception {
        MutableTriple triple = new MutableTriple((Object)0, (Object)"foo", (Object)Boolean.FALSE);
        Assert.assertEquals((long)0L, (long)((Integer)triple.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)triple.getMiddle());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)triple.getRight());
        MutableTriple triple2 = new MutableTriple(null, (Object)"bar", (Object)"hello");
        Assert.assertNull((Object)triple2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)triple2.getMiddle());
        Assert.assertEquals((Object)"hello", (Object)triple2.getRight());
    }

    @Test
    public void testDefault() throws Exception {
        MutableTriple triple = new MutableTriple();
        Assert.assertNull((Object)triple.getLeft());
        Assert.assertNull((Object)triple.getMiddle());
        Assert.assertNull((Object)triple.getRight());
    }

    @Test
    public void testMutate() throws Exception {
        MutableTriple triple = new MutableTriple((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        triple.setLeft((Object)42);
        triple.setMiddle((Object)"bar");
        triple.setRight((Object)Boolean.FALSE);
        Assert.assertEquals((long)42L, (long)((Integer)triple.getLeft()).intValue());
        Assert.assertEquals((Object)"bar", (Object)triple.getMiddle());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)triple.getRight());
    }

    @Test
    public void testTripleOf() throws Exception {
        MutableTriple triple = MutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        Assert.assertEquals((long)0L, (long)((Integer)triple.getLeft()).intValue());
        Assert.assertEquals((Object)"foo", (Object)triple.getMiddle());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)triple.getRight());
        MutableTriple triple2 = MutableTriple.of(null, (Object)"bar", (Object)"hello");
        Assert.assertNull((Object)triple2.getLeft());
        Assert.assertEquals((Object)"bar", (Object)triple2.getMiddle());
        Assert.assertEquals((Object)"hello", (Object)triple2.getRight());
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)MutableTriple.of(null, (Object)"foo", (Object)"baz"), (Object)MutableTriple.of(null, (Object)"foo", (Object)"baz"));
        Assert.assertFalse((boolean)MutableTriple.of((Object)"foo", (Object)0, (Object)Boolean.TRUE).equals((Object)MutableTriple.of((Object)"foo", null, (Object)Boolean.TRUE)));
        Assert.assertFalse((boolean)MutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz").equals((Object)MutableTriple.of((Object)"xyz", (Object)"bar", (Object)"baz")));
        Assert.assertFalse((boolean)MutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz").equals((Object)MutableTriple.of((Object)"foo", (Object)"bar", (Object)"blo")));
        MutableTriple p = MutableTriple.of((Object)"foo", (Object)"bar", (Object)"baz");
        Assert.assertTrue((boolean)p.equals((Object)p));
        Assert.assertFalse((boolean)p.equals(new Object()));
    }

    @Test
    public void testHashCode() throws Exception {
        Assert.assertEquals((long)MutableTriple.of(null, (Object)"foo", (Object)"baz").hashCode(), (long)MutableTriple.of(null, (Object)"foo", (Object)"baz").hashCode());
    }

    @Test
    public void testToString() throws Exception {
        Assert.assertEquals((Object)"(null,null,null)", (Object)MutableTriple.of(null, null, null).toString());
        Assert.assertEquals((Object)"(null,two,null)", (Object)MutableTriple.of(null, (Object)"two", null).toString());
        Assert.assertEquals((Object)"(one,null,null)", (Object)MutableTriple.of((Object)"one", null, null).toString());
        Assert.assertEquals((Object)"(one,two,null)", (Object)MutableTriple.of((Object)"one", (Object)"two", null).toString());
        Assert.assertEquals((Object)"(null,two,three)", (Object)MutableTriple.of(null, (Object)"two", (Object)"three").toString());
        Assert.assertEquals((Object)"(one,null,three)", (Object)MutableTriple.of((Object)"one", null, (Object)"three").toString());
        Assert.assertEquals((Object)"(one,two,three)", (Object)MutableTriple.of((Object)"one", (Object)"two", (Object)"three").toString());
    }

    @Test
    public void testSerialization() throws Exception {
        MutableTriple origTriple = MutableTriple.of((Object)0, (Object)"foo", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origTriple);
        MutableTriple deserializedTriple = (MutableTriple)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assert.assertEquals((Object)origTriple, (Object)deserializedTriple);
        Assert.assertEquals((long)origTriple.hashCode(), (long)deserializedTriple.hashCode());
    }
}

