/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharEncoding;
import org.junit.Assert;
import org.junit.Test;

public class CharEncodingTest {
    private void assertSupportedEncoding(String name) {
        Assert.assertTrue((String)("Encoding should be supported: " + name), (boolean)CharEncoding.isSupported((String)name));
    }

    @Test
    public void testConstructor() {
        new CharEncoding();
    }

    @Test
    public void testMustBeSupportedJava1_3_1_and_above() {
        this.assertSupportedEncoding("ISO-8859-1");
        this.assertSupportedEncoding("US-ASCII");
        this.assertSupportedEncoding("UTF-16");
        this.assertSupportedEncoding("UTF-16BE");
        this.assertSupportedEncoding("UTF-16LE");
        this.assertSupportedEncoding("UTF-8");
    }

    @Test
    public void testSupported() {
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"UTF8"));
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"UTF-8"));
        Assert.assertTrue((boolean)CharEncoding.isSupported((String)"ASCII"));
    }

    @Test
    public void testNotSupported() {
        Assert.assertFalse((boolean)CharEncoding.isSupported(null));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)""));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)" "));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"\t\r\n"));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"DOESNOTEXIST"));
        Assert.assertFalse((boolean)CharEncoding.isSupported((String)"this is not a valid encoding name"));
    }
}

