/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.CharSequenceUtils;
import org.junit.Assert;
import org.junit.Test;

public class CharSequenceUtilsTest {
    private static final TestData[] TEST_DATA = new TestData[]{new TestData("", true, -1, "", -1, -1, false), new TestData("", true, 0, "", 0, 1, false), new TestData("a", true, 0, "abc", 0, 0, true), new TestData("a", true, 0, "abc", 0, 1, true), new TestData("a", true, 0, null, 0, 0, NullPointerException.class), new TestData(null, true, 0, null, 0, 0, NullPointerException.class), new TestData(null, true, 0, "", 0, 0, NullPointerException.class), new TestData("Abc", true, 0, "abc", 0, 3, true), new TestData("Abc", false, 0, "abc", 0, 3, false), new TestData("Abc", true, 1, "abc", 1, 2, true), new TestData("Abc", false, 1, "abc", 1, 2, true), new TestData("Abcd", true, 1, "abcD", 1, 2, true), new TestData("Abcd", false, 1, "abcD", 1, 2, true)};

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new CharSequenceUtils());
        Constructor<?>[] cons = CharSequenceUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(CharSequenceUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(CharSequenceUtils.class.getModifiers()));
    }

    @Test
    public void testSubSequence() {
        Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence(null, (int)-1));
        Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence(null, (int)0));
        Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence(null, (int)1));
        Assert.assertEquals((Object)"", (Object)CharSequenceUtils.subSequence((CharSequence)"", (int)0));
        Assert.assertEquals((Object)"012", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)0));
        Assert.assertEquals((Object)"12", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)1));
        Assert.assertEquals((Object)"2", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)2));
        Assert.assertEquals((Object)"", (Object)CharSequenceUtils.subSequence((CharSequence)"012", (int)3));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceNegativeStart() {
        Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence((CharSequence)"", (int)-1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSubSequenceTooLong() {
        Assert.assertEquals(null, (Object)CharSequenceUtils.subSequence((CharSequence)"", (int)1));
    }

    @Test
    public void testRegionMatches() {
        for (final TestData data : TEST_DATA) {
            new RunTest(){

                @Override
                boolean invoke() {
                    return data.source.regionMatches(data.ignoreCase, data.toffset, data.other, data.ooffset, data.len);
                }
            }.run(data, "String");
            new RunTest(){

                @Override
                boolean invoke() {
                    return CharSequenceUtils.regionMatches((CharSequence)data.source, (boolean)data.ignoreCase, (int)data.toffset, (CharSequence)data.other, (int)data.ooffset, (int)data.len);
                }
            }.run(data, "CSString");
            new RunTest(){

                @Override
                boolean invoke() {
                    return CharSequenceUtils.regionMatches((CharSequence)new StringBuilder(data.source), (boolean)data.ignoreCase, (int)data.toffset, (CharSequence)data.other, (int)data.ooffset, (int)data.len);
                }
            }.run(data, "CSNonString");
        }
    }

    private static abstract class RunTest {
        private RunTest() {
        }

        abstract boolean invoke();

        void run(TestData data, String id) {
            if (data.throwable != null) {
                try {
                    this.invoke();
                    Assert.fail((String)(id + " Expected " + data.throwable));
                }
                catch (Exception e) {
                    if (!e.getClass().equals(data.throwable)) {
                        Assert.fail((String)(id + " Expected " + data.throwable + " got " + e.getClass()));
                    }
                }
            } else {
                boolean stringCheck = this.invoke();
                Assert.assertEquals((String)(id + " Failed test " + data), (Object)data.expected, (Object)stringCheck);
            }
        }
    }

    static class TestData {
        final String source;
        final boolean ignoreCase;
        final int toffset;
        final String other;
        final int ooffset;
        final int len;
        final boolean expected;
        final Class<?> throwable;

        TestData(String source, boolean ignoreCase, int toffset, String other, int ooffset, int len, boolean expected) {
            this.source = source;
            this.ignoreCase = ignoreCase;
            this.toffset = toffset;
            this.other = other;
            this.ooffset = ooffset;
            this.len = len;
            this.expected = expected;
            this.throwable = null;
        }

        TestData(String source, boolean ignoreCase, int toffset, String other, int ooffset, int len, Class<?> throwable) {
            this.source = source;
            this.ignoreCase = ignoreCase;
            this.toffset = toffset;
            this.other = other;
            this.ooffset = ooffset;
            this.len = len;
            this.expected = false;
            this.throwable = throwable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.source).append("[").append(this.toffset).append("]");
            sb.append(this.ignoreCase ? " caseblind " : " samecase ");
            sb.append(this.other).append("[").append(this.ooffset).append("]");
            sb.append(" ").append(this.len).append(" => ");
            if (this.throwable != null) {
                sb.append(this.throwable);
            } else {
                sb.append(this.expected);
            }
            return sb.toString();
        }
    }
}

