/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.ThreadUtils;
import org.junit.Assert;
import org.junit.Test;

public class ThreadUtilsTest {
    @Test(expected=IllegalArgumentException.class)
    public void testNullThreadName() throws InterruptedException {
        ThreadUtils.findThreadsByName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullThreadGroupName() throws InterruptedException {
        ThreadUtils.findThreadGroupsByName(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullThreadThreadGroupName1() throws InterruptedException {
        ThreadUtils.findThreadsByName(null, (String)"tgname");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullThreadThreadGroupName2() throws InterruptedException {
        ThreadUtils.findThreadsByName((String)"tname", (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullThreadThreadGroupName3() throws InterruptedException {
        ThreadUtils.findThreadsByName(null, (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullThreadThreadGroup1() throws InterruptedException {
        ThreadUtils.findThreadsByName((String)"tname", (ThreadGroup)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullThreadThreadGroup2() throws InterruptedException {
        ThreadUtils.findThreadById((long)1L, (ThreadGroup)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullThreadThreadGroup3() throws InterruptedException {
        ThreadUtils.findThreadsByName(null, (ThreadGroup)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidThreadId() throws InterruptedException {
        ThreadUtils.findThreadById((long)-5L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThreadGroupsByIdFail() throws InterruptedException {
        ThreadUtils.findThreadById((long)Thread.currentThread().getId(), (String)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThreadgroupsNullParent() throws InterruptedException {
        ThreadUtils.findThreadGroups(null, (boolean)true, (ThreadUtils.ThreadGroupPredicate)ThreadUtils.ALWAYS_TRUE_PREDICATE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThreadgroupsNullPredicate() throws InterruptedException {
        ThreadUtils.findThreadGroups(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testThreadsNullPredicate() throws InterruptedException {
        ThreadUtils.findThreads(null);
    }

    @Test
    public void testNoThread() throws InterruptedException {
        Assert.assertEquals((long)0L, (long)ThreadUtils.findThreadsByName((String)"some_thread_which_does_not_exist_18762ZucTT").size());
    }

    @Test
    public void testNoThreadGroup() throws InterruptedException {
        Assert.assertEquals((long)0L, (long)ThreadUtils.findThreadGroupsByName((String)"some_thread_group_which_does_not_exist_18762ZucTTII").size());
    }

    @Test
    public void testSystemThreadGroupExists() throws InterruptedException {
        ThreadGroup systemThreadGroup = ThreadUtils.getSystemThreadGroup();
        Assert.assertNotNull((Object)systemThreadGroup);
        Assert.assertNull((Object)systemThreadGroup.getParent());
        Assert.assertEquals((Object)"system", (Object)systemThreadGroup.getName());
    }

    @Test
    public void testAtLeastOneThreadExists() throws InterruptedException {
        Assert.assertTrue((ThreadUtils.getAllThreads().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAtLeastOneThreadGroupsExists() throws InterruptedException {
        Assert.assertTrue((ThreadUtils.getAllThreadGroups().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testThreadsSameName() throws InterruptedException {
        TestThread t1 = new TestThread("thread1_XXOOLL__");
        TestThread alsot1 = new TestThread("thread1_XXOOLL__");
        try {
            ((Thread)t1).start();
            ((Thread)alsot1).start();
            Assert.assertEquals((long)2L, (long)ThreadUtils.findThreadsByName((String)"thread1_XXOOLL__").size());
        }
        finally {
            t1.interrupt();
            alsot1.interrupt();
            t1.join();
            alsot1.join();
        }
    }

    @Test
    public void testThreads() throws InterruptedException {
        TestThread t1 = new TestThread("thread1_XXOOLL__");
        TestThread t2 = new TestThread("thread2_XXOOLL__");
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadsByName((String)"thread2_XXOOLL__").size());
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
        }
    }

    @Test
    public void testThreadsById() throws InterruptedException {
        TestThread t1 = new TestThread("thread1_XXOOLL__");
        TestThread t2 = new TestThread("thread2_XXOOLL__");
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assert.assertSame((Object)t1, (Object)ThreadUtils.findThreadById((long)t1.getId()));
            Assert.assertSame((Object)t2, (Object)ThreadUtils.findThreadById((long)t2.getId()));
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
        }
    }

    @Test
    public void testThreadsByIdWrongGroup() throws InterruptedException {
        TestThread t1 = new TestThread("thread1_XXOOLL__");
        ThreadGroup tg = new ThreadGroup("tg__HHEE22");
        try {
            ((Thread)t1).start();
            Assert.assertNull((Object)ThreadUtils.findThreadById((long)t1.getId(), (ThreadGroup)tg));
        }
        finally {
            t1.interrupt();
            t1.join();
            tg.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadGroups() throws InterruptedException {
        ThreadGroup threadGroup = new ThreadGroup("thread_group_DDZZ99__");
        TestThread t1 = new TestThread(threadGroup, "thread1_XXOOPP__");
        TestThread t2 = new TestThread(threadGroup, "thread2_XXOOPP__");
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__").size());
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__", (String)"thread_group_DDZZ99__").size());
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadsByName((String)"thread2_XXOOPP__", (String)"thread_group_DDZZ99__").size());
            Assert.assertEquals((long)0L, (long)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__", (String)"non_existent_thread_group_JJHHZZ__").size());
            Assert.assertEquals((long)0L, (long)ThreadUtils.findThreadsByName((String)"non_existent_thread_BBDDWW__", (String)"thread_group_DDZZ99__").size());
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadGroupsByName((String)"thread_group_DDZZ99__").size());
            Assert.assertEquals((long)0L, (long)ThreadUtils.findThreadGroupsByName((String)"non_existent_thread_group_JJHHZZ__").size());
            Assert.assertNotNull((Object)ThreadUtils.findThreadById((long)t1.getId(), (ThreadGroup)threadGroup));
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
            threadGroup.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadGroupsRef() throws InterruptedException {
        ThreadGroup threadGroup = new ThreadGroup("thread_group_DDZZ99__");
        ThreadGroup deadThreadGroup = new ThreadGroup("dead_thread_group_MMQQSS__");
        deadThreadGroup.destroy();
        TestThread t1 = new TestThread(threadGroup, "thread1_XXOOPP__");
        TestThread t2 = new TestThread(threadGroup, "thread2_XXOOPP__");
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__").size());
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__", (ThreadGroup)threadGroup).size());
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadsByName((String)"thread2_XXOOPP__", (ThreadGroup)threadGroup).size());
            Assert.assertEquals((long)0L, (long)ThreadUtils.findThreadsByName((String)"thread1_XXOOPP__", (ThreadGroup)deadThreadGroup).size());
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
            threadGroup.destroy();
            Assert.assertEquals((long)0L, (long)ThreadUtils.findThreadsByName((String)"thread2_XXOOPP__", (ThreadGroup)threadGroup).size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadGroupsById() throws InterruptedException {
        ThreadGroup threadGroup = new ThreadGroup("thread_group_DDZZ99__");
        TestThread t1 = new TestThread(threadGroup, "thread1_XXOOPP__");
        TestThread t2 = new TestThread(threadGroup, "thread2_XXOOPP__");
        long nonExistingId = t1.getId() + t2.getId();
        try {
            ((Thread)t1).start();
            ((Thread)t2).start();
            Assert.assertSame((Object)t1, (Object)ThreadUtils.findThreadById((long)t1.getId(), (String)"thread_group_DDZZ99__"));
            Assert.assertSame((Object)t2, (Object)ThreadUtils.findThreadById((long)t2.getId(), (String)"thread_group_DDZZ99__"));
            Assert.assertNull((Object)ThreadUtils.findThreadById((long)nonExistingId, (String)"non_existent_thread_group_JJHHZZ__"));
            Assert.assertNull((Object)ThreadUtils.findThreadById((long)nonExistingId, (String)"thread_group_DDZZ99__"));
        }
        finally {
            t1.interrupt();
            t2.interrupt();
            t1.join();
            t2.join();
            threadGroup.destroy();
        }
    }

    @Test
    public void testConstructor() throws InterruptedException {
        Assert.assertNotNull((Object)new ThreadUtils());
        Constructor<?>[] cons = ThreadUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(ThreadUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(ThreadUtils.class.getModifiers()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplexThreadGroups() throws Exception {
        ThreadGroup threadGroup1 = new ThreadGroup("thread_group_1__");
        ThreadGroup threadGroup2 = new ThreadGroup("thread_group_2__");
        ThreadGroup threadGroup3 = new ThreadGroup(threadGroup2, "thread_group_3__");
        ThreadGroup threadGroup4 = new ThreadGroup(threadGroup2, "thread_group_4__");
        ThreadGroup threadGroup5 = new ThreadGroup(threadGroup1, "thread_group_5__");
        ThreadGroup threadGroup6 = new ThreadGroup(threadGroup4, "thread_group_6__");
        ThreadGroup threadGroup7 = new ThreadGroup(threadGroup4, "thread_group_7__");
        ThreadGroup threadGroup7Doubled = new ThreadGroup(threadGroup4, "thread_group_7__");
        List<ThreadGroup> threadGroups = Arrays.asList(threadGroup1, threadGroup2, threadGroup3, threadGroup4, threadGroup5, threadGroup6, threadGroup7, threadGroup7Doubled);
        TestThread t1 = new TestThread("thread1_X__");
        TestThread t2 = new TestThread(threadGroup1, "thread2_X__");
        TestThread t3 = new TestThread(threadGroup2, "thread3_X__");
        TestThread t4 = new TestThread(threadGroup3, "thread4_X__");
        TestThread t5 = new TestThread(threadGroup4, "thread5_X__");
        TestThread t6 = new TestThread(threadGroup5, "thread6_X__");
        TestThread t7 = new TestThread(threadGroup6, "thread7_X__");
        TestThread t8 = new TestThread(threadGroup4, "thread8_X__");
        TestThread t9 = new TestThread(threadGroup6, "thread9_X__");
        TestThread t10 = new TestThread(threadGroup3, "thread10_X__");
        TestThread t11 = new TestThread(threadGroup7, "thread11_X__");
        TestThread t11Doubled = new TestThread(threadGroup7Doubled, "thread11_X__");
        List<Thread> threads = Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t11Doubled);
        try {
            for (Thread thread : threads) {
                thread.start();
            }
            Assert.assertTrue((ThreadUtils.getAllThreadGroups().size() >= 7 ? 1 : 0) != 0);
            Assert.assertTrue((ThreadUtils.getAllThreads().size() >= 11 ? 1 : 0) != 0);
            Assert.assertTrue((ThreadUtils.findThreads((ThreadUtils.ThreadPredicate)ThreadUtils.ALWAYS_TRUE_PREDICATE).size() >= 11 ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)ThreadUtils.findThreadsByName((String)t4.getName(), (String)threadGroup3.getName()).size());
            Assert.assertEquals((long)0L, (long)ThreadUtils.findThreadsByName((String)t4.getName(), (String)threadGroup2.getName()).size());
            Assert.assertEquals((long)2L, (long)ThreadUtils.findThreadsByName((String)t11.getName(), (String)threadGroup7.getName()).size());
        }
        finally {
            for (Thread thread : threads) {
                thread.interrupt();
                thread.join();
            }
            for (ThreadGroup threadGroup : threadGroups) {
                if (threadGroup.isDestroyed()) continue;
                threadGroup.destroy();
            }
        }
    }

    private static class TestThread
    extends Thread {
        private final CountDownLatch latch = new CountDownLatch(1);

        public TestThread(String name) {
            super(name);
        }

        public TestThread(ThreadGroup group, String name) {
            super(group, name);
        }

        @Override
        public synchronized void start() {
            super.start();
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.latch.countDown();
            try {
                TestThread testThread = this;
                synchronized (testThread) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

