/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.testbed.Ambig;
import org.apache.commons.lang3.reflect.testbed.Annotated;
import org.apache.commons.lang3.reflect.testbed.Foo;
import org.apache.commons.lang3.reflect.testbed.PrivatelyShadowedChild;
import org.apache.commons.lang3.reflect.testbed.PublicChild;
import org.apache.commons.lang3.reflect.testbed.PubliclyShadowedChild;
import org.apache.commons.lang3.reflect.testbed.StaticContainer;
import org.apache.commons.lang3.reflect.testbed.StaticContainerChild;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class FieldUtilsTest {
    static final Integer I0 = 0;
    static final Integer I1 = 1;
    static final Double D0 = 0.0;
    static final Double D1 = 1.0;
    @Annotated
    private PublicChild publicChild;
    private PubliclyShadowedChild publiclyShadowedChild;
    @Annotated
    private PrivatelyShadowedChild privatelyShadowedChild;
    private final Class<? super PublicChild> parentClass = PublicChild.class.getSuperclass();

    @Before
    public void setUp() {
        StaticContainer.reset();
        this.publicChild = new PublicChild();
        this.publiclyShadowedChild = new PubliclyShadowedChild();
        this.privatelyShadowedChild = new PrivatelyShadowedChild();
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new FieldUtils());
        Constructor<?>[] cons = FieldUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(FieldUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(FieldUtils.class.getModifiers()));
    }

    @Test
    public void testGetField() {
        Assert.assertEquals(Foo.class, FieldUtils.getField(PublicChild.class, (String)"VALUE").getDeclaringClass());
        Assert.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"s").getDeclaringClass());
        Assert.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"b"));
        Assert.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"i"));
        Assert.assertNull((Object)FieldUtils.getField(PublicChild.class, (String)"d"));
        Assert.assertEquals(Foo.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"VALUE").getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"s").getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"b").getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"i").getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"d").getDeclaringClass());
        Assert.assertEquals(Foo.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"VALUE").getDeclaringClass());
        Assert.assertEquals(this.parentClass, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"s").getDeclaringClass());
        Assert.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"b"));
        Assert.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"i"));
        Assert.assertNull((Object)FieldUtils.getField(PrivatelyShadowedChild.class, (String)"d"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldIllegalArgumentException1() {
        FieldUtils.getField(null, (String)"none");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldIllegalArgumentException2() {
        FieldUtils.getField(PublicChild.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldIllegalArgumentException3() {
        FieldUtils.getField(PublicChild.class, (String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldIllegalArgumentException4() {
        FieldUtils.getField(PublicChild.class, (String)" ");
    }

    @Test
    public void testGetFieldForceAccess() {
        Assert.assertEquals(PublicChild.class, FieldUtils.getField(PublicChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assert.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assert.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assert.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assert.assertEquals(this.parentClass, FieldUtils.getField(PublicChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assert.assertEquals(Foo.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getField(PubliclyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assert.assertEquals(Foo.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getField(PrivatelyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldForceAccessIllegalArgumentException1() {
        FieldUtils.getField(null, (String)"none", (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldForceAccessIllegalArgumentException2() {
        FieldUtils.getField(PublicChild.class, null, (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldForceAccessIllegalArgumentException3() {
        FieldUtils.getField(PublicChild.class, (String)"", (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldForceAccessIllegalArgumentException4() {
        FieldUtils.getField(PublicChild.class, (String)" ", (boolean)true);
    }

    @Test
    public void testGetAllFields() {
        Assert.assertArrayEquals((Object[])new Field[0], (Object[])FieldUtils.getAllFields(Object.class));
        Object[] fieldsNumber = Number.class.getDeclaredFields();
        Assert.assertArrayEquals((Object[])fieldsNumber, (Object[])FieldUtils.getAllFields(Number.class));
        Object[] fieldsInteger = Integer.class.getDeclaredFields();
        Assert.assertArrayEquals((Object[])ArrayUtils.addAll((Object[])fieldsInteger, (Object[])fieldsNumber), (Object[])FieldUtils.getAllFields(Integer.class));
        Assert.assertEquals((long)5L, (long)FieldUtils.getAllFields(PublicChild.class).length);
    }

    @Test
    public void testGetAllFieldsList() {
        Assert.assertEquals((long)0L, (long)FieldUtils.getAllFieldsList(Object.class).size());
        List<Field> fieldsNumber = Arrays.asList(Number.class.getDeclaredFields());
        Assert.assertEquals(fieldsNumber, (Object)FieldUtils.getAllFieldsList(Number.class));
        List<Field> fieldsInteger = Arrays.asList(Integer.class.getDeclaredFields());
        ArrayList<Field> allFieldsInteger = new ArrayList<Field>(fieldsInteger);
        allFieldsInteger.addAll(fieldsNumber);
        Assert.assertEquals(allFieldsInteger, (Object)FieldUtils.getAllFieldsList(Integer.class));
        Assert.assertEquals((long)5L, (long)FieldUtils.getAllFieldsList(PublicChild.class).size());
    }

    @Test
    public void testGetFieldsWithAnnotation() throws NoSuchFieldException {
        Assert.assertArrayEquals((Object[])new Field[0], (Object[])FieldUtils.getFieldsWithAnnotation(Object.class, Annotated.class));
        Object[] annotatedFields = new Field[]{FieldUtilsTest.class.getDeclaredField("publicChild"), FieldUtilsTest.class.getDeclaredField("privatelyShadowedChild")};
        Assert.assertArrayEquals((Object[])annotatedFields, (Object[])FieldUtils.getFieldsWithAnnotation(FieldUtilsTest.class, Annotated.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldsWithAnnotationIllegalArgumentException1() {
        FieldUtils.getFieldsWithAnnotation(FieldUtilsTest.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldsWithAnnotationIllegalArgumentException2() {
        FieldUtils.getFieldsWithAnnotation(null, Annotated.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldsWithAnnotationIllegalArgumentException3() {
        FieldUtils.getFieldsWithAnnotation(null, null);
    }

    @Test
    public void testGetFieldsListWithAnnotation() throws NoSuchFieldException {
        Assert.assertEquals((long)0L, (long)FieldUtils.getFieldsListWithAnnotation(Object.class, Annotated.class).size());
        List<Field> annotatedFields = Arrays.asList(FieldUtilsTest.class.getDeclaredField("publicChild"), FieldUtilsTest.class.getDeclaredField("privatelyShadowedChild"));
        List fieldUtilsTestAnnotatedFields = FieldUtils.getFieldsListWithAnnotation(FieldUtilsTest.class, Annotated.class);
        Assert.assertEquals((long)annotatedFields.size(), (long)fieldUtilsTestAnnotatedFields.size());
        Assert.assertTrue((boolean)fieldUtilsTestAnnotatedFields.contains(annotatedFields.get(0)));
        Assert.assertTrue((boolean)fieldUtilsTestAnnotatedFields.contains(annotatedFields.get(1)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldsListWithAnnotationIllegalArgumentException1() {
        FieldUtils.getFieldsListWithAnnotation(FieldUtilsTest.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldsListWithAnnotationIllegalArgumentException2() {
        FieldUtils.getFieldsListWithAnnotation(null, Annotated.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFieldsListWithAnnotationIllegalArgumentException3() {
        FieldUtils.getFieldsListWithAnnotation(null, null);
    }

    @Test
    public void testGetDeclaredField() {
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"VALUE"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"s"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"b"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"i"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"d"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"VALUE"));
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"s").getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"b").getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"i").getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"d").getDeclaringClass());
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"VALUE"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"s"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"b"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"i"));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"d"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDeclaredFieldAccessIllegalArgumentException1() {
        FieldUtils.getDeclaredField(null, (String)"none");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDeclaredFieldAccessIllegalArgumentException2() {
        FieldUtils.getDeclaredField(PublicChild.class, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDeclaredFieldAccessIllegalArgumentException3() {
        FieldUtils.getDeclaredField(PublicChild.class, (String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDeclaredFieldAccessIllegalArgumentException4() {
        FieldUtils.getDeclaredField(PublicChild.class, (String)" ");
    }

    @Test
    public void testGetDeclaredFieldForceAccess() {
        Assert.assertEquals(PublicChild.class, FieldUtils.getDeclaredField(PublicChild.class, (String)"VALUE", (boolean)true).getDeclaringClass());
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"s", (boolean)true));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"b", (boolean)true));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"i", (boolean)true));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PublicChild.class, (String)"d", (boolean)true));
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PubliclyShadowedChild.class, FieldUtils.getDeclaredField(PubliclyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
        Assert.assertNull((Object)FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assert.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"s", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"b", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"i", (boolean)true).getDeclaringClass());
        Assert.assertEquals(PrivatelyShadowedChild.class, FieldUtils.getDeclaredField(PrivatelyShadowedChild.class, (String)"d", (boolean)true).getDeclaringClass());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDeclaredFieldForceAccessIllegalArgumentException1() {
        FieldUtils.getDeclaredField(null, (String)"none", (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDeclaredFieldForceAccessIllegalArgumentException2() {
        FieldUtils.getDeclaredField(PublicChild.class, null, (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDeclaredFieldForceAccessIllegalArgumentException3() {
        FieldUtils.getDeclaredField(PublicChild.class, (String)"", (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetDeclaredFieldForceAccessIllegalArgumentException4() {
        FieldUtils.getDeclaredField(PublicChild.class, (String)" ", (boolean)true);
    }

    @Test
    public void testReadStaticField() throws Exception {
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadStaticFieldIllegalArgumentException1() throws Exception {
        FieldUtils.readStaticField(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadStaticFieldIllegalArgumentException2() throws Exception {
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
        Field nonStaticField = FieldUtils.getField(PublicChild.class, (String)"s");
        Assume.assumeNotNull((Object[])new Object[]{nonStaticField});
        FieldUtils.readStaticField((Field)nonStaticField);
    }

    @Test
    public void testReadStaticFieldForceAccess() throws Exception {
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(Foo.class, (String)"VALUE")));
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField((Field)FieldUtils.getField(PublicChild.class, (String)"VALUE")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadStaticFieldForceAccessIllegalArgumentException1() throws Exception {
        FieldUtils.readStaticField(null, (boolean)true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReadStaticFieldForceAccessIllegalArgumentException2() throws Exception {
        Field nonStaticField = FieldUtils.getField(PublicChild.class, (String)"s", (boolean)true);
        Assume.assumeNotNull((Object[])new Object[]{nonStaticField});
        FieldUtils.readStaticField((Field)nonStaticField);
    }

    @Test
    public void testReadNamedStaticField() throws Exception {
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(Foo.class, (String)"VALUE"));
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PubliclyShadowedChild.class, (String)"VALUE"));
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PrivatelyShadowedChild.class, (String)"VALUE"));
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PublicChild.class, (String)"VALUE"));
        try {
            FieldUtils.readStaticField(null, (String)"none");
            Assert.fail((String)"null class should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(Foo.class, null);
            Assert.fail((String)"null field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(Foo.class, (String)"");
            Assert.fail((String)"empty field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(Foo.class, (String)" ");
            Assert.fail((String)"blank field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(Foo.class, (String)"does_not_exist");
            Assert.fail((String)"a field that doesn't exist should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(PublicChild.class, (String)"s");
            Assert.fail((String)"non-static field should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadNamedStaticFieldForceAccess() throws Exception {
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(Foo.class, (String)"VALUE", (boolean)true));
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readStaticField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true));
        Assert.assertEquals((Object)"child", (Object)FieldUtils.readStaticField(PublicChild.class, (String)"VALUE", (boolean)true));
        try {
            FieldUtils.readStaticField(null, (String)"none", (boolean)true);
            Assert.fail((String)"null class should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(Foo.class, null, (boolean)true);
            Assert.fail((String)"null field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(Foo.class, (String)"", (boolean)true);
            Assert.fail((String)"empty field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(Foo.class, (String)" ", (boolean)true);
            Assert.fail((String)"blank field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(Foo.class, (String)"does_not_exist", (boolean)true);
            Assert.fail((String)"a field that doesn't exist should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readStaticField(PublicChild.class, (String)"s", (boolean)false);
            Assert.fail((String)"non-static field should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadDeclaredNamedStaticField() throws Exception {
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readDeclaredStaticField(Foo.class, (String)"VALUE"));
        try {
            FieldUtils.readDeclaredStaticField(PublicChild.class, (String)"VALUE");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredStaticField(PubliclyShadowedChild.class, (String)"VALUE");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, (String)"VALUE");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadDeclaredNamedStaticFieldForceAccess() throws Exception {
        Assert.assertEquals((Object)"foo", (Object)FieldUtils.readDeclaredStaticField(Foo.class, (String)"VALUE", (boolean)true));
        Assert.assertEquals((Object)"child", (Object)FieldUtils.readDeclaredStaticField(PublicChild.class, (String)"VALUE", (boolean)true));
        try {
            FieldUtils.readDeclaredStaticField(PubliclyShadowedChild.class, (String)"VALUE", (boolean)true);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredStaticField(PrivatelyShadowedChild.class, (String)"VALUE", (boolean)true);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadField() throws Exception {
        Field parentS = FieldUtils.getDeclaredField(this.parentClass, (String)"s");
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publicChild));
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publiclyShadowedChild));
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.privatelyShadowedChild));
        Field parentB = FieldUtils.getDeclaredField(this.parentClass, (String)"b", (boolean)true);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publicChild));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publiclyShadowedChild));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.privatelyShadowedChild));
        Field parentI = FieldUtils.getDeclaredField(this.parentClass, (String)"i", (boolean)true);
        Assert.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publicChild));
        Assert.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publiclyShadowedChild));
        Assert.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.privatelyShadowedChild));
        Field parentD = FieldUtils.getDeclaredField(this.parentClass, (String)"d", (boolean)true);
        Assert.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publicChild));
        Assert.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publiclyShadowedChild));
        Assert.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.privatelyShadowedChild));
        try {
            FieldUtils.readField(null, (Object)this.publicChild);
            Assert.fail((String)"a null field should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadFieldForceAccess() throws Exception {
        Field parentS = FieldUtils.getDeclaredField(this.parentClass, (String)"s");
        parentS.setAccessible(false);
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publicChild, (boolean)true));
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.publiclyShadowedChild, (boolean)true));
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Field)parentS, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentB = FieldUtils.getDeclaredField(this.parentClass, (String)"b", (boolean)true);
        parentB.setAccessible(false);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publicChild, (boolean)true));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.publiclyShadowedChild, (boolean)true));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Field)parentB, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentI = FieldUtils.getDeclaredField(this.parentClass, (String)"i", (boolean)true);
        parentI.setAccessible(false);
        Assert.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publicChild, (boolean)true));
        Assert.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.publiclyShadowedChild, (boolean)true));
        Assert.assertEquals((Object)I0, (Object)FieldUtils.readField((Field)parentI, (Object)this.privatelyShadowedChild, (boolean)true));
        Field parentD = FieldUtils.getDeclaredField(this.parentClass, (String)"d", (boolean)true);
        parentD.setAccessible(false);
        Assert.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publicChild, (boolean)true));
        Assert.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.publiclyShadowedChild, (boolean)true));
        Assert.assertEquals((Object)D0, (Object)FieldUtils.readField((Field)parentD, (Object)this.privatelyShadowedChild, (boolean)true));
        try {
            FieldUtils.readField(null, (Object)this.publicChild, (boolean)true);
            Assert.fail((String)"a null field should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadNamedField() throws Exception {
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s"));
        Assert.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s"));
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s"));
        try {
            FieldUtils.readField((Object)this.publicChild, null);
            Assert.fail((String)"a null field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField((Object)this.publicChild, (String)"");
            Assert.fail((String)"an empty field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField((Object)this.publicChild, (String)" ");
            Assert.fail((String)"a blank field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField(null, (String)"none");
            Assert.fail((String)"a null target should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField((Object)this.publicChild, (String)"b");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b"));
        try {
            FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField((Object)this.publicChild, (String)"i");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i"));
        try {
            FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField((Object)this.publicChild, (String)"d");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d"));
        try {
            FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadNamedFieldForceAccess() throws Exception {
        Assert.assertEquals((Object)"s", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s", (boolean)true));
        Assert.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        Assert.assertEquals((Object)"ss", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publicChild, (String)"b", (boolean)true));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        Assert.assertEquals((Object)I0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"i", (boolean)true));
        Assert.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        Assert.assertEquals((Object)I1, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        Assert.assertEquals((Object)D0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"d", (boolean)true));
        Assert.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        Assert.assertEquals((Object)D1, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
        try {
            FieldUtils.readField((Object)this.publicChild, null, (boolean)true);
            Assert.fail((String)"a null field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField((Object)this.publicChild, (String)"", (boolean)true);
            Assert.fail((String)"an empty field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField((Object)this.publicChild, (String)" ", (boolean)true);
            Assert.fail((String)"a blank field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readField(null, (String)"none", (boolean)true);
            Assert.fail((String)"a null target should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadDeclaredNamedField() throws Exception {
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, null);
            Assert.fail((String)"a null field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"");
            Assert.fail((String)"an empty field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)" ");
            Assert.fail((String)"a blank field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField(null, (String)"none");
            Assert.fail((String)"a null target should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"s");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s"));
        try {
            FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"b");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b"));
        try {
            FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"i");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i"));
        try {
            FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"d");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d"));
        try {
            FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d");
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadDeclaredNamedFieldForceAccess() throws Exception {
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, null, (boolean)true);
            Assert.fail((String)"a null field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"", (boolean)true);
            Assert.fail((String)"an empty field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)" ", (boolean)true);
            Assert.fail((String)"a blank field name should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField(null, (String)"none", (boolean)true);
            Assert.fail((String)"a null target should cause an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"s", (boolean)true);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        Assert.assertEquals((Object)"ss", (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"b", (boolean)true);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"i", (boolean)true);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        Assert.assertEquals((Object)I1, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        try {
            FieldUtils.readDeclaredField((Object)this.publicChild, (String)"d", (boolean)true);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        Assert.assertEquals((Object)D1, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
    }

    @Test
    public void testWriteStaticField() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("mutablePublic");
        FieldUtils.writeStaticField((Field)field, (Object)"new");
        Assert.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        field = StaticContainer.class.getDeclaredField("mutableProtected");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("mutablePackage");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("mutablePrivate");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("IMMUTABLE_PUBLIC");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("IMMUTABLE_PROTECTED");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteStaticFieldForceAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("mutablePublic");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        field = StaticContainer.class.getDeclaredField("mutableProtected");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        field = StaticContainer.class.getDeclaredField("mutablePackage");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        field = StaticContainer.class.getDeclaredField("mutablePrivate");
        FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        field = StaticContainer.class.getDeclaredField("IMMUTABLE_PUBLIC");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("IMMUTABLE_PROTECTED");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE");
        try {
            FieldUtils.writeStaticField((Field)field, (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteNamedStaticField() throws Exception {
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePublic", (Object)"new");
        Assert.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutableProtected", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePackage", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePrivate", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PUBLIC", (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PROTECTED", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PACKAGE", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PRIVATE", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteNamedStaticFieldForceAccess() throws Exception {
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePublic", (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutableProtected", (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePackage", (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        FieldUtils.writeStaticField(StaticContainerChild.class, (String)"mutablePrivate", (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PUBLIC", (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PROTECTED", (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PACKAGE", (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            FieldUtils.writeStaticField(StaticContainerChild.class, (String)"IMMUTABLE_PRIVATE", (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteDeclaredNamedStaticField() throws Exception {
        FieldUtils.writeStaticField(StaticContainer.class, (String)"mutablePublic", (Object)"new");
        Assert.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutableProtected", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePackage", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePrivate", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PUBLIC", (Object)"new");
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PROTECTED", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PACKAGE", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PRIVATE", (Object)"new");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteDeclaredNamedStaticFieldForceAccess() throws Exception {
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePublic", (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.mutablePublic);
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutableProtected", (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutableProtected());
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePackage", (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutablePackage());
        FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"mutablePrivate", (Object)"new", (boolean)true);
        Assert.assertEquals((Object)"new", (Object)StaticContainer.getMutablePrivate());
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PUBLIC", (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PROTECTED", (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PACKAGE", (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredStaticField(StaticContainer.class, (String)"IMMUTABLE_PRIVATE", (Object)"new", (boolean)true);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteField() throws Exception {
        Field field = this.parentClass.getDeclaredField("s");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)"S");
        Assert.assertEquals((Object)"S", (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("b");
        try {
            FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Boolean.TRUE);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = this.parentClass.getDeclaredField("i");
        try {
            FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Integer.MAX_VALUE);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        field = this.parentClass.getDeclaredField("d");
        try {
            FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Double.MAX_VALUE);
            Assert.fail((String)"Expected IllegalAccessException");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteFieldForceAccess() throws Exception {
        Field field = this.parentClass.getDeclaredField("s");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)"S", (boolean)true);
        Assert.assertEquals((Object)"S", (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("b");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Boolean.TRUE, (boolean)true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("i");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Integer.MAX_VALUE, (boolean)true);
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)field.get(this.publicChild));
        field = this.parentClass.getDeclaredField("d");
        FieldUtils.writeField((Field)field, (Object)this.publicChild, (Object)Double.MAX_VALUE, (boolean)true);
        Assert.assertEquals((Object)Double.MAX_VALUE, (Object)field.get(this.publicChild));
    }

    @Test
    public void testWriteNamedField() throws Exception {
        FieldUtils.writeField((Object)this.publicChild, (String)"s", (Object)"S");
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s"));
        try {
            FieldUtils.writeField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeField((Object)this.publicChild, (String)"i", (Object)1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeField((Object)this.publicChild, (String)"d", (Object)1.0);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S");
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"i", (Object)0);
        Assert.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i"));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0);
        Assert.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d"));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S");
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s"));
        try {
            FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.TRUE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"i", (Object)1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"d", (Object)1.0);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteNamedFieldForceAccess() throws Exception {
        FieldUtils.writeField((Object)this.publicChild, (String)"s", (Object)"S", (boolean)true);
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publicChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE, (boolean)true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)FieldUtils.readField((Object)this.publicChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"i", (Object)1, (boolean)true);
        Assert.assertEquals((Object)1, (Object)FieldUtils.readField((Object)this.publicChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.publicChild, (String)"d", (Object)1.0, (boolean)true);
        Assert.assertEquals((Object)1.0, (Object)FieldUtils.readField((Object)this.publicChild, (String)"d", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assert.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assert.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assert.assertEquals((Object)0, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeField((Object)this.privatelyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assert.assertEquals((Object)0.0, (Object)FieldUtils.readField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
    }

    @Test
    public void testWriteDeclaredNamedField() throws Exception {
        try {
            FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"s", (Object)"S");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"i", (Object)1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"d", (Object)1.0);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S");
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (Object)0);
        Assert.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i"));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0);
        Assert.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d"));
        try {
            FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S");
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.TRUE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (Object)1);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (Object)1.0);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteDeclaredNamedFieldForceAccess() throws Exception {
        try {
            FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"s", (Object)"S", (boolean)true);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"b", (Object)Boolean.TRUE, (boolean)true);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"i", (Object)1, (boolean)true);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            FieldUtils.writeDeclaredField((Object)this.publicChild, (String)"d", (Object)1.0, (boolean)true);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assert.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assert.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.publiclyShadowedChild, (String)"d", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (Object)"S", (boolean)true);
        Assert.assertEquals((Object)"S", (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"s", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (Object)Boolean.FALSE, (boolean)true);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"b", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (Object)0, (boolean)true);
        Assert.assertEquals((Object)0, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"i", (boolean)true));
        FieldUtils.writeDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (Object)0.0, (boolean)true);
        Assert.assertEquals((Object)0.0, (Object)FieldUtils.readDeclaredField((Object)this.privatelyShadowedChild, (String)"d", (boolean)true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAmbig() {
        FieldUtils.getField(Ambig.class, (String)"VALUE");
    }

    @Test
    public void testRemoveFinalModifier() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assert.assertFalse((boolean)field.isAccessible());
        Assert.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        FieldUtils.removeFinalModifier((Field)field);
        Assert.assertFalse((boolean)Modifier.isFinal(field.getModifiers()));
        Assert.assertFalse((boolean)field.isAccessible());
    }

    @Test
    public void testRemoveFinalModifierWithAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assert.assertFalse((boolean)field.isAccessible());
        Assert.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        FieldUtils.removeFinalModifier((Field)field, (boolean)true);
        Assert.assertFalse((boolean)Modifier.isFinal(field.getModifiers()));
        Assert.assertFalse((boolean)field.isAccessible());
    }

    @Test
    public void testRemoveFinalModifierWithoutAccess() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PRIVATE_2");
        Assert.assertFalse((boolean)field.isAccessible());
        Assert.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        FieldUtils.removeFinalModifier((Field)field, (boolean)false);
        Assert.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        Assert.assertFalse((boolean)field.isAccessible());
    }

    @Test
    public void testRemoveFinalModifierAccessNotNeeded() throws Exception {
        Field field = StaticContainer.class.getDeclaredField("IMMUTABLE_PACKAGE");
        Assert.assertFalse((boolean)field.isAccessible());
        Assert.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        FieldUtils.removeFinalModifier((Field)field, (boolean)false);
        Assert.assertTrue((boolean)Modifier.isFinal(field.getModifiers()));
        Assert.assertFalse((boolean)field.isAccessible());
    }
}

