/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.lang3.reflect.TypeLiteral;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.junit.Assert;
import org.junit.Test;

public class TypeLiteralTest {
    @Test
    public void testBasic() {
        Assert.assertTrue((boolean)TypeUtils.equals(String.class, (Type)new TypeLiteral<String>(){}.value));
        Assert.assertTrue((boolean)TypeUtils.equals((Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{String.class}), (Type)new TypeLiteral<List<String>>(){}.value));
    }

    @Test
    public void testTyped() {
        TypeLiteral<String> stringType = new TypeLiteral<String>(){};
        Assert.assertTrue((boolean)TypeUtils.equals(String.class, (Type)stringType.getType()));
        TypeLiteral<List<String>> listOfStringType = new TypeLiteral<List<String>>(){};
        Assert.assertTrue((boolean)TypeUtils.equals((Type)TypeUtils.parameterize(List.class, (Type[])new Type[]{String.class}), (Type)listOfStringType.getType()));
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new TypeLiteral<String>(){}, (Object)new TypeLiteral<String>(){});
        Assert.assertEquals((Object)new TypeLiteral<List<String>>(){}, (Object)new TypeLiteral<List<String>>(){});
        Assert.assertNotEquals((Object)new TypeLiteral<String>(){}, (Object)new TypeLiteral<List<String>>(){});
    }

    @Test(expected=NullPointerException.class)
    public void testRaw() {
        new TypeLiteral(){};
    }
}

