/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharRange;
import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;

public class CharSetTest {
    @Test
    public void testClass() {
        Assert.assertTrue((boolean)Modifier.isPublic(CharSet.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(CharSet.class.getModifiers()));
    }

    @Test
    public void testGetInstance() {
        Assert.assertSame((Object)CharSet.EMPTY, (Object)CharSet.getInstance((String[])new String[]{null}));
        Assert.assertSame((Object)CharSet.EMPTY, (Object)CharSet.getInstance((String[])new String[]{""}));
        Assert.assertSame((Object)CharSet.ASCII_ALPHA, (Object)CharSet.getInstance((String[])new String[]{"a-zA-Z"}));
        Assert.assertSame((Object)CharSet.ASCII_ALPHA, (Object)CharSet.getInstance((String[])new String[]{"A-Za-z"}));
        Assert.assertSame((Object)CharSet.ASCII_ALPHA_LOWER, (Object)CharSet.getInstance((String[])new String[]{"a-z"}));
        Assert.assertSame((Object)CharSet.ASCII_ALPHA_UPPER, (Object)CharSet.getInstance((String[])new String[]{"A-Z"}));
        Assert.assertSame((Object)CharSet.ASCII_NUMERIC, (Object)CharSet.getInstance((String[])new String[]{"0-9"}));
    }

    @Test
    public void testGetInstance_Stringarray() {
        Assert.assertEquals(null, (Object)CharSet.getInstance((String[])null));
        Assert.assertEquals((Object)"[]", (Object)CharSet.getInstance((String[])new String[0]).toString());
        Assert.assertEquals((Object)"[]", (Object)CharSet.getInstance((String[])new String[]{null}).toString());
        Assert.assertEquals((Object)"[a-e]", (Object)CharSet.getInstance((String[])new String[]{"a-e"}).toString());
    }

    @Test
    public void testConstructor_String_simple() {
        CharSet set = CharSet.getInstance((String[])new String[]{null});
        CharRange[] array = set.getCharRanges();
        Assert.assertEquals((Object)"[]", (Object)set.toString());
        Assert.assertEquals((long)0L, (long)array.length);
        set = CharSet.getInstance((String[])new String[]{""});
        array = set.getCharRanges();
        Assert.assertEquals((Object)"[]", (Object)set.toString());
        Assert.assertEquals((long)0L, (long)array.length);
        set = CharSet.getInstance((String[])new String[]{"a"});
        array = set.getCharRanges();
        Assert.assertEquals((Object)"[a]", (Object)set.toString());
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)"a", (Object)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"^a"});
        array = set.getCharRanges();
        Assert.assertEquals((Object)"[^a]", (Object)set.toString());
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)"^a", (Object)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"a-e"});
        array = set.getCharRanges();
        Assert.assertEquals((Object)"[a-e]", (Object)set.toString());
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)"a-e", (Object)array[0].toString());
        set = CharSet.getInstance((String[])new String[]{"^a-e"});
        array = set.getCharRanges();
        Assert.assertEquals((Object)"[^a-e]", (Object)set.toString());
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertEquals((Object)"^a-e", (Object)array[0].toString());
    }

    @Test
    public void testConstructor_String_combo() {
        CharSet set = CharSet.getInstance((String[])new String[]{"abc"});
        Object[] array = set.getCharRanges();
        Assert.assertEquals((long)3L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"a-ce-f"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'c')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"ae-f"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"e-fa"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        set = CharSet.getInstance((String[])new String[]{"ae-fm-pz"});
        array = set.getCharRanges();
        Assert.assertEquals((long)4L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'e', (char)'f')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'m', (char)'p')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'z')));
    }

    @Test
    public void testConstructor_String_comboNegated() {
        CharSet set = CharSet.getInstance((String[])new String[]{"^abc"});
        Object[] array = set.getCharRanges();
        Assert.assertEquals((long)3L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"b^ac"});
        array = set.getCharRanges();
        Assert.assertEquals((long)3L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"db^ac"});
        array = set.getCharRanges();
        Assert.assertEquals((long)4L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'d')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        set = CharSet.getInstance((String[])new String[]{"^b^a"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'b')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        set = CharSet.getInstance((String[])new String[]{"b^a-c^z"});
        array = set.getCharRanges();
        Assert.assertEquals((long)3L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'a', (char)'c')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'z')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'b')));
    }

    @Test
    public void testConstructor_String_oddDash() {
        CharSet set = CharSet.getInstance((String[])new String[]{"-"});
        Object[] array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"--"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"---"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"----"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"-a"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        set = CharSet.getInstance((String[])new String[]{"a-"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"a--"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'-')));
        set = CharSet.getInstance((String[])new String[]{"--a"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'-', (char)'a')));
    }

    @Test
    public void testConstructor_String_oddNegate() {
        CharSet set = CharSet.getInstance((String[])new String[]{"^"});
        Object[] array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^^"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^^^^"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"a^"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^a-"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'a')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
        set = CharSet.getInstance((String[])new String[]{"^^-c"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'^', (char)'c')));
        set = CharSet.getInstance((String[])new String[]{"^c-^"});
        array = set.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'c', (char)'^')));
        set = CharSet.getInstance((String[])new String[]{"^c-^d"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'c', (char)'^')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'d')));
        set = CharSet.getInstance((String[])new String[]{"^^-"});
        array = set.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNot((char)'^')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'-')));
    }

    @Test
    public void testConstructor_String_oddCombinations() {
        Object[] array = null;
        CharSet set = CharSet.getInstance((String[])new String[]{"a-^c"});
        array = set.getCharRanges();
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'^')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        Assert.assertFalse((boolean)set.contains('b'));
        Assert.assertTrue((boolean)set.contains('^'));
        Assert.assertTrue((boolean)set.contains('_'));
        Assert.assertTrue((boolean)set.contains('c'));
        set = CharSet.getInstance((String[])new String[]{"^a-^c"});
        array = set.getCharRanges();
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'a', (char)'^')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.is((char)'c')));
        Assert.assertTrue((boolean)set.contains('b'));
        Assert.assertFalse((boolean)set.contains('^'));
        Assert.assertFalse((boolean)set.contains('_'));
        set = CharSet.getInstance((String[])new String[]{"a- ^-- "});
        array = set.getCharRanges();
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)' ')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isNotIn((char)'-', (char)' ')));
        Assert.assertTrue((boolean)set.contains('#'));
        Assert.assertTrue((boolean)set.contains('^'));
        Assert.assertTrue((boolean)set.contains('a'));
        Assert.assertTrue((boolean)set.contains('*'));
        Assert.assertTrue((boolean)set.contains('A'));
        set = CharSet.getInstance((String[])new String[]{"^-b"});
        array = set.getCharRanges();
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'^', (char)'b')));
        Assert.assertTrue((boolean)set.contains('b'));
        Assert.assertTrue((boolean)set.contains('_'));
        Assert.assertFalse((boolean)set.contains('A'));
        Assert.assertTrue((boolean)set.contains('^'));
        set = CharSet.getInstance((String[])new String[]{"b-^"});
        array = set.getCharRanges();
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'^', (char)'b')));
        Assert.assertTrue((boolean)set.contains('b'));
        Assert.assertTrue((boolean)set.contains('^'));
        Assert.assertTrue((boolean)set.contains('a'));
        Assert.assertFalse((boolean)set.contains('c'));
    }

    @Test
    public void testEquals_Object() {
        CharSet abc = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet abc2 = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet atoc = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet atoc2 = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet notatoc = CharSet.getInstance((String[])new String[]{"^a-c"});
        CharSet notatoc2 = CharSet.getInstance((String[])new String[]{"^a-c"});
        Assert.assertFalse((boolean)abc.equals(null));
        Assert.assertTrue((boolean)abc.equals((Object)abc));
        Assert.assertTrue((boolean)abc.equals((Object)abc2));
        Assert.assertFalse((boolean)abc.equals((Object)atoc));
        Assert.assertFalse((boolean)abc.equals((Object)notatoc));
        Assert.assertFalse((boolean)atoc.equals((Object)abc));
        Assert.assertTrue((boolean)atoc.equals((Object)atoc));
        Assert.assertTrue((boolean)atoc.equals((Object)atoc2));
        Assert.assertFalse((boolean)atoc.equals((Object)notatoc));
        Assert.assertFalse((boolean)notatoc.equals((Object)abc));
        Assert.assertFalse((boolean)notatoc.equals((Object)atoc));
        Assert.assertTrue((boolean)notatoc.equals((Object)notatoc));
        Assert.assertTrue((boolean)notatoc.equals((Object)notatoc2));
    }

    @Test
    public void testHashCode() {
        CharSet abc = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet abc2 = CharSet.getInstance((String[])new String[]{"abc"});
        CharSet atoc = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet atoc2 = CharSet.getInstance((String[])new String[]{"a-c"});
        CharSet notatoc = CharSet.getInstance((String[])new String[]{"^a-c"});
        CharSet notatoc2 = CharSet.getInstance((String[])new String[]{"^a-c"});
        Assert.assertEquals((long)abc.hashCode(), (long)abc.hashCode());
        Assert.assertEquals((long)abc.hashCode(), (long)abc2.hashCode());
        Assert.assertEquals((long)atoc.hashCode(), (long)atoc.hashCode());
        Assert.assertEquals((long)atoc.hashCode(), (long)atoc2.hashCode());
        Assert.assertEquals((long)notatoc.hashCode(), (long)notatoc.hashCode());
        Assert.assertEquals((long)notatoc.hashCode(), (long)notatoc2.hashCode());
    }

    @Test
    public void testContains_Char() {
        CharSet btod = CharSet.getInstance((String[])new String[]{"b-d"});
        CharSet dtob = CharSet.getInstance((String[])new String[]{"d-b"});
        CharSet bcd = CharSet.getInstance((String[])new String[]{"bcd"});
        CharSet bd = CharSet.getInstance((String[])new String[]{"bd"});
        CharSet notbtod = CharSet.getInstance((String[])new String[]{"^b-d"});
        Assert.assertFalse((boolean)btod.contains('a'));
        Assert.assertTrue((boolean)btod.contains('b'));
        Assert.assertTrue((boolean)btod.contains('c'));
        Assert.assertTrue((boolean)btod.contains('d'));
        Assert.assertFalse((boolean)btod.contains('e'));
        Assert.assertFalse((boolean)bcd.contains('a'));
        Assert.assertTrue((boolean)bcd.contains('b'));
        Assert.assertTrue((boolean)bcd.contains('c'));
        Assert.assertTrue((boolean)bcd.contains('d'));
        Assert.assertFalse((boolean)bcd.contains('e'));
        Assert.assertFalse((boolean)bd.contains('a'));
        Assert.assertTrue((boolean)bd.contains('b'));
        Assert.assertFalse((boolean)bd.contains('c'));
        Assert.assertTrue((boolean)bd.contains('d'));
        Assert.assertFalse((boolean)bd.contains('e'));
        Assert.assertTrue((boolean)notbtod.contains('a'));
        Assert.assertFalse((boolean)notbtod.contains('b'));
        Assert.assertFalse((boolean)notbtod.contains('c'));
        Assert.assertFalse((boolean)notbtod.contains('d'));
        Assert.assertTrue((boolean)notbtod.contains('e'));
        Assert.assertFalse((boolean)dtob.contains('a'));
        Assert.assertTrue((boolean)dtob.contains('b'));
        Assert.assertTrue((boolean)dtob.contains('c'));
        Assert.assertTrue((boolean)dtob.contains('d'));
        Assert.assertFalse((boolean)dtob.contains('e'));
        CharRange[] array = dtob.getCharRanges();
        Assert.assertEquals((Object)"[b-d]", (Object)dtob.toString());
        Assert.assertEquals((long)1L, (long)array.length);
    }

    @Test
    public void testSerialization() {
        CharSet set = CharSet.getInstance((String[])new String[]{"a"});
        Assert.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
        set = CharSet.getInstance((String[])new String[]{"a-e"});
        Assert.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
        set = CharSet.getInstance((String[])new String[]{"be-f^a-z"});
        Assert.assertEquals((Object)set, (Object)SerializationUtils.clone((Serializable)set));
    }

    @Test
    public void testStatics() {
        Object[] array = CharSet.EMPTY.getCharRanges();
        Assert.assertEquals((long)0L, (long)array.length);
        array = CharSet.ASCII_ALPHA.getCharRanges();
        Assert.assertEquals((long)2L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'z')));
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'A', (char)'Z')));
        array = CharSet.ASCII_ALPHA_LOWER.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'a', (char)'z')));
        array = CharSet.ASCII_ALPHA_UPPER.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'A', (char)'Z')));
        array = CharSet.ASCII_NUMERIC.getCharRanges();
        Assert.assertEquals((long)1L, (long)array.length);
        Assert.assertTrue((boolean)ArrayUtils.contains((Object[])array, (Object)CharRange.isIn((char)'0', (char)'9')));
    }

    @Test
    public void testJavadocExamples() throws Exception {
        Assert.assertFalse((boolean)CharSet.getInstance((String[])new String[]{"^a-c"}).contains('a'));
        Assert.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"^a-c"}).contains('d'));
        Assert.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"^^a-c"}).contains('a'));
        Assert.assertFalse((boolean)CharSet.getInstance((String[])new String[]{"^^a-c"}).contains('^'));
        Assert.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"^a-cd-f"}).contains('d'));
        Assert.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"a-c^"}).contains('^'));
        Assert.assertTrue((boolean)CharSet.getInstance((String[])new String[]{"^", "a-c"}).contains('^'));
    }
}

