/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.reflect.testbed.GenericConsumer;
import org.apache.commons.lang3.reflect.testbed.GenericParent;
import org.apache.commons.lang3.reflect.testbed.StringParameterizedChild;
import org.junit.Assert;
import org.junit.Test;

public class ClassUtilsTest {
    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new ClassUtils());
        Constructor<?>[] cons = ClassUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(ClassUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(ClassUtils.class.getModifiers()));
    }

    @Test
    public void test_getShortClassName_Object() {
        Assert.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortClassName((Object)new ClassUtils(), (String)"<null>"));
        Assert.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortClassName((Object)new Inner(), (String)"<null>"));
        Assert.assertEquals((Object)"String", (Object)ClassUtils.getShortClassName((Object)"hello", (String)"<null>"));
        Assert.assertEquals((Object)"<null>", (Object)ClassUtils.getShortClassName(null, (String)"<null>"));
        Assert.assertEquals((Object)"ClassUtilsTest.1", (Object)ClassUtils.getShortClassName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        Assert.assertEquals((Object)"ClassUtilsTest.1Named", (Object)ClassUtils.getShortClassName((Object)new Named(), (String)"<null>"));
        Assert.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortClassName((Object)new Inner(), (String)"<null>"));
    }

    @Test
    public void test_getShortClassName_Class() {
        Assert.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortClassName(ClassUtils.class));
        Assert.assertEquals((Object)"Map.Entry", (Object)ClassUtils.getShortClassName(Map.Entry.class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getShortClassName((Class)null));
        Assert.assertEquals((Object)"String[]", (Object)ClassUtils.getShortClassName(String[].class));
        Assert.assertEquals((Object)"Map.Entry[]", (Object)ClassUtils.getShortClassName(Map.Entry[].class));
        Assert.assertEquals((Object)"boolean", (Object)ClassUtils.getShortClassName(Boolean.TYPE));
        Assert.assertEquals((Object)"byte", (Object)ClassUtils.getShortClassName(Byte.TYPE));
        Assert.assertEquals((Object)"char", (Object)ClassUtils.getShortClassName(Character.TYPE));
        Assert.assertEquals((Object)"short", (Object)ClassUtils.getShortClassName(Short.TYPE));
        Assert.assertEquals((Object)"int", (Object)ClassUtils.getShortClassName(Integer.TYPE));
        Assert.assertEquals((Object)"long", (Object)ClassUtils.getShortClassName(Long.TYPE));
        Assert.assertEquals((Object)"float", (Object)ClassUtils.getShortClassName(Float.TYPE));
        Assert.assertEquals((Object)"double", (Object)ClassUtils.getShortClassName(Double.TYPE));
        Assert.assertEquals((Object)"boolean[]", (Object)ClassUtils.getShortClassName(boolean[].class));
        Assert.assertEquals((Object)"byte[]", (Object)ClassUtils.getShortClassName(byte[].class));
        Assert.assertEquals((Object)"char[]", (Object)ClassUtils.getShortClassName(char[].class));
        Assert.assertEquals((Object)"short[]", (Object)ClassUtils.getShortClassName(short[].class));
        Assert.assertEquals((Object)"int[]", (Object)ClassUtils.getShortClassName(int[].class));
        Assert.assertEquals((Object)"long[]", (Object)ClassUtils.getShortClassName(long[].class));
        Assert.assertEquals((Object)"float[]", (Object)ClassUtils.getShortClassName(float[].class));
        Assert.assertEquals((Object)"double[]", (Object)ClassUtils.getShortClassName(double[].class));
        Assert.assertEquals((Object)"String[][]", (Object)ClassUtils.getShortClassName(String[][].class));
        Assert.assertEquals((Object)"String[][][]", (Object)ClassUtils.getShortClassName(String[][][].class));
        Assert.assertEquals((Object)"String[][][][]", (Object)ClassUtils.getShortClassName(String[][][][].class));
        Assert.assertEquals((Object)"ClassUtilsTest.2", (Object)ClassUtils.getShortClassName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assert.assertEquals((Object)"ClassUtilsTest.2Named", (Object)ClassUtils.getShortClassName(Named.class));
        Assert.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortClassName(Inner.class));
    }

    @Test
    public void test_getShortClassName_String() {
        Assert.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortClassName((String)ClassUtils.class.getName()));
        Assert.assertEquals((Object)"Map.Entry", (Object)ClassUtils.getShortClassName((String)Map.Entry.class.getName()));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getShortClassName((String)null));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getShortClassName((String)""));
    }

    @Test
    public void test_getSimpleName_Class() {
        Assert.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getSimpleName(ClassUtils.class));
        Assert.assertEquals((Object)"Entry", (Object)ClassUtils.getSimpleName(Map.Entry.class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getSimpleName((Class)null));
        Assert.assertEquals((Object)"String[]", (Object)ClassUtils.getSimpleName(String[].class));
        Assert.assertEquals((Object)"Entry[]", (Object)ClassUtils.getSimpleName(Map.Entry[].class));
        Assert.assertEquals((Object)"boolean", (Object)ClassUtils.getSimpleName(Boolean.TYPE));
        Assert.assertEquals((Object)"byte", (Object)ClassUtils.getSimpleName(Byte.TYPE));
        Assert.assertEquals((Object)"char", (Object)ClassUtils.getSimpleName(Character.TYPE));
        Assert.assertEquals((Object)"short", (Object)ClassUtils.getSimpleName(Short.TYPE));
        Assert.assertEquals((Object)"int", (Object)ClassUtils.getSimpleName(Integer.TYPE));
        Assert.assertEquals((Object)"long", (Object)ClassUtils.getSimpleName(Long.TYPE));
        Assert.assertEquals((Object)"float", (Object)ClassUtils.getSimpleName(Float.TYPE));
        Assert.assertEquals((Object)"double", (Object)ClassUtils.getSimpleName(Double.TYPE));
        Assert.assertEquals((Object)"boolean[]", (Object)ClassUtils.getSimpleName(boolean[].class));
        Assert.assertEquals((Object)"byte[]", (Object)ClassUtils.getSimpleName(byte[].class));
        Assert.assertEquals((Object)"char[]", (Object)ClassUtils.getSimpleName(char[].class));
        Assert.assertEquals((Object)"short[]", (Object)ClassUtils.getSimpleName(short[].class));
        Assert.assertEquals((Object)"int[]", (Object)ClassUtils.getSimpleName(int[].class));
        Assert.assertEquals((Object)"long[]", (Object)ClassUtils.getSimpleName(long[].class));
        Assert.assertEquals((Object)"float[]", (Object)ClassUtils.getSimpleName(float[].class));
        Assert.assertEquals((Object)"double[]", (Object)ClassUtils.getSimpleName(double[].class));
        Assert.assertEquals((Object)"String[][]", (Object)ClassUtils.getSimpleName(String[][].class));
        Assert.assertEquals((Object)"String[][][]", (Object)ClassUtils.getSimpleName(String[][][].class));
        Assert.assertEquals((Object)"String[][][][]", (Object)ClassUtils.getSimpleName(String[][][][].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getSimpleName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assert.assertEquals((Object)"Named", (Object)ClassUtils.getSimpleName(Named.class));
    }

    @Test
    public void test_getSimpleName_Object() {
        Assert.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getSimpleName((Object)new ClassUtils(), (String)"<null>"));
        Assert.assertEquals((Object)"Inner", (Object)ClassUtils.getSimpleName((Object)new Inner(), (String)"<null>"));
        Assert.assertEquals((Object)"String", (Object)ClassUtils.getSimpleName((Object)"hello", (String)"<null>"));
        Assert.assertEquals((Object)"<null>", (Object)ClassUtils.getSimpleName(null, (String)"<null>"));
    }

    @Test
    public void test_getPackageName_Object() {
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName((Object)new ClassUtils(), (String)"<null>"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName((Object)new Inner(), (String)"<null>"));
        Assert.assertEquals((Object)"<null>", (Object)ClassUtils.getPackageName(null, (String)"<null>"));
    }

    @Test
    public void test_getPackageName_Class() {
        Assert.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String.class));
        Assert.assertEquals((Object)"java.util", (Object)ClassUtils.getPackageName(Map.Entry.class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName((Class)null));
        Assert.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName(boolean[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName(byte[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName(char[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName(short[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName(int[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName(long[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName(float[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName(double[].class));
        Assert.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String[][].class));
        Assert.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String[][][].class));
        Assert.assertEquals((Object)"java.lang", (Object)ClassUtils.getPackageName(String[][][][].class));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName(Named.class));
    }

    @Test
    public void test_getPackageName_String() {
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageName((String)ClassUtils.class.getName()));
        Assert.assertEquals((Object)"java.util", (Object)ClassUtils.getPackageName((String)Map.Entry.class.getName()));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName((String)null));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageName((String)""));
    }

    @Test
    public void test_getAbbreviatedName_Class() {
        Assert.assertEquals((Object)"", (Object)ClassUtils.getAbbreviatedName((Class)null, (int)1));
        Assert.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)1));
        Assert.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)5));
        Assert.assertEquals((Object)"j.lang.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)13));
        Assert.assertEquals((Object)"j.lang.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)15));
        Assert.assertEquals((Object)"java.lang.String", (Object)ClassUtils.getAbbreviatedName(String.class, (int)20));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAbbreviatedName_Class_ZeroLen() {
        ClassUtils.getAbbreviatedName(String.class, (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAbbreviatedName_Class_NegativeLen() {
        ClassUtils.getAbbreviatedName(String.class, (int)-10);
    }

    @Test
    public void test_getAbbreviatedName_String() {
        Assert.assertEquals((Object)"", (Object)ClassUtils.getAbbreviatedName((String)null, (int)1));
        Assert.assertEquals((Object)"WithoutPackage", (Object)ClassUtils.getAbbreviatedName((String)"WithoutPackage", (int)1));
        Assert.assertEquals((Object)"j.l.String", (Object)ClassUtils.getAbbreviatedName((String)"java.lang.String", (int)1));
    }

    @Test
    public void test_getAllSuperclasses_Class() {
        List list = ClassUtils.getAllSuperclasses(CY.class);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals(CX.class, list.get(0));
        Assert.assertEquals(Object.class, list.get(1));
        Assert.assertEquals(null, (Object)ClassUtils.getAllSuperclasses(null));
    }

    @Test
    public void test_getAllInterfaces_Class() {
        List list = ClassUtils.getAllInterfaces(CY.class);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals(IB.class, list.get(0));
        Assert.assertEquals(IC.class, list.get(1));
        Assert.assertEquals(ID.class, list.get(2));
        Assert.assertEquals(IE.class, list.get(3));
        Assert.assertEquals(IF.class, list.get(4));
        Assert.assertEquals(IA.class, list.get(5));
        Assert.assertEquals(null, (Object)ClassUtils.getAllInterfaces(null));
    }

    @Test
    public void test_convertClassNamesToClasses_List() {
        ArrayList<Object> list = new ArrayList<Object>();
        List result = ClassUtils.convertClassNamesToClasses(list);
        Assert.assertEquals((long)0L, (long)result.size());
        list.add("java.lang.String");
        list.add("java.lang.xxx");
        list.add("java.lang.Object");
        result = ClassUtils.convertClassNamesToClasses(list);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals(String.class, result.get(0));
        Assert.assertEquals(null, result.get(1));
        Assert.assertEquals(Object.class, result.get(2));
        ArrayList<Object> olist = list;
        olist.add(new Object());
        try {
            ClassUtils.convertClassNamesToClasses(list);
            Assert.fail((String)"Should not have been able to convert list");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        Assert.assertEquals(null, (Object)ClassUtils.convertClassNamesToClasses(null));
    }

    @Test
    public void test_convertClassesToClassNames_List() {
        ArrayList<Object> list = new ArrayList<Object>();
        List result = ClassUtils.convertClassesToClassNames(list);
        Assert.assertEquals((long)0L, (long)result.size());
        list.add(String.class);
        list.add(null);
        list.add(Object.class);
        result = ClassUtils.convertClassesToClassNames(list);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"java.lang.String", result.get(0));
        Assert.assertEquals(null, result.get(1));
        Assert.assertEquals((Object)"java.lang.Object", result.get(2));
        ArrayList<Object> olist = list;
        olist.add(new Object());
        try {
            ClassUtils.convertClassesToClassNames(list);
            Assert.fail((String)"Should not have been able to convert list");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        Assert.assertEquals(null, (Object)ClassUtils.convertClassesToClassNames(null));
    }

    @Test
    public void test_isInnerClass_Class() {
        Assert.assertTrue((boolean)ClassUtils.isInnerClass(Inner.class));
        Assert.assertTrue((boolean)ClassUtils.isInnerClass(Map.Entry.class));
        Assert.assertTrue((boolean)ClassUtils.isInnerClass(new Cloneable(){}.getClass()));
        Assert.assertFalse((boolean)ClassUtils.isInnerClass(this.getClass()));
        Assert.assertFalse((boolean)ClassUtils.isInnerClass(String.class));
        Assert.assertFalse((boolean)ClassUtils.isInnerClass(null));
    }

    @Test
    public void test_isAssignable_ClassArray_ClassArray() throws Exception {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])null));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])null, (Class[])null));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1));
        boolean autoboxing = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5);
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2));
    }

    @Test
    public void test_isAssignable_ClassArray_ClassArray_Autoboxing() throws Exception {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, null, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])null, (Class[])null, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2, (boolean)true));
    }

    @Test
    public void test_isAssignable_ClassArray_ClassArray_NoAutoboxing() throws Exception {
        Class[] array2 = new Class[]{Object.class, Object.class};
        Class[] array1 = new Class[]{Object.class};
        Class[] array1s = new Class[]{String.class};
        Class[] array0 = new Class[]{};
        Class[] arrayPrimitives = new Class[]{Integer.TYPE, Boolean.TYPE};
        Class[] arrayWrappers = new Class[]{Integer.class, Boolean.class};
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array2, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(null, (Class[])array2, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, (Class[])array0, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, (Class[])array0, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array0, null, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])null, (Class[])null, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])array1, (Class[])array1s, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1s, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])array1s, (Class[])array1, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])arrayWrappers, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])arrayPrimitives, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array1, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array1, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable((Class[])arrayWrappers, (Class[])array2, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class[])arrayPrimitives, (Class[])array2, (boolean)false));
    }

    @Test
    public void test_isAssignable() throws Exception {
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(String.class, null));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class));
        boolean autoboxing = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5);
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable(Integer.TYPE, Integer.class));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable(Integer.TYPE, Object.class));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable(Integer.class, Integer.TYPE));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable(Integer.class, Object.class));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable(Boolean.TYPE, Object.class));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE));
        Assert.assertEquals((Object)autoboxing, (Object)ClassUtils.isAssignable(Boolean.class, Object.class));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class));
    }

    @Test
    public void test_isAssignable_Autoboxing() throws Exception {
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(String.class, null, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class, (boolean)true));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Object.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Object.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Object.class, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE, (boolean)true));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class, (boolean)true));
    }

    @Test
    public void test_isAssignable_NoAutoboxing() throws Exception {
        Assert.assertFalse((boolean)ClassUtils.isAssignable((Class)null, null, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(String.class, null, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, Object.class, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(null, Integer.class, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(null, Integer.TYPE, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(String.class, Object.class, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(String.class, String.class, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Object.class, String.class, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.class, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Integer.TYPE, Object.class, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Integer.class, Integer.class, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.class, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Boolean.TYPE, Object.class, (boolean)false));
        Assert.assertFalse((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Object.class, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE, (boolean)false));
        Assert.assertTrue((boolean)ClassUtils.isAssignable(Boolean.class, Boolean.class, (boolean)false));
    }

    @Test
    public void test_isAssignable_Widening() throws Exception {
        Assert.assertFalse((String)"byte -> char", (boolean)ClassUtils.isAssignable(Byte.TYPE, Character.TYPE));
        Assert.assertTrue((String)"byte -> byte", (boolean)ClassUtils.isAssignable(Byte.TYPE, Byte.TYPE));
        Assert.assertTrue((String)"byte -> short", (boolean)ClassUtils.isAssignable(Byte.TYPE, Short.TYPE));
        Assert.assertTrue((String)"byte -> int", (boolean)ClassUtils.isAssignable(Byte.TYPE, Integer.TYPE));
        Assert.assertTrue((String)"byte -> long", (boolean)ClassUtils.isAssignable(Byte.TYPE, Long.TYPE));
        Assert.assertTrue((String)"byte -> float", (boolean)ClassUtils.isAssignable(Byte.TYPE, Float.TYPE));
        Assert.assertTrue((String)"byte -> double", (boolean)ClassUtils.isAssignable(Byte.TYPE, Double.TYPE));
        Assert.assertFalse((String)"byte -> boolean", (boolean)ClassUtils.isAssignable(Byte.TYPE, Boolean.TYPE));
        Assert.assertFalse((String)"short -> char", (boolean)ClassUtils.isAssignable(Short.TYPE, Character.TYPE));
        Assert.assertFalse((String)"short -> byte", (boolean)ClassUtils.isAssignable(Short.TYPE, Byte.TYPE));
        Assert.assertTrue((String)"short -> short", (boolean)ClassUtils.isAssignable(Short.TYPE, Short.TYPE));
        Assert.assertTrue((String)"short -> int", (boolean)ClassUtils.isAssignable(Short.TYPE, Integer.TYPE));
        Assert.assertTrue((String)"short -> long", (boolean)ClassUtils.isAssignable(Short.TYPE, Long.TYPE));
        Assert.assertTrue((String)"short -> float", (boolean)ClassUtils.isAssignable(Short.TYPE, Float.TYPE));
        Assert.assertTrue((String)"short -> double", (boolean)ClassUtils.isAssignable(Short.TYPE, Double.TYPE));
        Assert.assertFalse((String)"short -> boolean", (boolean)ClassUtils.isAssignable(Short.TYPE, Boolean.TYPE));
        Assert.assertTrue((String)"char -> char", (boolean)ClassUtils.isAssignable(Character.TYPE, Character.TYPE));
        Assert.assertFalse((String)"char -> byte", (boolean)ClassUtils.isAssignable(Character.TYPE, Byte.TYPE));
        Assert.assertFalse((String)"char -> short", (boolean)ClassUtils.isAssignable(Character.TYPE, Short.TYPE));
        Assert.assertTrue((String)"char -> int", (boolean)ClassUtils.isAssignable(Character.TYPE, Integer.TYPE));
        Assert.assertTrue((String)"char -> long", (boolean)ClassUtils.isAssignable(Character.TYPE, Long.TYPE));
        Assert.assertTrue((String)"char -> float", (boolean)ClassUtils.isAssignable(Character.TYPE, Float.TYPE));
        Assert.assertTrue((String)"char -> double", (boolean)ClassUtils.isAssignable(Character.TYPE, Double.TYPE));
        Assert.assertFalse((String)"char -> boolean", (boolean)ClassUtils.isAssignable(Character.TYPE, Boolean.TYPE));
        Assert.assertFalse((String)"int -> char", (boolean)ClassUtils.isAssignable(Integer.TYPE, Character.TYPE));
        Assert.assertFalse((String)"int -> byte", (boolean)ClassUtils.isAssignable(Integer.TYPE, Byte.TYPE));
        Assert.assertFalse((String)"int -> short", (boolean)ClassUtils.isAssignable(Integer.TYPE, Short.TYPE));
        Assert.assertTrue((String)"int -> int", (boolean)ClassUtils.isAssignable(Integer.TYPE, Integer.TYPE));
        Assert.assertTrue((String)"int -> long", (boolean)ClassUtils.isAssignable(Integer.TYPE, Long.TYPE));
        Assert.assertTrue((String)"int -> float", (boolean)ClassUtils.isAssignable(Integer.TYPE, Float.TYPE));
        Assert.assertTrue((String)"int -> double", (boolean)ClassUtils.isAssignable(Integer.TYPE, Double.TYPE));
        Assert.assertFalse((String)"int -> boolean", (boolean)ClassUtils.isAssignable(Integer.TYPE, Boolean.TYPE));
        Assert.assertFalse((String)"long -> char", (boolean)ClassUtils.isAssignable(Long.TYPE, Character.TYPE));
        Assert.assertFalse((String)"long -> byte", (boolean)ClassUtils.isAssignable(Long.TYPE, Byte.TYPE));
        Assert.assertFalse((String)"long -> short", (boolean)ClassUtils.isAssignable(Long.TYPE, Short.TYPE));
        Assert.assertFalse((String)"long -> int", (boolean)ClassUtils.isAssignable(Long.TYPE, Integer.TYPE));
        Assert.assertTrue((String)"long -> long", (boolean)ClassUtils.isAssignable(Long.TYPE, Long.TYPE));
        Assert.assertTrue((String)"long -> float", (boolean)ClassUtils.isAssignable(Long.TYPE, Float.TYPE));
        Assert.assertTrue((String)"long -> double", (boolean)ClassUtils.isAssignable(Long.TYPE, Double.TYPE));
        Assert.assertFalse((String)"long -> boolean", (boolean)ClassUtils.isAssignable(Long.TYPE, Boolean.TYPE));
        Assert.assertFalse((String)"float -> char", (boolean)ClassUtils.isAssignable(Float.TYPE, Character.TYPE));
        Assert.assertFalse((String)"float -> byte", (boolean)ClassUtils.isAssignable(Float.TYPE, Byte.TYPE));
        Assert.assertFalse((String)"float -> short", (boolean)ClassUtils.isAssignable(Float.TYPE, Short.TYPE));
        Assert.assertFalse((String)"float -> int", (boolean)ClassUtils.isAssignable(Float.TYPE, Integer.TYPE));
        Assert.assertFalse((String)"float -> long", (boolean)ClassUtils.isAssignable(Float.TYPE, Long.TYPE));
        Assert.assertTrue((String)"float -> float", (boolean)ClassUtils.isAssignable(Float.TYPE, Float.TYPE));
        Assert.assertTrue((String)"float -> double", (boolean)ClassUtils.isAssignable(Float.TYPE, Double.TYPE));
        Assert.assertFalse((String)"float -> boolean", (boolean)ClassUtils.isAssignable(Float.TYPE, Boolean.TYPE));
        Assert.assertFalse((String)"double -> char", (boolean)ClassUtils.isAssignable(Double.TYPE, Character.TYPE));
        Assert.assertFalse((String)"double -> byte", (boolean)ClassUtils.isAssignable(Double.TYPE, Byte.TYPE));
        Assert.assertFalse((String)"double -> short", (boolean)ClassUtils.isAssignable(Double.TYPE, Short.TYPE));
        Assert.assertFalse((String)"double -> int", (boolean)ClassUtils.isAssignable(Double.TYPE, Integer.TYPE));
        Assert.assertFalse((String)"double -> long", (boolean)ClassUtils.isAssignable(Double.TYPE, Long.TYPE));
        Assert.assertFalse((String)"double -> float", (boolean)ClassUtils.isAssignable(Double.TYPE, Float.TYPE));
        Assert.assertTrue((String)"double -> double", (boolean)ClassUtils.isAssignable(Double.TYPE, Double.TYPE));
        Assert.assertFalse((String)"double -> boolean", (boolean)ClassUtils.isAssignable(Double.TYPE, Boolean.TYPE));
        Assert.assertFalse((String)"boolean -> char", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Character.TYPE));
        Assert.assertFalse((String)"boolean -> byte", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Byte.TYPE));
        Assert.assertFalse((String)"boolean -> short", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Short.TYPE));
        Assert.assertFalse((String)"boolean -> int", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Integer.TYPE));
        Assert.assertFalse((String)"boolean -> long", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Long.TYPE));
        Assert.assertFalse((String)"boolean -> float", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Float.TYPE));
        Assert.assertFalse((String)"boolean -> double", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Double.TYPE));
        Assert.assertTrue((String)"boolean -> boolean", (boolean)ClassUtils.isAssignable(Boolean.TYPE, Boolean.TYPE));
    }

    @Test
    public void test_isAssignable_DefaultUnboxing_Widening() throws Exception {
        boolean autoboxing = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_5);
        Assert.assertFalse((String)"byte -> char", (boolean)ClassUtils.isAssignable(Byte.class, Character.TYPE));
        Assert.assertEquals((String)"byte -> byte", (Object)autoboxing, (Object)ClassUtils.isAssignable(Byte.class, Byte.TYPE));
        Assert.assertEquals((String)"byte -> short", (Object)autoboxing, (Object)ClassUtils.isAssignable(Byte.class, Short.TYPE));
        Assert.assertEquals((String)"byte -> int", (Object)autoboxing, (Object)ClassUtils.isAssignable(Byte.class, Integer.TYPE));
        Assert.assertEquals((String)"byte -> long", (Object)autoboxing, (Object)ClassUtils.isAssignable(Byte.class, Long.TYPE));
        Assert.assertEquals((String)"byte -> float", (Object)autoboxing, (Object)ClassUtils.isAssignable(Byte.class, Float.TYPE));
        Assert.assertEquals((String)"byte -> double", (Object)autoboxing, (Object)ClassUtils.isAssignable(Byte.class, Double.TYPE));
        Assert.assertFalse((String)"byte -> boolean", (boolean)ClassUtils.isAssignable(Byte.class, Boolean.TYPE));
        Assert.assertFalse((String)"short -> char", (boolean)ClassUtils.isAssignable(Short.class, Character.TYPE));
        Assert.assertFalse((String)"short -> byte", (boolean)ClassUtils.isAssignable(Short.class, Byte.TYPE));
        Assert.assertEquals((String)"short -> short", (Object)autoboxing, (Object)ClassUtils.isAssignable(Short.class, Short.TYPE));
        Assert.assertEquals((String)"short -> int", (Object)autoboxing, (Object)ClassUtils.isAssignable(Short.class, Integer.TYPE));
        Assert.assertEquals((String)"short -> long", (Object)autoboxing, (Object)ClassUtils.isAssignable(Short.class, Long.TYPE));
        Assert.assertEquals((String)"short -> float", (Object)autoboxing, (Object)ClassUtils.isAssignable(Short.class, Float.TYPE));
        Assert.assertEquals((String)"short -> double", (Object)autoboxing, (Object)ClassUtils.isAssignable(Short.class, Double.TYPE));
        Assert.assertFalse((String)"short -> boolean", (boolean)ClassUtils.isAssignable(Short.class, Boolean.TYPE));
        Assert.assertEquals((String)"char -> char", (Object)autoboxing, (Object)ClassUtils.isAssignable(Character.class, Character.TYPE));
        Assert.assertFalse((String)"char -> byte", (boolean)ClassUtils.isAssignable(Character.class, Byte.TYPE));
        Assert.assertFalse((String)"char -> short", (boolean)ClassUtils.isAssignable(Character.class, Short.TYPE));
        Assert.assertEquals((String)"char -> int", (Object)autoboxing, (Object)ClassUtils.isAssignable(Character.class, Integer.TYPE));
        Assert.assertEquals((String)"char -> long", (Object)autoboxing, (Object)ClassUtils.isAssignable(Character.class, Long.TYPE));
        Assert.assertEquals((String)"char -> float", (Object)autoboxing, (Object)ClassUtils.isAssignable(Character.class, Float.TYPE));
        Assert.assertEquals((String)"char -> double", (Object)autoboxing, (Object)ClassUtils.isAssignable(Character.class, Double.TYPE));
        Assert.assertFalse((String)"char -> boolean", (boolean)ClassUtils.isAssignable(Character.class, Boolean.TYPE));
        Assert.assertFalse((String)"int -> char", (boolean)ClassUtils.isAssignable(Integer.class, Character.TYPE));
        Assert.assertFalse((String)"int -> byte", (boolean)ClassUtils.isAssignable(Integer.class, Byte.TYPE));
        Assert.assertFalse((String)"int -> short", (boolean)ClassUtils.isAssignable(Integer.class, Short.TYPE));
        Assert.assertEquals((String)"int -> int", (Object)autoboxing, (Object)ClassUtils.isAssignable(Integer.class, Integer.TYPE));
        Assert.assertEquals((String)"int -> long", (Object)autoboxing, (Object)ClassUtils.isAssignable(Integer.class, Long.TYPE));
        Assert.assertEquals((String)"int -> float", (Object)autoboxing, (Object)ClassUtils.isAssignable(Integer.class, Float.TYPE));
        Assert.assertEquals((String)"int -> double", (Object)autoboxing, (Object)ClassUtils.isAssignable(Integer.class, Double.TYPE));
        Assert.assertFalse((String)"int -> boolean", (boolean)ClassUtils.isAssignable(Integer.class, Boolean.TYPE));
        Assert.assertFalse((String)"long -> char", (boolean)ClassUtils.isAssignable(Long.class, Character.TYPE));
        Assert.assertFalse((String)"long -> byte", (boolean)ClassUtils.isAssignable(Long.class, Byte.TYPE));
        Assert.assertFalse((String)"long -> short", (boolean)ClassUtils.isAssignable(Long.class, Short.TYPE));
        Assert.assertFalse((String)"long -> int", (boolean)ClassUtils.isAssignable(Long.class, Integer.TYPE));
        Assert.assertEquals((String)"long -> long", (Object)autoboxing, (Object)ClassUtils.isAssignable(Long.class, Long.TYPE));
        Assert.assertEquals((String)"long -> float", (Object)autoboxing, (Object)ClassUtils.isAssignable(Long.class, Float.TYPE));
        Assert.assertEquals((String)"long -> double", (Object)autoboxing, (Object)ClassUtils.isAssignable(Long.class, Double.TYPE));
        Assert.assertFalse((String)"long -> boolean", (boolean)ClassUtils.isAssignable(Long.class, Boolean.TYPE));
        Assert.assertFalse((String)"float -> char", (boolean)ClassUtils.isAssignable(Float.class, Character.TYPE));
        Assert.assertFalse((String)"float -> byte", (boolean)ClassUtils.isAssignable(Float.class, Byte.TYPE));
        Assert.assertFalse((String)"float -> short", (boolean)ClassUtils.isAssignable(Float.class, Short.TYPE));
        Assert.assertFalse((String)"float -> int", (boolean)ClassUtils.isAssignable(Float.class, Integer.TYPE));
        Assert.assertFalse((String)"float -> long", (boolean)ClassUtils.isAssignable(Float.class, Long.TYPE));
        Assert.assertEquals((String)"float -> float", (Object)autoboxing, (Object)ClassUtils.isAssignable(Float.class, Float.TYPE));
        Assert.assertEquals((String)"float -> double", (Object)autoboxing, (Object)ClassUtils.isAssignable(Float.class, Double.TYPE));
        Assert.assertFalse((String)"float -> boolean", (boolean)ClassUtils.isAssignable(Float.class, Boolean.TYPE));
        Assert.assertFalse((String)"double -> char", (boolean)ClassUtils.isAssignable(Double.class, Character.TYPE));
        Assert.assertFalse((String)"double -> byte", (boolean)ClassUtils.isAssignable(Double.class, Byte.TYPE));
        Assert.assertFalse((String)"double -> short", (boolean)ClassUtils.isAssignable(Double.class, Short.TYPE));
        Assert.assertFalse((String)"double -> int", (boolean)ClassUtils.isAssignable(Double.class, Integer.TYPE));
        Assert.assertFalse((String)"double -> long", (boolean)ClassUtils.isAssignable(Double.class, Long.TYPE));
        Assert.assertFalse((String)"double -> float", (boolean)ClassUtils.isAssignable(Double.class, Float.TYPE));
        Assert.assertEquals((String)"double -> double", (Object)autoboxing, (Object)ClassUtils.isAssignable(Double.class, Double.TYPE));
        Assert.assertFalse((String)"double -> boolean", (boolean)ClassUtils.isAssignable(Double.class, Boolean.TYPE));
        Assert.assertFalse((String)"boolean -> char", (boolean)ClassUtils.isAssignable(Boolean.class, Character.TYPE));
        Assert.assertFalse((String)"boolean -> byte", (boolean)ClassUtils.isAssignable(Boolean.class, Byte.TYPE));
        Assert.assertFalse((String)"boolean -> short", (boolean)ClassUtils.isAssignable(Boolean.class, Short.TYPE));
        Assert.assertFalse((String)"boolean -> int", (boolean)ClassUtils.isAssignable(Boolean.class, Integer.TYPE));
        Assert.assertFalse((String)"boolean -> long", (boolean)ClassUtils.isAssignable(Boolean.class, Long.TYPE));
        Assert.assertFalse((String)"boolean -> float", (boolean)ClassUtils.isAssignable(Boolean.class, Float.TYPE));
        Assert.assertFalse((String)"boolean -> double", (boolean)ClassUtils.isAssignable(Boolean.class, Double.TYPE));
        Assert.assertEquals((String)"boolean -> boolean", (Object)autoboxing, (Object)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE));
    }

    @Test
    public void test_isAssignable_Unboxing_Widening() throws Exception {
        Assert.assertFalse((String)"byte -> char", (boolean)ClassUtils.isAssignable(Byte.class, Character.TYPE, (boolean)true));
        Assert.assertTrue((String)"byte -> byte", (boolean)ClassUtils.isAssignable(Byte.class, Byte.TYPE, (boolean)true));
        Assert.assertTrue((String)"byte -> short", (boolean)ClassUtils.isAssignable(Byte.class, Short.TYPE, (boolean)true));
        Assert.assertTrue((String)"byte -> int", (boolean)ClassUtils.isAssignable(Byte.class, Integer.TYPE, (boolean)true));
        Assert.assertTrue((String)"byte -> long", (boolean)ClassUtils.isAssignable(Byte.class, Long.TYPE, (boolean)true));
        Assert.assertTrue((String)"byte -> float", (boolean)ClassUtils.isAssignable(Byte.class, Float.TYPE, (boolean)true));
        Assert.assertTrue((String)"byte -> double", (boolean)ClassUtils.isAssignable(Byte.class, Double.TYPE, (boolean)true));
        Assert.assertFalse((String)"byte -> boolean", (boolean)ClassUtils.isAssignable(Byte.class, Boolean.TYPE, (boolean)true));
        Assert.assertFalse((String)"short -> char", (boolean)ClassUtils.isAssignable(Short.class, Character.TYPE, (boolean)true));
        Assert.assertFalse((String)"short -> byte", (boolean)ClassUtils.isAssignable(Short.class, Byte.TYPE, (boolean)true));
        Assert.assertTrue((String)"short -> short", (boolean)ClassUtils.isAssignable(Short.class, Short.TYPE, (boolean)true));
        Assert.assertTrue((String)"short -> int", (boolean)ClassUtils.isAssignable(Short.class, Integer.TYPE, (boolean)true));
        Assert.assertTrue((String)"short -> long", (boolean)ClassUtils.isAssignable(Short.class, Long.TYPE, (boolean)true));
        Assert.assertTrue((String)"short -> float", (boolean)ClassUtils.isAssignable(Short.class, Float.TYPE, (boolean)true));
        Assert.assertTrue((String)"short -> double", (boolean)ClassUtils.isAssignable(Short.class, Double.TYPE, (boolean)true));
        Assert.assertFalse((String)"short -> boolean", (boolean)ClassUtils.isAssignable(Short.class, Boolean.TYPE, (boolean)true));
        Assert.assertTrue((String)"char -> char", (boolean)ClassUtils.isAssignable(Character.class, Character.TYPE, (boolean)true));
        Assert.assertFalse((String)"char -> byte", (boolean)ClassUtils.isAssignable(Character.class, Byte.TYPE, (boolean)true));
        Assert.assertFalse((String)"char -> short", (boolean)ClassUtils.isAssignable(Character.class, Short.TYPE, (boolean)true));
        Assert.assertTrue((String)"char -> int", (boolean)ClassUtils.isAssignable(Character.class, Integer.TYPE, (boolean)true));
        Assert.assertTrue((String)"char -> long", (boolean)ClassUtils.isAssignable(Character.class, Long.TYPE, (boolean)true));
        Assert.assertTrue((String)"char -> float", (boolean)ClassUtils.isAssignable(Character.class, Float.TYPE, (boolean)true));
        Assert.assertTrue((String)"char -> double", (boolean)ClassUtils.isAssignable(Character.class, Double.TYPE, (boolean)true));
        Assert.assertFalse((String)"char -> boolean", (boolean)ClassUtils.isAssignable(Character.class, Boolean.TYPE, (boolean)true));
        Assert.assertFalse((String)"int -> char", (boolean)ClassUtils.isAssignable(Integer.class, Character.TYPE, (boolean)true));
        Assert.assertFalse((String)"int -> byte", (boolean)ClassUtils.isAssignable(Integer.class, Byte.TYPE, (boolean)true));
        Assert.assertFalse((String)"int -> short", (boolean)ClassUtils.isAssignable(Integer.class, Short.TYPE, (boolean)true));
        Assert.assertTrue((String)"int -> int", (boolean)ClassUtils.isAssignable(Integer.class, Integer.TYPE, (boolean)true));
        Assert.assertTrue((String)"int -> long", (boolean)ClassUtils.isAssignable(Integer.class, Long.TYPE, (boolean)true));
        Assert.assertTrue((String)"int -> float", (boolean)ClassUtils.isAssignable(Integer.class, Float.TYPE, (boolean)true));
        Assert.assertTrue((String)"int -> double", (boolean)ClassUtils.isAssignable(Integer.class, Double.TYPE, (boolean)true));
        Assert.assertFalse((String)"int -> boolean", (boolean)ClassUtils.isAssignable(Integer.class, Boolean.TYPE, (boolean)true));
        Assert.assertFalse((String)"long -> char", (boolean)ClassUtils.isAssignable(Long.class, Character.TYPE, (boolean)true));
        Assert.assertFalse((String)"long -> byte", (boolean)ClassUtils.isAssignable(Long.class, Byte.TYPE, (boolean)true));
        Assert.assertFalse((String)"long -> short", (boolean)ClassUtils.isAssignable(Long.class, Short.TYPE, (boolean)true));
        Assert.assertFalse((String)"long -> int", (boolean)ClassUtils.isAssignable(Long.class, Integer.TYPE, (boolean)true));
        Assert.assertTrue((String)"long -> long", (boolean)ClassUtils.isAssignable(Long.class, Long.TYPE, (boolean)true));
        Assert.assertTrue((String)"long -> float", (boolean)ClassUtils.isAssignable(Long.class, Float.TYPE, (boolean)true));
        Assert.assertTrue((String)"long -> double", (boolean)ClassUtils.isAssignable(Long.class, Double.TYPE, (boolean)true));
        Assert.assertFalse((String)"long -> boolean", (boolean)ClassUtils.isAssignable(Long.class, Boolean.TYPE, (boolean)true));
        Assert.assertFalse((String)"float -> char", (boolean)ClassUtils.isAssignable(Float.class, Character.TYPE, (boolean)true));
        Assert.assertFalse((String)"float -> byte", (boolean)ClassUtils.isAssignable(Float.class, Byte.TYPE, (boolean)true));
        Assert.assertFalse((String)"float -> short", (boolean)ClassUtils.isAssignable(Float.class, Short.TYPE, (boolean)true));
        Assert.assertFalse((String)"float -> int", (boolean)ClassUtils.isAssignable(Float.class, Integer.TYPE, (boolean)true));
        Assert.assertFalse((String)"float -> long", (boolean)ClassUtils.isAssignable(Float.class, Long.TYPE, (boolean)true));
        Assert.assertTrue((String)"float -> float", (boolean)ClassUtils.isAssignable(Float.class, Float.TYPE, (boolean)true));
        Assert.assertTrue((String)"float -> double", (boolean)ClassUtils.isAssignable(Float.class, Double.TYPE, (boolean)true));
        Assert.assertFalse((String)"float -> boolean", (boolean)ClassUtils.isAssignable(Float.class, Boolean.TYPE, (boolean)true));
        Assert.assertFalse((String)"double -> char", (boolean)ClassUtils.isAssignable(Double.class, Character.TYPE, (boolean)true));
        Assert.assertFalse((String)"double -> byte", (boolean)ClassUtils.isAssignable(Double.class, Byte.TYPE, (boolean)true));
        Assert.assertFalse((String)"double -> short", (boolean)ClassUtils.isAssignable(Double.class, Short.TYPE, (boolean)true));
        Assert.assertFalse((String)"double -> int", (boolean)ClassUtils.isAssignable(Double.class, Integer.TYPE, (boolean)true));
        Assert.assertFalse((String)"double -> long", (boolean)ClassUtils.isAssignable(Double.class, Long.TYPE, (boolean)true));
        Assert.assertFalse((String)"double -> float", (boolean)ClassUtils.isAssignable(Double.class, Float.TYPE, (boolean)true));
        Assert.assertTrue((String)"double -> double", (boolean)ClassUtils.isAssignable(Double.class, Double.TYPE, (boolean)true));
        Assert.assertFalse((String)"double -> boolean", (boolean)ClassUtils.isAssignable(Double.class, Boolean.TYPE, (boolean)true));
        Assert.assertFalse((String)"boolean -> char", (boolean)ClassUtils.isAssignable(Boolean.class, Character.TYPE, (boolean)true));
        Assert.assertFalse((String)"boolean -> byte", (boolean)ClassUtils.isAssignable(Boolean.class, Byte.TYPE, (boolean)true));
        Assert.assertFalse((String)"boolean -> short", (boolean)ClassUtils.isAssignable(Boolean.class, Short.TYPE, (boolean)true));
        Assert.assertFalse((String)"boolean -> int", (boolean)ClassUtils.isAssignable(Boolean.class, Integer.TYPE, (boolean)true));
        Assert.assertFalse((String)"boolean -> long", (boolean)ClassUtils.isAssignable(Boolean.class, Long.TYPE, (boolean)true));
        Assert.assertFalse((String)"boolean -> float", (boolean)ClassUtils.isAssignable(Boolean.class, Float.TYPE, (boolean)true));
        Assert.assertFalse((String)"boolean -> double", (boolean)ClassUtils.isAssignable(Boolean.class, Double.TYPE, (boolean)true));
        Assert.assertTrue((String)"boolean -> boolean", (boolean)ClassUtils.isAssignable(Boolean.class, Boolean.TYPE, (boolean)true));
    }

    @Test
    public void testIsPrimitiveOrWrapper() {
        Assert.assertTrue((String)"Boolean.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Boolean.class));
        Assert.assertTrue((String)"Byte.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Byte.class));
        Assert.assertTrue((String)"Character.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Character.class));
        Assert.assertTrue((String)"Short.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Short.class));
        Assert.assertTrue((String)"Integer.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Integer.class));
        Assert.assertTrue((String)"Long.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Long.class));
        Assert.assertTrue((String)"Double.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Double.class));
        Assert.assertTrue((String)"Float.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Float.class));
        Assert.assertTrue((String)"boolean", (boolean)ClassUtils.isPrimitiveOrWrapper(Boolean.TYPE));
        Assert.assertTrue((String)"byte", (boolean)ClassUtils.isPrimitiveOrWrapper(Byte.TYPE));
        Assert.assertTrue((String)"char", (boolean)ClassUtils.isPrimitiveOrWrapper(Character.TYPE));
        Assert.assertTrue((String)"short", (boolean)ClassUtils.isPrimitiveOrWrapper(Short.TYPE));
        Assert.assertTrue((String)"int", (boolean)ClassUtils.isPrimitiveOrWrapper(Integer.TYPE));
        Assert.assertTrue((String)"long", (boolean)ClassUtils.isPrimitiveOrWrapper(Long.TYPE));
        Assert.assertTrue((String)"double", (boolean)ClassUtils.isPrimitiveOrWrapper(Double.TYPE));
        Assert.assertTrue((String)"float", (boolean)ClassUtils.isPrimitiveOrWrapper(Float.TYPE));
        Assert.assertTrue((String)"Void.TYPE", (boolean)ClassUtils.isPrimitiveOrWrapper(Void.TYPE));
        Assert.assertFalse((String)"null", (boolean)ClassUtils.isPrimitiveOrWrapper(null));
        Assert.assertFalse((String)"Void.class", (boolean)ClassUtils.isPrimitiveOrWrapper(Void.class));
        Assert.assertFalse((String)"String.class", (boolean)ClassUtils.isPrimitiveOrWrapper(String.class));
        Assert.assertFalse((String)"this.getClass()", (boolean)ClassUtils.isPrimitiveOrWrapper(this.getClass()));
    }

    @Test
    public void testIsPrimitiveWrapper() {
        Assert.assertTrue((String)"Boolean.class", (boolean)ClassUtils.isPrimitiveWrapper(Boolean.class));
        Assert.assertTrue((String)"Byte.class", (boolean)ClassUtils.isPrimitiveWrapper(Byte.class));
        Assert.assertTrue((String)"Character.class", (boolean)ClassUtils.isPrimitiveWrapper(Character.class));
        Assert.assertTrue((String)"Short.class", (boolean)ClassUtils.isPrimitiveWrapper(Short.class));
        Assert.assertTrue((String)"Integer.class", (boolean)ClassUtils.isPrimitiveWrapper(Integer.class));
        Assert.assertTrue((String)"Long.class", (boolean)ClassUtils.isPrimitiveWrapper(Long.class));
        Assert.assertTrue((String)"Double.class", (boolean)ClassUtils.isPrimitiveWrapper(Double.class));
        Assert.assertTrue((String)"Float.class", (boolean)ClassUtils.isPrimitiveWrapper(Float.class));
        Assert.assertFalse((String)"boolean", (boolean)ClassUtils.isPrimitiveWrapper(Boolean.TYPE));
        Assert.assertFalse((String)"byte", (boolean)ClassUtils.isPrimitiveWrapper(Byte.TYPE));
        Assert.assertFalse((String)"char", (boolean)ClassUtils.isPrimitiveWrapper(Character.TYPE));
        Assert.assertFalse((String)"short", (boolean)ClassUtils.isPrimitiveWrapper(Short.TYPE));
        Assert.assertFalse((String)"int", (boolean)ClassUtils.isPrimitiveWrapper(Integer.TYPE));
        Assert.assertFalse((String)"long", (boolean)ClassUtils.isPrimitiveWrapper(Long.TYPE));
        Assert.assertFalse((String)"double", (boolean)ClassUtils.isPrimitiveWrapper(Double.TYPE));
        Assert.assertFalse((String)"float", (boolean)ClassUtils.isPrimitiveWrapper(Float.TYPE));
        Assert.assertFalse((String)"null", (boolean)ClassUtils.isPrimitiveWrapper(null));
        Assert.assertFalse((String)"Void.class", (boolean)ClassUtils.isPrimitiveWrapper(Void.class));
        Assert.assertFalse((String)"Void.TYPE", (boolean)ClassUtils.isPrimitiveWrapper(Void.TYPE));
        Assert.assertFalse((String)"String.class", (boolean)ClassUtils.isPrimitiveWrapper(String.class));
        Assert.assertFalse((String)"this.getClass()", (boolean)ClassUtils.isPrimitiveWrapper(this.getClass()));
    }

    @Test
    public void testPrimitiveToWrapper() {
        Assert.assertEquals((String)"boolean -> Boolean.class", Boolean.class, (Object)ClassUtils.primitiveToWrapper(Boolean.TYPE));
        Assert.assertEquals((String)"byte -> Byte.class", Byte.class, (Object)ClassUtils.primitiveToWrapper(Byte.TYPE));
        Assert.assertEquals((String)"char -> Character.class", Character.class, (Object)ClassUtils.primitiveToWrapper(Character.TYPE));
        Assert.assertEquals((String)"short -> Short.class", Short.class, (Object)ClassUtils.primitiveToWrapper(Short.TYPE));
        Assert.assertEquals((String)"int -> Integer.class", Integer.class, (Object)ClassUtils.primitiveToWrapper(Integer.TYPE));
        Assert.assertEquals((String)"long -> Long.class", Long.class, (Object)ClassUtils.primitiveToWrapper(Long.TYPE));
        Assert.assertEquals((String)"double -> Double.class", Double.class, (Object)ClassUtils.primitiveToWrapper(Double.TYPE));
        Assert.assertEquals((String)"float -> Float.class", Float.class, (Object)ClassUtils.primitiveToWrapper(Float.TYPE));
        Assert.assertEquals((String)"String.class -> String.class", String.class, (Object)ClassUtils.primitiveToWrapper(String.class));
        Assert.assertEquals((String)"ClassUtils.class -> ClassUtils.class", ClassUtils.class, (Object)ClassUtils.primitiveToWrapper(ClassUtils.class));
        Assert.assertEquals((String)"Void.TYPE -> Void.TYPE", Void.TYPE, (Object)ClassUtils.primitiveToWrapper(Void.TYPE));
        Assert.assertNull((String)"null -> null", (Object)ClassUtils.primitiveToWrapper(null));
    }

    @Test
    public void testPrimitivesToWrappers() {
        Assert.assertNull((String)"null -> null", (Object)ClassUtils.primitivesToWrappers((Class[])null));
        Assert.assertTrue((String)"empty -> empty", (boolean)Arrays.equals(ArrayUtils.EMPTY_CLASS_ARRAY, ClassUtils.primitivesToWrappers((Class[])new Class[0])));
        Object[] castNull = ClassUtils.primitivesToWrappers((Class[])new Class[]{null});
        Assert.assertTrue((String)"(Class<?>)null -> [null]", (boolean)Arrays.equals(new Class[]{null}, castNull));
        Assert.assertArrayEquals((String)"empty -> empty", (Object[])ArrayUtils.EMPTY_CLASS_ARRAY, (Object[])ClassUtils.primitivesToWrappers((Class[])ArrayUtils.EMPTY_CLASS_ARRAY));
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, String.class, ClassUtils.class};
        Class[] wrappers = ClassUtils.primitivesToWrappers((Class[])primitives);
        for (int i = 0; i < primitives.length; ++i) {
            Class primitive = primitives[i];
            Class expectedWrapper = ClassUtils.primitiveToWrapper((Class)primitive);
            Assert.assertEquals((String)(primitive + " -> " + expectedWrapper), (Object)expectedWrapper, (Object)wrappers[i]);
        }
        Class[] noPrimitives = new Class[]{String.class, ClassUtils.class, Void.TYPE};
        Assert.assertNotSame((String)"unmodified", (Object)noPrimitives, (Object)ClassUtils.primitivesToWrappers((Class[])noPrimitives));
    }

    @Test
    public void testWrapperToPrimitive() {
        Class[] primitives;
        for (Class primitive : primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            Class wrapperCls = ClassUtils.primitiveToWrapper((Class)primitive);
            Assert.assertFalse((String)"Still primitive", (boolean)wrapperCls.isPrimitive());
            Assert.assertEquals((String)(wrapperCls + " -> " + primitive), (Object)primitive, (Object)ClassUtils.wrapperToPrimitive((Class)wrapperCls));
        }
    }

    @Test
    public void testWrapperToPrimitiveNoWrapper() {
        Assert.assertNull((String)"Wrong result for non wrapper class", (Object)ClassUtils.wrapperToPrimitive(String.class));
    }

    @Test
    public void testWrapperToPrimitiveNull() {
        Assert.assertNull((String)"Wrong result for null class", (Object)ClassUtils.wrapperToPrimitive(null));
    }

    @Test
    public void testWrappersToPrimitives() {
        Class[] classes = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, ClassUtils.class, null};
        Class[] primitives = ClassUtils.wrappersToPrimitives((Class[])classes);
        Assert.assertEquals((String)"Wrong length of result array", (long)classes.length, (long)primitives.length);
        for (int i = 0; i < classes.length; ++i) {
            Class expectedPrimitive = ClassUtils.wrapperToPrimitive((Class)classes[i]);
            Assert.assertEquals((String)(classes[i] + " -> " + expectedPrimitive), (Object)expectedPrimitive, (Object)primitives[i]);
        }
    }

    @Test
    public void testWrappersToPrimitivesNull() {
        Assert.assertNull((String)"Wrong result for null input", (Object)ClassUtils.wrappersToPrimitives((Class[])null));
        Assert.assertTrue((String)"empty -> empty", (boolean)Arrays.equals(ArrayUtils.EMPTY_CLASS_ARRAY, ClassUtils.wrappersToPrimitives((Class[])new Class[0])));
        Object[] castNull = ClassUtils.wrappersToPrimitives((Class[])new Class[]{null});
        Assert.assertTrue((String)"(Class<?>)null -> [null]", (boolean)Arrays.equals(new Class[]{null}, castNull));
    }

    @Test
    public void testWrappersToPrimitivesEmpty() {
        Object[] empty = new Class[]{};
        Assert.assertArrayEquals((String)"Wrong result for empty input", (Object[])empty, (Object[])ClassUtils.wrappersToPrimitives((Class[])empty));
    }

    @Test
    public void testGetClassClassNotFound() throws Exception {
        this.assertGetClassThrowsClassNotFound("bool");
        this.assertGetClassThrowsClassNotFound("bool[]");
        this.assertGetClassThrowsClassNotFound("integer[]");
    }

    @Test
    public void testGetClassInvalidArguments() throws Exception {
        this.assertGetClassThrowsNullPointerException(null);
        this.assertGetClassThrowsClassNotFound("[][][]");
        this.assertGetClassThrowsClassNotFound("[[]");
        this.assertGetClassThrowsClassNotFound("[");
        this.assertGetClassThrowsClassNotFound("java.lang.String][");
        this.assertGetClassThrowsClassNotFound(".hello.world");
        this.assertGetClassThrowsClassNotFound("hello..world");
    }

    @Test
    public void testWithInterleavingWhitespace() throws ClassNotFoundException {
        Assert.assertEquals(int[].class, (Object)ClassUtils.getClass((String)" int [ ] "));
        Assert.assertEquals(long[].class, (Object)ClassUtils.getClass((String)"\rlong\t[\n]\r"));
        Assert.assertEquals(short[].class, (Object)ClassUtils.getClass((String)"\tshort                \t\t[]"));
        Assert.assertEquals(byte[].class, (Object)ClassUtils.getClass((String)"byte[\t\t\n\r]   "));
    }

    @Test
    public void testGetInnerClass() throws ClassNotFoundException {
        Assert.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest.Inner.DeeplyNested"));
        Assert.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest.Inner$DeeplyNested"));
        Assert.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest$Inner$DeeplyNested"));
        Assert.assertEquals(Inner.DeeplyNested.class, (Object)ClassUtils.getClass((String)"org.apache.commons.lang3.ClassUtilsTest$Inner.DeeplyNested"));
    }

    @Test
    public void testGetClassByNormalNameArrays() throws ClassNotFoundException {
        Assert.assertEquals(int[].class, (Object)ClassUtils.getClass((String)"int[]"));
        Assert.assertEquals(long[].class, (Object)ClassUtils.getClass((String)"long[]"));
        Assert.assertEquals(short[].class, (Object)ClassUtils.getClass((String)"short[]"));
        Assert.assertEquals(byte[].class, (Object)ClassUtils.getClass((String)"byte[]"));
        Assert.assertEquals(char[].class, (Object)ClassUtils.getClass((String)"char[]"));
        Assert.assertEquals(float[].class, (Object)ClassUtils.getClass((String)"float[]"));
        Assert.assertEquals(double[].class, (Object)ClassUtils.getClass((String)"double[]"));
        Assert.assertEquals(boolean[].class, (Object)ClassUtils.getClass((String)"boolean[]"));
        Assert.assertEquals(String[].class, (Object)ClassUtils.getClass((String)"java.lang.String[]"));
        Assert.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"java.util.Map.Entry[]"));
        Assert.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"java.util.Map$Entry[]"));
        Assert.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"[Ljava.util.Map.Entry;"));
        Assert.assertEquals(Map.Entry[].class, (Object)ClassUtils.getClass((String)"[Ljava.util.Map$Entry;"));
    }

    @Test
    public void testGetClassByNormalNameArrays2D() throws ClassNotFoundException {
        Assert.assertEquals(int[][].class, (Object)ClassUtils.getClass((String)"int[][]"));
        Assert.assertEquals(long[][].class, (Object)ClassUtils.getClass((String)"long[][]"));
        Assert.assertEquals(short[][].class, (Object)ClassUtils.getClass((String)"short[][]"));
        Assert.assertEquals(byte[][].class, (Object)ClassUtils.getClass((String)"byte[][]"));
        Assert.assertEquals(char[][].class, (Object)ClassUtils.getClass((String)"char[][]"));
        Assert.assertEquals(float[][].class, (Object)ClassUtils.getClass((String)"float[][]"));
        Assert.assertEquals(double[][].class, (Object)ClassUtils.getClass((String)"double[][]"));
        Assert.assertEquals(boolean[][].class, (Object)ClassUtils.getClass((String)"boolean[][]"));
        Assert.assertEquals(String[][].class, (Object)ClassUtils.getClass((String)"java.lang.String[][]"));
    }

    @Test
    public void testGetClassWithArrayClasses2D() throws Exception {
        this.assertGetClassReturnsClass(String[][].class);
        this.assertGetClassReturnsClass(int[][].class);
        this.assertGetClassReturnsClass(long[][].class);
        this.assertGetClassReturnsClass(short[][].class);
        this.assertGetClassReturnsClass(byte[][].class);
        this.assertGetClassReturnsClass(char[][].class);
        this.assertGetClassReturnsClass(float[][].class);
        this.assertGetClassReturnsClass(double[][].class);
        this.assertGetClassReturnsClass(boolean[][].class);
    }

    @Test
    public void testGetClassWithArrayClasses() throws Exception {
        this.assertGetClassReturnsClass(String[].class);
        this.assertGetClassReturnsClass(int[].class);
        this.assertGetClassReturnsClass(long[].class);
        this.assertGetClassReturnsClass(short[].class);
        this.assertGetClassReturnsClass(byte[].class);
        this.assertGetClassReturnsClass(char[].class);
        this.assertGetClassReturnsClass(float[].class);
        this.assertGetClassReturnsClass(double[].class);
        this.assertGetClassReturnsClass(boolean[].class);
    }

    @Test
    public void testGetClassRawPrimitives() throws ClassNotFoundException {
        Assert.assertEquals(Integer.TYPE, (Object)ClassUtils.getClass((String)"int"));
        Assert.assertEquals(Long.TYPE, (Object)ClassUtils.getClass((String)"long"));
        Assert.assertEquals(Short.TYPE, (Object)ClassUtils.getClass((String)"short"));
        Assert.assertEquals(Byte.TYPE, (Object)ClassUtils.getClass((String)"byte"));
        Assert.assertEquals(Character.TYPE, (Object)ClassUtils.getClass((String)"char"));
        Assert.assertEquals(Float.TYPE, (Object)ClassUtils.getClass((String)"float"));
        Assert.assertEquals(Double.TYPE, (Object)ClassUtils.getClass((String)"double"));
        Assert.assertEquals(Boolean.TYPE, (Object)ClassUtils.getClass((String)"boolean"));
        Assert.assertEquals(Void.TYPE, (Object)ClassUtils.getClass((String)"void"));
    }

    private void assertGetClassReturnsClass(Class<?> c) throws Exception {
        Assert.assertEquals(c, (Object)ClassUtils.getClass((String)c.getName()));
    }

    private void assertGetClassThrowsException(String className, Class<?> exceptionType) throws Exception {
        try {
            ClassUtils.getClass((String)className);
            Assert.fail((String)("ClassUtils.getClass() should fail with an exception of type " + exceptionType.getName() + " when given class name \"" + className + "\"."));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)exceptionType.isAssignableFrom(e.getClass()));
        }
    }

    private void assertGetClassThrowsNullPointerException(String className) throws Exception {
        this.assertGetClassThrowsException(className, NullPointerException.class);
    }

    private void assertGetClassThrowsClassNotFound(String className) throws Exception {
        this.assertGetClassThrowsException(className, ClassNotFoundException.class);
    }

    @Test
    public void testShowJavaBug() throws Exception {
        Set set = Collections.unmodifiableSet(new HashSet());
        Method isEmptyMethod = set.getClass().getMethod("isEmpty", new Class[0]);
        try {
            isEmptyMethod.invoke(set, new Object[0]);
            Assert.fail((String)"Failed to throw IllegalAccessException as expected");
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPublicMethod() throws Exception {
        Set set = Collections.unmodifiableSet(new HashSet());
        Method isEmptyMethod = ClassUtils.getPublicMethod(set.getClass(), (String)"isEmpty", (Class[])new Class[0]);
        Assert.assertTrue((boolean)Modifier.isPublic(isEmptyMethod.getDeclaringClass().getModifiers()));
        try {
            isEmptyMethod.invoke(set, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            Assert.fail((String)"Should not have thrown IllegalAccessException");
        }
        Method toStringMethod = ClassUtils.getPublicMethod(Object.class, (String)"toString", (Class[])new Class[0]);
        Assert.assertEquals((Object)Object.class.getMethod("toString", new Class[0]), (Object)toStringMethod);
    }

    @Test
    public void testToClass_object() {
        Assert.assertNull((Object)ClassUtils.toClass((Object[])null));
        Assert.assertTrue((String)"empty -> empty", (boolean)Arrays.equals(ArrayUtils.EMPTY_CLASS_ARRAY, ClassUtils.toClass((Object[])new Object[0])));
        Object[] castNull = ClassUtils.toClass((Object[])new Object[]{null});
        Assert.assertTrue((String)"(Object)null -> [null]", (boolean)Arrays.equals(new Object[]{null}, castNull));
        Assert.assertSame((Object)ArrayUtils.EMPTY_CLASS_ARRAY, (Object)ClassUtils.toClass((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY));
        Assert.assertTrue((boolean)Arrays.equals(new Class[]{String.class, Integer.class, Double.class}, ClassUtils.toClass((Object[])new Object[]{"Test", 1, 99.0})));
        Assert.assertTrue((boolean)Arrays.equals(new Class[]{String.class, null, Double.class}, ClassUtils.toClass((Object[])new Object[]{"Test", null, 99.0})));
    }

    @Test
    public void test_getShortCanonicalName_Object() {
        Assert.assertEquals((Object)"<null>", (Object)ClassUtils.getShortCanonicalName(null, (String)"<null>"));
        Assert.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortCanonicalName((Object)new ClassUtils(), (String)"<null>"));
        Assert.assertEquals((Object)"ClassUtils[]", (Object)ClassUtils.getShortCanonicalName((Object)new ClassUtils[0], (String)"<null>"));
        Assert.assertEquals((Object)"ClassUtils[][]", (Object)ClassUtils.getShortCanonicalName((Object)new ClassUtils[0][0], (String)"<null>"));
        Assert.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName((Object)new int[0], (String)"<null>"));
        Assert.assertEquals((Object)"int[][]", (Object)ClassUtils.getShortCanonicalName((Object)new int[0][0], (String)"<null>"));
        Assert.assertEquals((Object)"ClassUtilsTest.6", (Object)ClassUtils.getShortCanonicalName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        Assert.assertEquals((Object)"ClassUtilsTest.5Named", (Object)ClassUtils.getShortCanonicalName((Object)new Named(), (String)"<null>"));
        Assert.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortCanonicalName((Object)new Inner(), (String)"<null>"));
    }

    @Test
    public void test_getShortCanonicalName_Class() {
        Assert.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortCanonicalName(ClassUtils.class));
        Assert.assertEquals((Object)"ClassUtils[]", (Object)ClassUtils.getShortCanonicalName(ClassUtils[].class));
        Assert.assertEquals((Object)"ClassUtils[][]", (Object)ClassUtils.getShortCanonicalName(ClassUtils[][].class));
        Assert.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName(int[].class));
        Assert.assertEquals((Object)"int[][]", (Object)ClassUtils.getShortCanonicalName(int[][].class));
        Assert.assertEquals((Object)"ClassUtilsTest.7", (Object)ClassUtils.getShortCanonicalName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assert.assertEquals((Object)"ClassUtilsTest.6Named", (Object)ClassUtils.getShortCanonicalName(Named.class));
        Assert.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortCanonicalName(Inner.class));
    }

    @Test
    public void test_getShortCanonicalName_String() {
        Assert.assertEquals((Object)"ClassUtils", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils"));
        Assert.assertEquals((Object)"ClassUtils[]", (Object)ClassUtils.getShortCanonicalName((String)"[Lorg.apache.commons.lang3.ClassUtils;"));
        Assert.assertEquals((Object)"ClassUtils[][]", (Object)ClassUtils.getShortCanonicalName((String)"[[Lorg.apache.commons.lang3.ClassUtils;"));
        Assert.assertEquals((Object)"ClassUtils[]", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils[]"));
        Assert.assertEquals((Object)"ClassUtils[][]", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtils[][]"));
        Assert.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName((String)"[I"));
        Assert.assertEquals((Object)"int[][]", (Object)ClassUtils.getShortCanonicalName((String)"[[I"));
        Assert.assertEquals((Object)"int[]", (Object)ClassUtils.getShortCanonicalName((String)"int[]"));
        Assert.assertEquals((Object)"int[][]", (Object)ClassUtils.getShortCanonicalName((String)"int[][]"));
        Assert.assertEquals((Object)"ClassUtilsTest.6", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$6"));
        Assert.assertEquals((Object)"ClassUtilsTest.5Named", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$5Named"));
        Assert.assertEquals((Object)"ClassUtilsTest.Inner", (Object)ClassUtils.getShortCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$Inner"));
    }

    @Test
    public void test_getPackageCanonicalName_Object() {
        Assert.assertEquals((Object)"<null>", (Object)ClassUtils.getPackageCanonicalName(null, (String)"<null>"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new ClassUtils(), (String)"<null>"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new ClassUtils[0], (String)"<null>"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new ClassUtils[0][0], (String)"<null>"));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((Object)new int[0], (String)"<null>"));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((Object)new int[0][0], (String)"<null>"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new Object(){}, (String)"<null>"));
        class Named {
            Named() {
            }
        }
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new Named(), (String)"<null>"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((Object)new Inner(), (String)"<null>"));
    }

    @Test
    public void test_getPackageCanonicalName_Class() {
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(ClassUtils.class));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(ClassUtils[].class));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(ClassUtils[][].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName(int[].class));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName(int[][].class));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(new Object(){}.getClass()));
        class Named {
            Named() {
            }
        }
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(Named.class));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName(Inner.class));
    }

    @Test
    public void test_getPackageCanonicalName_String() {
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"[Lorg.apache.commons.lang3.ClassUtils;"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"[[Lorg.apache.commons.lang3.ClassUtils;"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils[]"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtils[][]"));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((String)"[I"));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((String)"[[I"));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((String)"int[]"));
        Assert.assertEquals((Object)"", (Object)ClassUtils.getPackageCanonicalName((String)"int[][]"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$6"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$5Named"));
        Assert.assertEquals((Object)"org.apache.commons.lang3", (Object)ClassUtils.getPackageCanonicalName((String)"org.apache.commons.lang3.ClassUtilsTest$Inner"));
    }

    @Test
    public void testHierarchyIncludingInterfaces() {
        Iterator iter = ClassUtils.hierarchy(StringParameterizedChild.class, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE).iterator();
        Assert.assertEquals(StringParameterizedChild.class, iter.next());
        Assert.assertEquals(GenericParent.class, iter.next());
        Assert.assertEquals(GenericConsumer.class, iter.next());
        Assert.assertEquals(Object.class, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testHierarchyExcludingInterfaces() {
        Iterator iter = ClassUtils.hierarchy(StringParameterizedChild.class).iterator();
        Assert.assertEquals(StringParameterizedChild.class, iter.next());
        Assert.assertEquals(GenericParent.class, iter.next());
        Assert.assertEquals(Object.class, iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    private static class CY
    extends CX
    implements IB,
    IC {
        private CY() {
        }
    }

    private static class CX
    implements IB,
    IA,
    IE {
        private CX() {
        }
    }

    private static interface IF {
    }

    private static interface IE
    extends IF {
    }

    private static interface ID {
    }

    private static interface IC
    extends ID,
    IE {
    }

    private static interface IB {
    }

    private static interface IA {
    }

    private static class Inner {
        private Inner() {
        }

        private class DeeplyNested {
            private DeeplyNested() {
            }
        }
    }
}

